/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import com.unboundid.ldap.sdk.controls.AssertionRequestControl;
import com.unboundid.ldap.sdk.controls.AuthorizationIdentityRequestControl;
import com.unboundid.ldap.sdk.controls.ManageDsaITRequestControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV1RequestControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV2RequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetAuthorizationEntryRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetUserResourceLimitsRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.OperationPurposeRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordPolicyRequestControl;
import com.unboundid.ldap.sdk.unboundidds.extensions.StartAdministrativeSessionExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.StartAdministrativeSessionPostConnectProcessor;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPCompareCSVOutputHandler;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPCompareJSONOutputHandler;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPCompareOutputHandler;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPCompareTabDelimitedOutputHandler;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPPasswordModify;
import com.unboundid.ldap.sdk.unboundidds.tools.ReportBindResultLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.unboundidds.tools.ResultUtils;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.Base64;
import com.unboundid.util.DNFileReader;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.ControlArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.StringArgument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPCompare
extends LDAPCommandLineTool
implements UnsolicitedNotificationHandler {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    @NotNull
    private static final String OUTPUT_FORMAT_CSV = "csv";
    @NotNull
    private static final String OUTPUT_FORMAT_JSON = "json";
    @NotNull
    private static final String OUTPUT_FORMAT_TAB_DELIMITED = "tab-delimited";
    @NotNull
    private final AtomicReference<String> completionMessage = new AtomicReference();
    @Nullable
    private ArgumentParser argumentParser = null;
    @Nullable
    private BooleanArgument authorizationIdentity = null;
    @Nullable
    private BooleanArgument continueOnError = null;
    @Nullable
    private BooleanArgument dryRun = null;
    @Nullable
    private BooleanArgument followReferrals = null;
    @Nullable
    private BooleanArgument getUserResourceLimits = null;
    @Nullable
    private BooleanArgument manageDsaIT = null;
    @Nullable
    private BooleanArgument scriptFriendly = null;
    @Nullable
    private BooleanArgument teeOutput = null;
    @Nullable
    private BooleanArgument terse = null;
    @Nullable
    private BooleanArgument useAdministrativeSession = null;
    @Nullable
    private BooleanArgument useCompareResultCodeAsExitCode = null;
    @Nullable
    private BooleanArgument usePasswordPolicyControl = null;
    @Nullable
    private BooleanArgument verbose = null;
    @Nullable
    private ControlArgument bindControl = null;
    @Nullable
    private ControlArgument compareControl = null;
    @Nullable
    private DNArgument proxyV1As = null;
    @Nullable
    private FileArgument assertionFile = null;
    @Nullable
    private FileArgument dnFile = null;
    @Nullable
    private FileArgument outputFile = null;
    @Nullable
    private FilterArgument assertionFilter = null;
    @Nullable
    private StringArgument getAuthorizationEntryAttribute = null;
    @Nullable
    private StringArgument operationPurpose = null;
    @Nullable
    private StringArgument outputFormat = null;
    @Nullable
    private StringArgument proxyAs = null;

    public static void main(String ... args) {
        ResultCode resultCode = LDAPCompare.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        LDAPCompare tool = new LDAPCompare(out, err);
        return tool.runTool(args);
    }

    public LDAPCompare(@Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "ldapcompare";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return ToolMessages.INFO_LDAPCOMPARE_TOOL_DESCRIPTION_1.get();
    }

    @Override
    @NotNull
    public List<String> getAdditionalDescriptionParagraphs() {
        return Collections.unmodifiableList(Arrays.asList(ToolMessages.INFO_LDAPCOMPARE_TOOL_DESCRIPTION_2.get(), ToolMessages.INFO_LDAPCOMPARE_TOOL_DESCRIPTION_3.get(), ToolMessages.INFO_LDAPCOMPARE_TOOL_DESCRIPTION_4.get(), ToolMessages.INFO_LDAPCOMPARE_TOOL_DESCRIPTION_5.get()));
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.11";
    }

    @Override
    public int getMinTrailingArguments() {
        return 0;
    }

    @Override
    public int getMaxTrailingArguments() {
        return -1;
    }

    @Override
    @NotNull
    public String getTrailingArgumentsPlaceholder() {
        return ToolMessages.INFO_LDAPCOMPARE_TRAILING_ARGS_PLACEHOLDER.get();
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsAuthentication() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    protected boolean supportsSASLHelp() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    @NotNull
    protected List<Control> getBindControls() {
        ArrayList<Control> bindControls = new ArrayList<Control>(10);
        if (this.bindControl.isPresent()) {
            bindControls.addAll(this.bindControl.getValues());
        }
        if (this.authorizationIdentity.isPresent()) {
            bindControls.add(new AuthorizationIdentityRequestControl(false));
        }
        if (this.getAuthorizationEntryAttribute.isPresent()) {
            bindControls.add(new GetAuthorizationEntryRequestControl(true, true, this.getAuthorizationEntryAttribute.getValues()));
        }
        if (this.getUserResourceLimits.isPresent()) {
            bindControls.add(new GetUserResourceLimitsRequestControl());
        }
        if (this.usePasswordPolicyControl.isPresent()) {
            bindControls.add(new PasswordPolicyRequestControl());
        }
        return bindControls;
    }

    @Override
    protected boolean supportsMultipleServers() {
        return true;
    }

    @Override
    protected boolean supportsSSLDebugging() {
        return true;
    }

    @Override
    @NotNull
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setUseSynchronousMode(true);
        options.setFollowReferrals(this.followReferrals.isPresent());
        options.setUnsolicitedNotificationHandler(this);
        options.setResponseTimeoutMillis(0L);
        return options;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return false;
    }

    @Override
    @Nullable
    protected String getToolCompletionMessage() {
        return this.completionMessage.get();
    }

    @Override
    public void addNonLDAPArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.argumentParser = parser;
        this.dnFile = new FileArgument(Character.valueOf('f'), "dnFile", false, 1, null, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_DN_FILE.get(), true, true, true, false);
        this.dnFile.addLongIdentifier("dn-file", true);
        this.dnFile.addLongIdentifier("filename", true);
        this.dnFile.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.dnFile);
        this.assertionFile = new FileArgument(null, "assertionFile", false, 1, null, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_ASSERTION_FILE.get(), true, true, true, false);
        this.assertionFile.addLongIdentifier("assertion-file", true);
        this.assertionFile.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.assertionFile);
        this.followReferrals = new BooleanArgument(null, "followReferrals", 1, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_FOLLOW_REFERRALS.get());
        this.followReferrals.addLongIdentifier("follow-referrals", true);
        this.followReferrals.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.followReferrals);
        this.useAdministrativeSession = new BooleanArgument(null, "useAdministrativeSession", 1, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_USE_ADMIN_SESSION.get());
        this.useAdministrativeSession.addLongIdentifier("use-administrative-session", true);
        this.useAdministrativeSession.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.useAdministrativeSession);
        this.continueOnError = new BooleanArgument(Character.valueOf('c'), "continueOnError", 1, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_CONTINUE_ON_ERROR.get());
        this.continueOnError.addLongIdentifier("continue-on-error", true);
        this.continueOnError.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.continueOnError);
        this.dryRun = new BooleanArgument(Character.valueOf('n'), "dryRun", 1, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_DRY_RUN.get());
        this.dryRun.addLongIdentifier("dry-run", true);
        this.dryRun.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.dryRun);
        this.bindControl = new ControlArgument(null, "bindControl", false, 0, null, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_BIND_CONTROL.get());
        this.bindControl.addLongIdentifier("bind-control", true);
        this.bindControl.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_BIND_CONTROLS.get());
        parser.addArgument(this.bindControl);
        this.authorizationIdentity = new BooleanArgument(Character.valueOf('E'), "authorizationIdentity", 1, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_AUTHZ_IDENTITY.get());
        this.authorizationIdentity.addLongIdentifier("authorization-identity", true);
        this.authorizationIdentity.addLongIdentifier("useAuthorizationIdentity", true);
        this.authorizationIdentity.addLongIdentifier("use-authorization-identity", true);
        this.authorizationIdentity.addLongIdentifier("useAuthorizationIdentityControl", true);
        this.authorizationIdentity.addLongIdentifier("use-authorization-identity-control", true);
        this.authorizationIdentity.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_BIND_CONTROLS.get());
        parser.addArgument(this.authorizationIdentity);
        this.usePasswordPolicyControl = new BooleanArgument(null, "usePasswordPolicyControl", 1, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_USE_PW_POLICY_CONTROL.get());
        this.usePasswordPolicyControl.addLongIdentifier("use-password-policy-control", true);
        this.usePasswordPolicyControl.addLongIdentifier("passwordPolicyControl", true);
        this.usePasswordPolicyControl.addLongIdentifier("password-policy-control", true);
        this.usePasswordPolicyControl.addLongIdentifier("passwordPolicy", true);
        this.usePasswordPolicyControl.addLongIdentifier("password-policy", true);
        this.usePasswordPolicyControl.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_BIND_CONTROLS.get());
        parser.addArgument(this.usePasswordPolicyControl);
        this.getAuthorizationEntryAttribute = new StringArgument(null, "getAuthorizationEntryAttribute", false, 0, ToolMessages.INFO_LDAPCOMPARE_ARG_PLACEHOLDER_ATTRIBUTE.get(), ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_GET_AUTHZ_ENTRY_ATTR.get());
        this.getAuthorizationEntryAttribute.addLongIdentifier("get-authorization-entry-attribute", true);
        this.getAuthorizationEntryAttribute.addLongIdentifier("getAuthzEntryAttribute", true);
        this.getAuthorizationEntryAttribute.addLongIdentifier("get-authz-entry-attribute", true);
        this.getAuthorizationEntryAttribute.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_BIND_CONTROLS.get());
        parser.addArgument(this.getAuthorizationEntryAttribute);
        this.getUserResourceLimits = new BooleanArgument(null, "getUserResourceLimits", 1, ToolMessages.INFO_LDAPCOMPARE_ARG_PLACEHOLDER_GET_USER_RESOURCE_LIMITS.get());
        this.getUserResourceLimits.addLongIdentifier("get-user-resource-limits", true);
        this.getUserResourceLimits.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_BIND_CONTROLS.get());
        parser.addArgument(this.getUserResourceLimits);
        this.compareControl = new ControlArgument(Character.valueOf('J'), "compareControl", false, 0, null, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_COMPARE_CONTROL.get());
        this.compareControl.addLongIdentifier("compare-control", true);
        this.compareControl.addLongIdentifier("control", true);
        this.compareControl.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_COMPARE_CONTROLS.get());
        parser.addArgument(this.compareControl);
        this.proxyAs = new StringArgument(Character.valueOf('Y'), "proxyAs", false, 1, ToolMessages.INFO_LDAPCOMPARE_ARG_PLACEHOLDER_AUTHZ_ID.get(), ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_PROXY_AS.get());
        this.proxyAs.addLongIdentifier("proxy-as", true);
        this.proxyAs.addLongIdentifier("proxyV2As", true);
        this.proxyAs.addLongIdentifier("proxy-v2-as", true);
        this.proxyAs.addLongIdentifier("proxyV2", true);
        this.proxyAs.addLongIdentifier("proxy-v2", true);
        this.proxyAs.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_COMPARE_CONTROLS.get());
        parser.addArgument(this.proxyAs);
        this.proxyV1As = new DNArgument(null, "proxyV1As", false, 1, null, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_PROXY_V1_AS.get());
        this.proxyV1As.addLongIdentifier("proxy-v1-as", true);
        this.proxyV1As.addLongIdentifier("proxyV1", true);
        this.proxyV1As.addLongIdentifier("proxy-v1", true);
        this.proxyV1As.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_COMPARE_CONTROLS.get());
        parser.addArgument(this.proxyV1As);
        this.manageDsaIT = new BooleanArgument(null, "manageDsaIT", 1, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_MANAGE_DSA_IT.get());
        this.manageDsaIT.addLongIdentifier("manage-dsa-it", true);
        this.manageDsaIT.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_COMPARE_CONTROLS.get());
        parser.addArgument(this.manageDsaIT);
        this.assertionFilter = new FilterArgument(null, "assertionFilter", false, 1, null, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_ASSERTION_FILTER.get());
        this.assertionFilter.addLongIdentifier("assertion-filter", true);
        this.assertionFilter.addLongIdentifier("assertionControlFilter", true);
        this.assertionFilter.addLongIdentifier("assertion-control-filter", true);
        this.assertionFilter.addLongIdentifier("useAssertionControl", true);
        this.assertionFilter.addLongIdentifier("use-assertion-control", true);
        this.assertionFilter.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_COMPARE_CONTROLS.get());
        parser.addArgument(this.assertionFilter);
        this.operationPurpose = new StringArgument(null, "operationPurpose", false, 1, ToolMessages.INFO_LDAPCOMPARE_ARG_PLACEHOLDER_PURPOSE.get(), ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_OPERATION_PURPOSE.get());
        this.operationPurpose.addLongIdentifier("operation-purpose", true);
        this.operationPurpose.addLongIdentifier("purpose", true);
        this.operationPurpose.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_COMPARE_CONTROLS.get());
        parser.addArgument(this.operationPurpose);
        this.outputFile = new FileArgument(null, "outputFile", false, 1, null, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_OUTPUT_FILE.get(), false, true, true, false);
        this.outputFile.addLongIdentifier("output-file", true);
        this.outputFile.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.outputFile);
        this.teeOutput = new BooleanArgument(null, "teeOutput", 1, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_TEE_OUTPUT.get());
        this.teeOutput.addLongIdentifier("tee-output", true);
        this.teeOutput.addLongIdentifier("tee", true);
        this.teeOutput.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.teeOutput);
        this.outputFormat = new StringArgument(null, "outputFormat", false, 1, ToolMessages.INFO_LDAPCOMPARE_ARG_PLACEHOLDER_FORMAT.get(), ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_OUTPUT_FORMAT.get(), StaticUtils.setOf(OUTPUT_FORMAT_TAB_DELIMITED, OUTPUT_FORMAT_CSV, OUTPUT_FORMAT_JSON), OUTPUT_FORMAT_TAB_DELIMITED);
        this.outputFormat.addLongIdentifier("output-format", true);
        this.outputFormat.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.outputFormat);
        this.scriptFriendly = new BooleanArgument(null, "scriptFriendly", 1, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_SCRIPT_FRIENDLY.get());
        this.scriptFriendly.addLongIdentifier("script-friendly", true);
        this.scriptFriendly.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_OUTPUT.get());
        this.scriptFriendly.setHidden(true);
        parser.addArgument(this.scriptFriendly);
        this.verbose = new BooleanArgument(Character.valueOf('v'), "verbose", 1, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_VERBOSE.get());
        this.verbose.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.verbose);
        this.terse = new BooleanArgument(null, "terse", 1, ToolMessages.INFO_LDAPCOMPARE_ARG_DESCRIPTION_TERSE.get());
        this.terse.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.terse);
        this.useCompareResultCodeAsExitCode = new BooleanArgument(null, "useCompareResultCodeAsExitCode", 1, ToolMessages.INFO_LDAPCOMPARE_ARG_DESC_USE_COMPARE_RESULT_CODE_AS_EXIT_CODE.get());
        this.useCompareResultCodeAsExitCode.addLongIdentifier("use-compare-result-code-as-exit-code", true);
        this.useCompareResultCodeAsExitCode.addLongIdentifier("useCompareResultCode", true);
        this.useCompareResultCodeAsExitCode.addLongIdentifier("use-compare-result-code", true);
        this.useCompareResultCodeAsExitCode.setArgumentGroupName(ToolMessages.INFO_LDAPCOMPARE_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.useCompareResultCodeAsExitCode);
        parser.addExclusiveArgumentSet(this.dnFile, this.assertionFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.proxyAs, this.proxyV1As, new Argument[0]);
        parser.addDependentArgumentSet(this.teeOutput, this.outputFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.verbose, this.terse, new Argument[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        List<CompareRequest> compareRequests;
        try {
            compareRequests = this.getCompareRequests();
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            this.logCompletionMessage(true, e.getMessage());
            return e.getResultCode();
        }
        LDAPConnectionPool pool = null;
        PrintStream writer = null;
        try {
            LDAPCompareOutputHandler outputHandler;
            StartAdministrativeSessionPostConnectProcessor p = this.useAdministrativeSession.isPresent() ? new StartAdministrativeSessionPostConnectProcessor(new StartAdministrativeSessionExtendedRequest(this.getToolName(), true, new Control[0])) : null;
            pool = this.getConnectionPool(1, 2, 0, p, null, true, new ReportBindResultLDAPConnectionPoolHealthCheck(this, true, this.verbose.isPresent()));
            pool.setRetryFailedOperationsDueToInvalidConnections(true);
            if (this.outputFile.isPresent()) {
                try {
                    writer = new PrintStream(this.outputFile.getValue());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.logCompletionMessage(true, ToolMessages.ERR_LDAPCOMPARE_CANNOT_OPEN_OUTPUT_FILE.get(this.outputFile.getValue().getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                    ResultCode resultCode = ResultCode.LOCAL_ERROR;
                    if (pool != null) {
                        pool.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                    return resultCode;
                }
            } else {
                writer = null;
            }
            switch (StaticUtils.toLowerCase(this.outputFormat.getValue())) {
                case "csv": {
                    outputHandler = new LDAPCompareCSVOutputHandler();
                    break;
                }
                case "json": {
                    outputHandler = new LDAPCompareJSONOutputHandler();
                    break;
                }
                default: {
                    outputHandler = new LDAPCompareTabDelimitedOutputHandler();
                }
            }
            if (!this.terse.isPresent()) {
                for (String line : outputHandler.getHeaderLines()) {
                    if (writer != null) {
                        writer.println(line);
                    }
                    if (writer != null && !this.teeOutput.isPresent()) continue;
                    this.out(line);
                }
            }
            ResultCode resultCode = null;
            int numTrue = 0;
            int numFalse = 0;
            int numErrors = 0;
            for (CompareRequest compareRequest : compareRequests) {
                LDAPResult compareResult;
                try {
                    compareResult = pool.compare(compareRequest);
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    compareResult = e.toLDAPResult();
                }
                try {
                    this.writeResult(writer, outputHandler, compareRequest, compareResult);
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    this.logCompletionMessage(true, e.getMessage());
                    ResultCode resultCode2 = e.getResultCode();
                    if (pool != null) {
                        pool.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                    return resultCode2;
                }
                ResultCode compareResultCode = compareResult.getResultCode();
                if (compareResultCode == ResultCode.COMPARE_TRUE) {
                    ++numTrue;
                    if (resultCode == null) {
                        resultCode = ResultCode.COMPARE_TRUE;
                    }
                    continue;
                }
                if (compareResultCode == ResultCode.COMPARE_FALSE) {
                    ++numFalse;
                    if (resultCode == null) {
                        resultCode = ResultCode.COMPARE_FALSE;
                    }
                    continue;
                }
                ++numErrors;
                if (resultCode == null || resultCode == ResultCode.COMPARE_TRUE || resultCode == ResultCode.COMPARE_FALSE) {
                    resultCode = compareResultCode;
                }
                if (this.continueOnError.isPresent()) continue;
                ResultCode resultCode3 = resultCode;
                return resultCode3;
            }
            if (resultCode == ResultCode.COMPARE_TRUE) {
                if (compareRequests.size() > 1) {
                    resultCode = ResultCode.SUCCESS;
                    this.logCompletionMessage(false, ToolMessages.INFO_LDAPCOMPARE_RESULT_ALL_SUCCEEDED.get(numTrue, numFalse));
                } else {
                    if (!this.useCompareResultCodeAsExitCode.isPresent()) {
                        resultCode = ResultCode.SUCCESS;
                    }
                    this.logCompletionMessage(false, ToolMessages.INFO_LDAPCOMPARE_RESULT_COMPARE_MATCHED.get());
                }
            } else if (resultCode == ResultCode.COMPARE_FALSE) {
                if (compareRequests.size() > 1) {
                    resultCode = ResultCode.SUCCESS;
                    this.logCompletionMessage(false, ToolMessages.INFO_LDAPCOMPARE_RESULT_ALL_SUCCEEDED.get(numTrue, numFalse));
                } else {
                    if (!this.useCompareResultCodeAsExitCode.isPresent()) {
                        resultCode = ResultCode.SUCCESS;
                    }
                    this.logCompletionMessage(false, ToolMessages.INFO_LDAPCOMPARE_RESULT_COMPARE_DID_NOT_MATCH.get());
                }
            } else if (compareRequests.size() > 1) {
                this.logCompletionMessage(true, ToolMessages.ERR_LDAPCOMPARE_RESULT_WITH_ERRORS.get(numErrors, numTrue, numFalse));
            } else {
                this.logCompletionMessage(true, ToolMessages.ERR_LDAPCOMPARE_RESULT_FAILED.get());
            }
            ResultCode resultCode4 = resultCode;
            return resultCode4;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            if (le.getResultCode() != ResultCode.INVALID_CREDENTIALS) {
                for (String line : ResultUtils.formatResult(le, true, 0, WRAP_COLUMN)) {
                    this.err(line);
                }
            }
            ResultCode resultCode = le.getResultCode();
            return resultCode;
        }
        finally {
            if (pool != null) {
                pool.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    @NotNull
    private List<CompareRequest> getCompareRequests() throws LDAPException {
        List<String> trailingArgs = this.argumentParser.getTrailingArguments();
        int numTrailingArgs = trailingArgs.size();
        if (this.assertionFile.isPresent()) {
            if (numTrailingArgs != 0) {
                throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_LDAPCOMPARE_TRAILING_ARGS_WITH_ASSERTION_FILE.get(this.assertionFile.getIdentifierString()));
            }
            return this.readAssertionFile(this.getCompareControls());
        }
        if (this.dnFile.isPresent()) {
            if (numTrailingArgs != 1) {
                throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_LDAPCOMPARE_INVALID_TRAILING_ARG_COUNT_WITH_DN_FILE.get(this.dnFile.getIdentifierString()));
            }
            ObjectPair<String, byte[]> ava = LDAPCompare.parseAttributeValueAssertion(trailingArgs.get(0));
            return this.readDNFile(ava.getFirst(), ava.getSecond(), this.getCompareControls());
        }
        if (numTrailingArgs < 2) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_LDAPCOMPARE_INVALID_TRAILING_ARG_COUNT_WITHOUT_FILE.get(this.dnFile.getIdentifierString(), this.assertionFile.getIdentifierString()));
        }
        Iterator<String> trailingArgsIterator = trailingArgs.iterator();
        ObjectPair<String, byte[]> ava = LDAPCompare.parseAttributeValueAssertion(trailingArgsIterator.next());
        String attributeName = ava.getFirst();
        byte[] assertionValue = ava.getSecond();
        Control[] controls = this.getCompareControls();
        ArrayList<CompareRequest> requests = new ArrayList<CompareRequest>(numTrailingArgs - 1);
        while (trailingArgsIterator.hasNext()) {
            String dnString = trailingArgsIterator.next();
            try {
                new DN(dnString);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_LDAPCOMPARE_MALFORMED_TRAILING_ARG_DN.get(dnString, e.getMessage()), e);
            }
            requests.add(new CompareRequest(dnString, attributeName, assertionValue, controls));
        }
        return requests;
    }

    @NotNull
    private static ObjectPair<String, byte[]> parseAttributeValueAssertion(@NotNull String avaString) throws LDAPException {
        int colonPos = avaString.indexOf(58);
        if (colonPos < 0) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_LDAPCOMPARE_AVA_NO_COLON.get(avaString));
        }
        if (colonPos == 0) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_LDAPCOMPARE_AVA_NO_ATTR.get(avaString));
        }
        String attributeName = avaString.substring(0, colonPos);
        if (colonPos == avaString.length() - 1) {
            return new ObjectPair<String, byte[]>(attributeName, StaticUtils.NO_BYTES);
        }
        if (avaString.charAt(colonPos + 1) == ':') {
            try {
                byte[] avaBytes = Base64.decode(avaString.substring(colonPos + 2));
                return new ObjectPair<String, byte[]>(attributeName, avaBytes);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_LDAPCOMPARE_AVA_CANNOT_BASE64_DECODE_VALUE.get(avaString, e.getMessage()), e);
            }
        }
        if (avaString.charAt(colonPos + 1) == '<') {
            String path = avaString.substring(colonPos + 2);
            File file = new File(path);
            if (file.exists()) {
                try {
                    byte[] fileBytes = StaticUtils.readFileBytes(file);
                    return new ObjectPair<String, byte[]>(attributeName, fileBytes);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_LDAPCOMPARE_AVA_CANNOT_READ_FILE.get(avaString, file.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
                }
            }
            throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_LDAPCOMPARE_AVA_NO_SUCH_FILE.get(avaString, file.getAbsolutePath()));
        }
        return new ObjectPair<String, byte[]>(attributeName, StaticUtils.getBytes(avaString.substring(colonPos + 1)));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private List<CompareRequest> readAssertionFile(@NotNull Control[] controls) throws LDAPException {
        f = this.assertionFile.getValue();
        try {
            fileReader = new FileReader(f);
            var4_5 = null;
            try {
                bufferedReader = new BufferedReader(fileReader);
                var6_8 = null;
                lineNumber = 0;
                compareRequests = new ArrayList<CompareRequest>();
lbl11:
                // 3 sources

                while (true) {
                    line = bufferedReader.readLine();
                    if (line != null) ** GOTO lbl43
                    if (compareRequests.isEmpty()) {
                        throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_LDAPCOMPARE_ASSERTION_FILE_EMPTY.get(new Object[]{f.getAbsolutePath()}));
                    }
                    var10_14 = compareRequests;
                    if (bufferedReader == null) return var10_14;
                    if (var6_8 != null) {
                    }
                    ** GOTO lbl41
                    break;
                }
                {
                    catch (Throwable var7_10) {
                        var6_8 = var7_10;
                        throw var7_10;
                    }
                    catch (Throwable var15_23) {
                        if (bufferedReader == null) throw var15_23;
                        if (var6_8 == null) {
                            bufferedReader.close();
                            throw var15_23;
                        }
                        try {
                            bufferedReader.close();
                            throw var15_23;
                        }
                        catch (Throwable x2) {
                            var6_8.addSuppressed(x2);
                            throw var15_23;
                        }
                    }
                    try {
                        bufferedReader.close();
                        return var10_14;
                    }
                    catch (Throwable x2) {
                        var6_8.addSuppressed(x2);
                        return var10_14;
                    }
lbl41:
                    // 1 sources

                    bufferedReader.close();
                    return var10_14;
lbl43:
                    // 1 sources

                    ** try [egrp 6[TRYBLOCK] [10 : 169->587)] { 
lbl-1000:
                    // 1 sources

                    {
                        ++lineNumber;
                        if (line.isEmpty() || line.startsWith("#")) ** GOTO lbl11
                        tabPos = line.indexOf(9);
                        if (tabPos < 0) {
                            throw new LDAPException(ResultCode.DECODING_ERROR, ToolMessages.ERR_LDAPCOMPARE_ASSERTION_FILE_LINE_MISSING_TAB.get(new Object[]{line, lineNumber, f.getAbsolutePath()}));
                        }
                        dn = line.substring(0, tabPos);
                        try {
                            new DN(dn);
                        }
                        catch (LDAPException e) {
                            Debug.debugException(e);
                            throw new LDAPException(ResultCode.DECODING_ERROR, ToolMessages.ERR_LDAPCOMPARE_ASSERTION_FILE_LINE_INVALID_DN.get(new Object[]{line, lineNumber, f.getAbsolutePath(), dn, e.getMessage()}), e);
                        }
                        for (i = tabPos + 1; i < line.length(); ++i) {
                            if (line.charAt(i) != '\t') continue;
                            tabPos = i;
                        }
                        avaString = line.substring(tabPos + 1);
                        if (avaString.isEmpty()) {
                            throw new LDAPException(ResultCode.DECODING_ERROR, ToolMessages.ERR_LDAPCOMPARE_ASSERTION_FILE_LINE_MISSING_AVA.get(new Object[]{line, lineNumber, f.getAbsolutePath()}));
                        }
                        try {
                            ava = LDAPCompare.parseAttributeValueAssertion(avaString);
                        }
                        catch (LDAPException e) {
                            Debug.debugException(e);
                            throw new LDAPException(ResultCode.DECODING_ERROR, ToolMessages.ERR_LDAPCOMPARE_ASSERTION_FILE_CANNOT_PARSE_AVA.get(new Object[]{line, lineNumber, f.getAbsolutePath(), e.getMessage()}), e);
                        }
                        compareRequests.add(new CompareRequest(dn, ava.getFirst(), ava.getSecond(), controls));
                        ** continue;
                    }
                }
            }
lbl73:
            // 2 sources

            catch (Throwable var5_7) {
                var4_5 = var5_7;
                throw var5_7;
            }
            finally {
                if (fileReader != null) {
                    if (var4_5 != null) {
                        try {
                            fileReader.close();
                        }
                        catch (Throwable x2) {
                            var4_5.addSuppressed(x2);
                        }
                    } else {
                        fileReader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_LDAPCOMPARE_CANNOT_READ_ASSERTION_FILE.get(new Object[]{f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)}), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private List<CompareRequest> readDNFile(@NotNull String attributeName, @NotNull byte[] assertionValue, @NotNull Control[] controls) throws LDAPException {
        try (DNFileReader dnFileReader = new DNFileReader(this.dnFile.getValue());){
            ArrayList<CompareRequest> compareRequests = new ArrayList<CompareRequest>();
            while (true) {
                DN dn;
                try {
                    dn = dnFileReader.readDN();
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.DECODING_ERROR, e.getMessage(), e);
                }
                if (dn == null) {
                    if (compareRequests.isEmpty()) {
                        throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_LDAPCOMPARE_DN_FILE_EMPTY.get(this.dnFile.getValue().getAbsolutePath()));
                    }
                    ArrayList<CompareRequest> arrayList = compareRequests;
                    return arrayList;
                }
                compareRequests.add(new CompareRequest(dn, attributeName, assertionValue, controls));
                continue;
                break;
            }
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_LDAPCOMPARE_CANNOT_READ_DN_FILE.get(this.dnFile.getValue().getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private Control[] getCompareControls() throws LDAPException {
        ArrayList<Control> controls = new ArrayList<Control>();
        if (this.compareControl.isPresent()) {
            controls.addAll(this.compareControl.getValues());
        }
        if (this.proxyAs.isPresent()) {
            controls.add(new ProxiedAuthorizationV2RequestControl(this.proxyAs.getValue()));
        }
        if (this.proxyV1As.isPresent()) {
            controls.add(new ProxiedAuthorizationV1RequestControl(this.proxyV1As.getValue()));
        }
        if (this.manageDsaIT.isPresent()) {
            controls.add(new ManageDsaITRequestControl(false));
        }
        if (this.assertionFilter.isPresent()) {
            controls.add(new AssertionRequestControl(this.assertionFilter.getValue()));
        }
        if (this.operationPurpose.isPresent()) {
            controls.add(new OperationPurposeRequestControl(false, this.getToolName(), this.getToolVersion(), LDAPPasswordModify.class.getName() + ".getUpdateControls", this.operationPurpose.getValue()));
        }
        return controls.toArray(StaticUtils.NO_CONTROLS);
    }

    private void writeResult(@Nullable PrintStream writer, @NotNull LDAPCompareOutputHandler outputHandler, @NotNull CompareRequest request, @NotNull LDAPResult result) throws LDAPException {
        if (this.shouldWriteResultToStdErr(result)) {
            this.err(new Object[0]);
            this.err(ToolMessages.INFO_LDAPCOMPARE_RESULT_HEADER.get());
            this.err(ToolMessages.INFO_LDAPCOMPARE_RESULT_HEADER_DN.get(request.getDN()));
            this.err(ToolMessages.INFO_LDAPCOMPARE_RESULT_HEADER_ATTR.get(request.getAttributeName()));
            this.err(ToolMessages.INFO_LDAPCOMPARE_RESULT_HEADER_VALUE.get(request.getAssertionValue()));
            for (String line : ResultUtils.formatResult(result, true, 0, WRAP_COLUMN)) {
                this.err(line);
            }
        }
        String message = outputHandler.formatResult(request, result);
        if (writer != null) {
            writer.println(message);
        }
        if (writer == null || this.teeOutput.isPresent()) {
            this.out(message);
        }
    }

    private boolean shouldWriteResultToStdErr(@NotNull LDAPResult result) {
        if (this.verbose.isPresent()) {
            return true;
        }
        if (this.terse.isPresent()) {
            return false;
        }
        if (result.hasResponseControl()) {
            return true;
        }
        return result.getResultCode() != ResultCode.COMPARE_TRUE && result.getResultCode() != ResultCode.COMPARE_FALSE;
    }

    private void logCompletionMessage(boolean isError, @NotNull String message) {
        this.completionMessage.compareAndSet(null, message);
        if (!this.terse.isPresent()) {
            if (isError) {
                this.wrapErr(0, WRAP_COLUMN, message);
            } else {
                this.wrapOut(0, WRAP_COLUMN, message);
            }
        }
    }

    @Override
    public void handleUnsolicitedNotification(@NotNull LDAPConnection connection, @NotNull ExtendedResult notification) {
        if (!this.terse.isPresent()) {
            ArrayList<String> lines = new ArrayList<String>(10);
            ResultUtils.formatUnsolicitedNotification(lines, notification, true, 0, WRAP_COLUMN);
            for (String line : lines) {
                this.err(line);
            }
            this.err(new Object[0]);
        }
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        examples.put(new String[]{"--hostname", "ds.example.com", "--port", "636", "--useSSL", "--bindDN", "uid=admin,dc=example,dc=com", "l:Austin", "uid=jdoe,ou=People,dc=example,dc=com"}, ToolMessages.INFO_LDAPCOMPARE_EXAMPLE_1.get());
        examples.put(new String[]{"--hostname", "ds.example.com", "--port", "636", "--useSSL", "--bindDN", "uid=admin,dc=example,dc=com", "--dnFile", "entry-dns.txt", "--outputFormat", OUTPUT_FORMAT_CSV, "--terse", "title:manager"}, ToolMessages.INFO_LDAPCOMPARE_EXAMPLE_2.get());
        examples.put(new String[]{"--hostname", "ds.example.com", "--port", "636", "--useSSL", "--bindDN", "uid=admin,dc=example,dc=com", "--assertionFile", "compare-assertions.txt", "--outputFormat", OUTPUT_FORMAT_JSON, "--outputFile", "compare-assertion-results.json", "--verbose"}, ToolMessages.INFO_LDAPCOMPARE_EXAMPLE_3.get());
        return examples;
    }
}

