/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class StartAdministrativeSessionExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String START_ADMIN_SESSION_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.13";
    private static final byte TYPE_CLIENT_NAME = -128;
    private static final byte TYPE_USE_DEDICATED_THREAD_POOL = -127;
    private static final long serialVersionUID = -2684374559100906505L;
    private final boolean useDedicatedThreadPool;
    @Nullable
    private final String clientName;

    public StartAdministrativeSessionExtendedRequest(@Nullable String clientName, boolean useDedicatedThreadPool, Control ... controls) {
        super(START_ADMIN_SESSION_REQUEST_OID, StartAdministrativeSessionExtendedRequest.encodeValue(clientName, useDedicatedThreadPool), controls);
        this.clientName = clientName;
        this.useDedicatedThreadPool = useDedicatedThreadPool;
    }

    public StartAdministrativeSessionExtendedRequest(@NotNull ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        ASN1OctetString value = extendedRequest.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_START_ADMIN_SESSION_REQUEST_NO_VALUE.get());
        }
        String appName = null;
        boolean dedicatedPool = false;
        try {
            ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(value.getValue());
            block7: for (ASN1Element e : valueSequence.elements()) {
                switch (e.getType()) {
                    case -128: {
                        appName = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block7;
                    }
                    case -127: {
                        dedicatedPool = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block7;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_START_ADMIN_SESSION_REQUEST_UNKNOWN_VALUE_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_START_ADMIN_SESSION_REQUEST_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        this.clientName = appName;
        this.useDedicatedThreadPool = dedicatedPool;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@Nullable String clientName, boolean useDedicatedThreadPool) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        if (clientName != null) {
            elements.add(new ASN1OctetString(-128, clientName));
        }
        if (useDedicatedThreadPool) {
            elements.add(new ASN1Boolean(-127, true));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Nullable
    public String getClientName() {
        return this.clientName;
    }

    public boolean useDedicatedThreadPool() {
        return this.useDedicatedThreadPool;
    }

    @Override
    @NotNull
    public StartAdministrativeSessionExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public StartAdministrativeSessionExtendedRequest duplicate(@Nullable Control[] controls) {
        StartAdministrativeSessionExtendedRequest r = new StartAdministrativeSessionExtendedRequest(this.clientName, this.useDedicatedThreadPool, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        r.setIntermediateResponseListener(this.getIntermediateResponseListener());
        r.setReferralDepth(this.getReferralDepth());
        r.setReferralConnector(this.getReferralConnectorInternal());
        return r;
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_START_ADMIN_SESSION.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("StartAdministrativeSessionExtendedRequest(");
        if (this.clientName != null) {
            buffer.append("clientName='");
            buffer.append(this.clientName);
            buffer.append("', ");
        }
        buffer.append("useDedicatedThreadPool=");
        buffer.append(this.useDedicatedThreadPool);
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

