/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logging.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.MemoryMappedFileAppender;
import org.apache.logging.log4j.core.appender.RandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.slf4j.Log4jLoggerFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logging.CasAppender;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Endpoint(id="loggingConfig", defaultAccess=Access.NONE)
public class LoggingConfigurationEndpoint
extends BaseCasRestActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingConfigurationEndpoint.class);
    private static final String LOGGER_NAME_ROOT = "root";
    private static final String FILE_PARAM = "file";
    private static final String FILE_PATTERN_PARAM = "filePattern";
    private LoggerContext loggerContext;
    private Resource logConfigurationFile;

    public LoggingConfigurationEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
        super(casProperties, applicationContext);
    }

    @GetMapping(produces={"application/json"})
    @Operation(summary="Get logging configuration report")
    public Map<String, Object> configuration() {
        this.initializeIfNecessary();
        HashSet configuredLoggers = new HashSet();
        this.getLoggerConfigurations().forEach(config -> {
            HashMap<String, Object> loggerMap = new HashMap<String, Object>();
            loggerMap.put("name", StringUtils.defaultIfBlank((CharSequence)config.getName(), (CharSequence)LOGGER_NAME_ROOT));
            loggerMap.put("state", config.getState());
            if (config.getPropertyList() != null) {
                loggerMap.put("properties", config.getPropertyList());
            }
            loggerMap.put("additive", config.isAdditive());
            loggerMap.put("level", config.getLevel().name());
            HashSet appenders = new HashSet();
            config.getAppenders().keySet().stream().map(key -> (Appender)config.getAppenders().get(key)).forEach(appender -> {
                FileAppender app;
                ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE);
                builder.append("name", (Object)appender.getName());
                builder.append("state", (Object)appender.getState());
                builder.append("layoutFormat", (Object)appender.getLayout().getContentFormat());
                builder.append("layoutContentType", (Object)appender.getLayout().getContentType());
                if (appender instanceof FileAppender) {
                    app = (FileAppender)appender;
                    builder.append(FILE_PARAM, (Object)app.getFileName());
                    builder.append(FILE_PATTERN_PARAM, (Object)"(none)");
                }
                if (appender instanceof RandomAccessFileAppender) {
                    app = (RandomAccessFileAppender)appender;
                    builder.append(FILE_PARAM, (Object)app.getFileName());
                    builder.append(FILE_PATTERN_PARAM, (Object)"(none)");
                }
                if (appender instanceof RollingFileAppender) {
                    app = (RollingFileAppender)appender;
                    builder.append(FILE_PARAM, (Object)app.getFileName());
                    builder.append(FILE_PATTERN_PARAM, (Object)app.getFilePattern());
                }
                if (appender instanceof MemoryMappedFileAppender) {
                    app = (MemoryMappedFileAppender)appender;
                    builder.append(FILE_PARAM, (Object)app.getFileName());
                    builder.append(FILE_PATTERN_PARAM, (Object)"(none)");
                }
                if (appender instanceof RollingRandomAccessFileAppender) {
                    app = (RollingRandomAccessFileAppender)appender;
                    builder.append(FILE_PARAM, (Object)app.getFileName());
                    builder.append(FILE_PATTERN_PARAM, (Object)app.getFilePattern());
                }
                appenders.add(builder.build());
            });
            loggerMap.put("appenders", appenders);
            configuredLoggers.add(loggerMap);
        });
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("loggers", configuredLoggers);
        Map<String, Logger> loggers = this.getActiveLoggersInFactory();
        responseMap.put("activeLoggers", loggers.values());
        return responseMap;
    }

    @GetMapping(path={"/stream"}, produces={"application/json"})
    @Operation(summary="Fetch the last X number of log entries from all CAS appenders configured to capture logs", parameters={@Parameter(name="count", in=ParameterIn.QUERY, description="The number of log entries to fetch", required=false), @Parameter(name="level", in=ParameterIn.QUERY, description="The log level to filter statements", required=false)})
    public List getLogEntries(@RequestParam(name="count", required=false, defaultValue="50") int count, @RequestParam(name="level", required=false) String level, @RequestParam(name="name", required=false) String name) {
        this.initializeIfNecessary();
        Configuration configuration = this.loggerContext.getConfiguration();
        return configuration.getAppenders().values().stream().filter(CasAppender.class::isInstance).map(CasAppender.class::cast).filter(appender -> StringUtils.isBlank((CharSequence)name) || appender.getName().equalsIgnoreCase(name)).map(appender -> {
            List<LogEvent> currentEvents = appender.getLogEvents().stream().filter(logEvent -> StringUtils.isBlank((CharSequence)level) || logEvent.getLevel().name().equalsIgnoreCase(level)).map(logEvent -> {
                ZonedDateTime timestamp = DateTimeUtils.zonedDateTimeOf((long)logEvent.getInstant().getEpochMillisecond());
                return new LogEvent(logEvent.getMessage().getFormattedMessage(), timestamp, logEvent.getLevel().name());
            }).toList();
            int start = Math.max(0, currentEvents.size() - count);
            return currentEvents.subList(start, currentEvents.size());
        }).filter(events -> !events.isEmpty()).flatMap(Collection::stream).toList();
    }

    private Map<String, Logger> getActiveLoggersInFactory() {
        Log4jLoggerFactory factory = (Log4jLoggerFactory)LoggingConfigurationEndpoint.getCasLoggerFactoryInstance();
        if (factory != null) {
            return factory.getLoggersInContext((org.apache.logging.log4j.spi.LoggerContext)this.loggerContext);
        }
        return new HashMap<String, Logger>();
    }

    private Set<LoggerConfig> getLoggerConfigurations() {
        Configuration configuration = this.loggerContext.getConfiguration();
        return new HashSet<LoggerConfig>(configuration.getLoggers().values());
    }

    private static ILoggerFactory getCasLoggerFactoryInstance() {
        return LoggerFactory.getILoggerFactory();
    }

    private Optional<Pair<Resource, LoggerContext>> buildLoggerContext() {
        String logFile = this.applicationContext.getEnvironment().getProperty("logging.config", "classpath:/log4j2.xml");
        LOGGER.info("Located logging configuration reference in the environment as [{}]", (Object)logFile);
        if (ResourceUtils.doesResourceExist((String)logFile, (ResourceLoader)this.applicationContext)) {
            Resource configFile = this.applicationContext.getResource(logFile);
            LOGGER.trace("Loaded logging configuration resource [{}]. Initializing logger context...", (Object)configFile);
            LoggerContext context = (LoggerContext)FunctionUtils.doUnchecked(() -> Configurator.initialize((String)"CAS", null, (URI)configFile.getURI()));
            LOGGER.trace("Installing log configuration listener to detect changes and update");
            context.getConfiguration().addListener(reconfigurable -> context.updateLoggers(reconfigurable.reconfigure()));
            return Optional.of(Pair.of((Object)configFile, (Object)context));
        }
        LOGGER.warn("Logging configuration cannot be found in the environment settings");
        return Optional.empty();
    }

    private void initializeIfNecessary() {
        if (this.loggerContext == null) {
            Optional<Pair<Resource, LoggerContext>> pair = this.buildLoggerContext();
            pair.ifPresent(it -> {
                this.logConfigurationFile = (Resource)it.getKey();
                this.loggerContext = (LoggerContext)it.getValue();
            });
        }
    }

    @Generated
    public LoggerContext getLoggerContext() {
        return this.loggerContext;
    }

    @Generated
    public Resource getLogConfigurationFile() {
        return this.logConfigurationFile;
    }

    public record LogEvent(String message, ZonedDateTime timestamp, String level) {
    }
}

