/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.core.ajax;

import java.time.Duration;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.ajax.attributes.ThrottlingSettings;
import org.wicketstuff.jquery.core.JQueryEvent;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;

public abstract class JQueryAjaxBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final IJQueryAjaxAware source;
    private final Duration duration;

    public JQueryAjaxBehavior(IJQueryAjaxAware source) {
        this(source, Duration.ZERO);
    }

    public JQueryAjaxBehavior(IJQueryAjaxAware source, Duration duration) {
        this.source = source;
        this.duration = duration;
    }

    protected void respond(AjaxRequestTarget target) {
        if (this.source != null) {
            this.source.onAjax(target, this.newEvent());
        }
    }

    protected abstract JQueryEvent newEvent();

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        if (this.duration.compareTo(Duration.ZERO) > 0) {
            attributes.setThrottlingSettings(new ThrottlingSettings("jquery-throttle", this.duration));
        }
    }

    protected CallbackParameter[] getCallbackParameters() {
        return new CallbackParameter[0];
    }

    public String getCallbackFunction() {
        return super.getCallbackFunction(this.getCallbackParameters()).toString();
    }
}

