/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.ITemplateEnd;
import org.thymeleaf.model.ITemplateStart;
import org.thymeleaf.processor.templateboundaries.AbstractTemplateBoundariesProcessor;
import org.thymeleaf.processor.templateboundaries.ITemplateBoundariesStructureHandler;
import org.thymeleaf.standard.inline.StandardCSSInliner;
import org.thymeleaf.standard.inline.StandardHTMLInliner;
import org.thymeleaf.standard.inline.StandardJavaScriptInliner;
import org.thymeleaf.standard.inline.StandardTextInliner;
import org.thymeleaf.standard.inline.StandardXMLInliner;
import org.thymeleaf.templatemode.TemplateMode;

public final class StandardInlineEnablementTemplateBoundariesProcessor
extends AbstractTemplateBoundariesProcessor {
    public static final int PRECEDENCE = 10;

    public StandardInlineEnablementTemplateBoundariesProcessor(TemplateMode templateMode) {
        super(templateMode, 10);
    }

    @Override
    public void doProcessTemplateStart(ITemplateContext context, ITemplateStart templateStart, ITemplateBoundariesStructureHandler structureHandler) {
        switch (this.getTemplateMode()) {
            case HTML: {
                structureHandler.setInliner(new StandardHTMLInliner(context.getConfiguration()));
                break;
            }
            case XML: {
                structureHandler.setInliner(new StandardXMLInliner(context.getConfiguration()));
                break;
            }
            case TEXT: {
                structureHandler.setInliner(new StandardTextInliner(context.getConfiguration()));
                break;
            }
            case JAVASCRIPT: {
                structureHandler.setInliner(new StandardJavaScriptInliner(context.getConfiguration()));
                break;
            }
            case CSS: {
                structureHandler.setInliner(new StandardCSSInliner(context.getConfiguration()));
                break;
            }
            case RAW: {
                structureHandler.setInliner(null);
                break;
            }
            default: {
                throw new TemplateProcessingException("Unrecognized template mode: " + (Object)((Object)this.getTemplateMode()) + ", cannot initialize inlining!");
            }
        }
    }

    @Override
    public void doProcessTemplateEnd(ITemplateContext context, ITemplateEnd templateEnd, ITemplateBoundariesStructureHandler structureHandler) {
    }
}

