/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.api.JobNotFoundException;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveDeadLetterJobToHistoryJobCmd
implements Command<HistoryJob>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoveDeadLetterJobToHistoryJobCmd.class);
    protected String deadletterJobId;
    protected int retries;
    protected JobServiceConfiguration jobServiceConfiguration;

    public MoveDeadLetterJobToHistoryJobCmd(String deadletterJobId, int retries, JobServiceConfiguration jobServiceConfiguration) {
        this.deadletterJobId = deadletterJobId;
        this.retries = retries;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public HistoryJob execute(CommandContext commandContext) {
        if (this.deadletterJobId == null) {
            throw new FlowableIllegalArgumentException("deadletterJobId is null");
        }
        DeadLetterJobEntity deadLetterJobEntity = (DeadLetterJobEntity)this.jobServiceConfiguration.getDeadLetterJobEntityManager().findById(this.deadletterJobId);
        if (deadLetterJobEntity == null) {
            throw new JobNotFoundException(this.deadletterJobId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Moving deadletter job to history job table {}", (Object)deadLetterJobEntity.getId());
        }
        return this.jobServiceConfiguration.getJobManager().moveDeadLetterJobToHistoryJob(deadLetterJobEntity, this.retries);
    }

    public String getDeadletterJobId() {
        return this.deadletterJobId;
    }
}

