/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.query;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;
import org.apereo.cas.ticket.expiration.NeverExpiresExpirationPolicy;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicket;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public record SamlAttributeQueryTicketExpirationPolicyBuilder(CasConfigurationProperties casProperties) implements ExpirationPolicyBuilder<SamlAttributeQueryTicket>
{
    private static final long serialVersionUID = -3597980180617072826L;

    public ExpirationPolicy buildTicketExpirationPolicy() {
        return this.toTicketExpirationPolicy();
    }

    public ExpirationPolicy toTicketExpirationPolicy() {
        long timeToKillInSeconds = this.casProperties.getAuthn().getSamlIdp().getTicket().getAttributeQuery().getTimeToKillInSeconds();
        return timeToKillInSeconds <= 0L ? new NeverExpiresExpirationPolicy() : new HardTimeoutExpirationPolicy(timeToKillInSeconds);
    }
}

