/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.configuration.model.core.logout.LogoutProperties;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.SessionTerminationHandler;
import org.apereo.cas.logout.slo.SingleLogoutRequestContext;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class TerminateSessionAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminateSessionAction.class);
    public static final String REQUEST_PARAM_LOGOUT_REQUEST_CONFIRMED = "LogoutRequestConfirmed";
    protected final EventFactorySupport eventFactorySupport = new EventFactorySupport();
    protected final CentralAuthenticationService centralAuthenticationService;
    protected final CasCookieBuilder ticketGrantingTicketCookieGenerator;
    protected final CasCookieBuilder warnCookieGenerator;
    protected final LogoutProperties logoutProperties;
    protected final LogoutManager logoutManager;
    protected final SingleLogoutRequestExecutor singleLogoutRequestExecutor;

    protected static boolean isLogoutRequestConfirmed(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        return request.getParameterMap().containsKey(REQUEST_PARAM_LOGOUT_REQUEST_CONFIRMED);
    }

    protected Event doExecuteInternal(RequestContext requestContext) throws Exception {
        Boolean terminateSession = (Boolean)FunctionUtils.doIf((boolean)this.logoutProperties.isConfirmLogout(), () -> TerminateSessionAction.isLogoutRequestConfirmed(requestContext), () -> Boolean.TRUE).get();
        if (terminateSession.booleanValue()) {
            return this.terminate(requestContext);
        }
        return this.eventFactorySupport.event((Object)this, "warn");
    }

    protected String getTicketGrantingTicket(RequestContext context) {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        if (StringUtils.isBlank((CharSequence)tgtId)) {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
            return this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        }
        return tgtId;
    }

    protected Event terminate(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        ApplicationContext applicationContext = requestContext.getActiveFlow().getApplicationContext();
        List<SessionTerminationHandler> terminationHandlers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, SessionTerminationHandler.class).values().stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<SessionTerminationHandler>)AnnotationAwareOrderComparator.INSTANCE).toList();
        String tgtId = this.getTicketGrantingTicket(requestContext);
        if (StringUtils.isNotBlank((CharSequence)tgtId)) {
            LOGGER.trace("Destroying SSO session linked to ticket-granting ticket [{}]", (Object)tgtId);
            terminationHandlers.forEach(processor -> processor.beforeSingleLogout(tgtId, requestContext));
            List<SingleLogoutRequestContext> logoutRequests = this.initiateSingleLogout(tgtId, request, response);
            WebUtils.putLogoutRequests((RequestContext)requestContext, logoutRequests);
        }
        LOGGER.trace("Removing CAS cookies");
        this.ticketGrantingTicketCookieGenerator.removeCookie(response);
        this.warnCookieGenerator.removeCookie(response);
        this.destroyApplicationContext(terminationHandlers, requestContext);
        LOGGER.debug("Terminated all CAS sessions successfully.");
        if (StringUtils.isNotBlank((CharSequence)this.logoutProperties.getRedirectUrl())) {
            WebUtils.putLogoutRedirectUrl((RequestContext)requestContext, (String)this.logoutProperties.getRedirectUrl());
            return this.eventFactorySupport.event((Object)this, "redirect");
        }
        return this.eventFactorySupport.success((Object)this);
    }

    protected void destroyApplicationContext(List<SessionTerminationHandler> terminationHandlers, RequestContext requestContext) {
        List terminationResults = terminationHandlers.stream().map(processor -> processor.beforeSessionTermination(requestContext)).flatMap(Collection::stream).toList();
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpSession session = request.getSession(false);
        FunctionUtils.doIfNotNull((Object)session, HttpSession::invalidate);
        terminationHandlers.forEach(processor -> processor.afterSessionTermination(terminationResults, requestContext));
    }

    protected List<SingleLogoutRequestContext> initiateSingleLogout(String ticketGrantingTicketId, HttpServletRequest request, HttpServletResponse response) {
        return this.singleLogoutRequestExecutor.execute(ticketGrantingTicketId, request, response);
    }

    @Generated
    public TerminateSessionAction(CentralAuthenticationService centralAuthenticationService, CasCookieBuilder ticketGrantingTicketCookieGenerator, CasCookieBuilder warnCookieGenerator, LogoutProperties logoutProperties, LogoutManager logoutManager, SingleLogoutRequestExecutor singleLogoutRequestExecutor) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.warnCookieGenerator = warnCookieGenerator;
        this.logoutProperties = logoutProperties;
        this.logoutManager = logoutManager;
        this.singleLogoutRequestExecutor = singleLogoutRequestExecutor;
    }
}

