/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.template;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.template.SmsTemplate;
import com.okta.sdk.resource.template.SmsTemplateTranslations;
import com.okta.sdk.resource.template.SmsTemplateType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultSmsTemplate
extends AbstractInstanceResource<SmsTemplate>
implements SmsTemplate {
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final StringProperty templateProperty = new StringProperty("template");
    private static final ResourceReference<SmsTemplateTranslations> translationsProperty = new ResourceReference<SmsTemplateTranslations>("translations", SmsTemplateTranslations.class, false);
    private static final EnumProperty<SmsTemplateType> typeProperty = new EnumProperty<SmsTemplateType>("type", SmsTemplateType.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultSmsTemplate.createPropertyDescriptorMap(createdProperty, idProperty, lastUpdatedProperty, nameProperty, templateProperty, translationsProperty, typeProperty);

    public DefaultSmsTemplate(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultSmsTemplate(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return SmsTemplate.class;
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public SmsTemplate setName(String name) {
        this.setProperty(nameProperty, (Object)name);
        return this;
    }

    public String getTemplate() {
        return this.getString(templateProperty);
    }

    public SmsTemplate setTemplate(String template) {
        this.setProperty(templateProperty, (Object)template);
        return this;
    }

    public SmsTemplateTranslations getTranslations() {
        return this.getResourceProperty(translationsProperty);
    }

    public SmsTemplate setTranslations(SmsTemplateTranslations translations) {
        this.setProperty(translationsProperty, (Object)translations);
        return this;
    }

    public SmsTemplateType getType() {
        return this.getEnumProperty(typeProperty);
    }

    public SmsTemplate setType(SmsTemplateType type) {
        this.setProperty(typeProperty, (Object)type);
        return this;
    }

    public SmsTemplate partialUpdate() {
        String templateId = this.getId();
        Assert.hasText((String)templateId, (String)"'templateId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        DefaultSmsTemplate smsTemplate = this;
        this.getDataStore().create("/api/v1/templates/sms/" + templateId + "", this, this, SmsTemplate.class, queryArgs, (Map<String, List<String>>)headers);
        return smsTemplate;
    }

    @Override
    public void delete() {
        String templateId = this.getId();
        Assert.hasText((String)templateId, (String)"'templateId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/templates/sms/" + templateId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }

    public SmsTemplate update() {
        String templateId = this.getId();
        Assert.hasText((String)templateId, (String)"'templateId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/templates/sms/" + templateId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }
}

