/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.internals.JoinWindowsInternal;
import org.apache.kafka.streams.kstream.internals.KStreamImplJoin;
import org.apache.kafka.streams.kstream.internals.StreamStreamJoinUtil;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KStreamKStreamSelfJoin<K, V1, V2, VOut>
implements ProcessorSupplier<K, V1, K, VOut> {
    private static final Logger LOG = LoggerFactory.getLogger(KStreamKStreamSelfJoin.class);
    private final String windowName;
    private final long joinThisBeforeMs;
    private final long joinThisAfterMs;
    private final long joinOtherBeforeMs;
    private final long joinOtherAfterMs;
    private final long retentionPeriod;
    private final ValueJoinerWithKey<? super K, ? super V1, ? super V2, ? extends VOut> joinerThis;

    KStreamKStreamSelfJoin(String windowName, JoinWindowsInternal windows, ValueJoinerWithKey<? super K, ? super V1, ? super V2, ? extends VOut> joinerThis, long retentionPeriod) {
        this.windowName = windowName;
        this.joinThisBeforeMs = windows.beforeMs;
        this.joinThisAfterMs = windows.afterMs;
        this.joinOtherBeforeMs = windows.afterMs;
        this.joinOtherAfterMs = windows.beforeMs;
        this.joinerThis = joinerThis;
        this.retentionPeriod = retentionPeriod;
    }

    @Override
    public Processor<K, V1, K, VOut> get() {
        return new KStreamKStreamSelfJoinProcessor();
    }

    private class KStreamKStreamSelfJoinProcessor
    extends ContextualProcessor<K, V1, K, VOut> {
        private final KStreamImplJoin.TimeTracker timeTracker = new KStreamImplJoin.TimeTracker();
        private WindowStore<K, V2> windowStore;
        private Sensor droppedRecordsSensor;

        private KStreamKStreamSelfJoinProcessor() {
        }

        @Override
        public void init(ProcessorContext<K, VOut> context) {
            super.init(context);
            StreamsMetricsImpl metrics = (StreamsMetricsImpl)context.metrics();
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(Thread.currentThread().getName(), context.taskId().toString(), metrics);
            this.windowStore = (WindowStore)context.getStateStore(KStreamKStreamSelfJoin.this.windowName);
        }

        @Override
        public void process(Record<K, V1> record) {
            long otherRecordTimestamp;
            KeyValue otherRecord;
            if (StreamStreamJoinUtil.skipRecord(record, LOG, this.droppedRecordsSensor, this.context())) {
                return;
            }
            long inputRecordTimestamp = record.timestamp();
            long timeFrom = Math.max(0L, inputRecordTimestamp - KStreamKStreamSelfJoin.this.joinThisBeforeMs);
            long timeTo = Math.max(0L, inputRecordTimestamp + KStreamKStreamSelfJoin.this.joinThisAfterMs);
            boolean emittedJoinWithSelf = false;
            Record selfRecord = record.withValue(KStreamKStreamSelfJoin.this.joinerThis.apply(record.key(), record.value(), record.value())).withTimestamp(inputRecordTimestamp);
            this.timeTracker.advanceStreamTime(inputRecordTimestamp);
            boolean emitSelfRecord = inputRecordTimestamp > this.timeTracker.streamTime - KStreamKStreamSelfJoin.this.retentionPeriod + 1L;
            try (WindowStoreIterator iter = this.windowStore.fetch(record.key(), timeFrom, timeTo);){
                while (iter.hasNext()) {
                    otherRecord = (KeyValue)iter.next();
                    otherRecordTimestamp = (Long)otherRecord.key;
                    this.context().forward(record.withValue(KStreamKStreamSelfJoin.this.joinerThis.apply(record.key(), record.value(), otherRecord.value)).withTimestamp(Math.max(inputRecordTimestamp, otherRecordTimestamp)));
                }
            }
            timeFrom = Math.max(0L, inputRecordTimestamp - KStreamKStreamSelfJoin.this.joinOtherBeforeMs);
            timeTo = Math.max(0L, inputRecordTimestamp + KStreamKStreamSelfJoin.this.joinOtherAfterMs);
            var12_9 = null;
            try (WindowStoreIterator iter2 = this.windowStore.fetch(record.key(), timeFrom, timeTo);){
                while (iter2.hasNext()) {
                    otherRecord = (KeyValue)iter2.next();
                    otherRecordTimestamp = (Long)otherRecord.key;
                    long maxRecordTimestamp = Math.max(inputRecordTimestamp, otherRecordTimestamp);
                    if (inputRecordTimestamp < maxRecordTimestamp && !emittedJoinWithSelf && emitSelfRecord) {
                        emittedJoinWithSelf = true;
                        this.context().forward(selfRecord);
                    }
                    this.context().forward(record.withValue(KStreamKStreamSelfJoin.this.joinerThis.apply(record.key(), otherRecord.value, record.value())).withTimestamp(Math.max(inputRecordTimestamp, otherRecordTimestamp)));
                }
            }
            catch (Throwable throwable) {
                var12_9 = throwable;
                throw throwable;
            }
            if (!emittedJoinWithSelf && emitSelfRecord) {
                this.context().forward(selfRecord);
            }
        }
    }
}

