/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.servlet;

import jakarta.servlet.Filter;
import java.io.File;
import org.apache.catalina.Valve;
import org.apache.catalina.valves.AccessLogValve;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.Server;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.embedded.JettyVirtualThreadsWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.web.embedded.JettyWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.web.embedded.TomcatVirtualThreadsWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.web.embedded.TomcatWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.web.embedded.UndertowWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.web.servlet.TomcatServletWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.web.servlet.UndertowServletWebServerFactoryCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.DelegatingFilterProxyRegistrationBean;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.util.StringUtils;

@ManagementContextConfiguration(value=ManagementContextType.CHILD, proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
class ServletManagementChildContextConfiguration {
    ServletManagementChildContextConfiguration() {
    }

    @Bean
    ServletManagementWebServerFactoryCustomizer servletManagementWebServerFactoryCustomizer(ListableBeanFactory beanFactory) {
        return new ServletManagementWebServerFactoryCustomizer(beanFactory);
    }

    static class ServletManagementWebServerFactoryCustomizer
    extends ManagementWebServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
        ServletManagementWebServerFactoryCustomizer(ListableBeanFactory beanFactory) {
            super(beanFactory, ServletWebServerFactoryCustomizer.class, TomcatServletWebServerFactoryCustomizer.class, TomcatWebServerFactoryCustomizer.class, TomcatVirtualThreadsWebServerFactoryCustomizer.class, JettyWebServerFactoryCustomizer.class, JettyVirtualThreadsWebServerFactoryCustomizer.class, UndertowServletWebServerFactoryCustomizer.class, UndertowWebServerFactoryCustomizer.class);
        }

        @Override
        protected void customize(ConfigurableServletWebServerFactory webServerFactory, ManagementServerProperties managementServerProperties, ServerProperties serverProperties) {
            super.customize(webServerFactory, managementServerProperties, serverProperties);
            webServerFactory.setContextPath(this.getContextPath(managementServerProperties));
        }

        private String getContextPath(ManagementServerProperties managementServerProperties) {
            String basePath = managementServerProperties.getBasePath();
            return StringUtils.hasText((String)basePath) ? basePath : "";
        }
    }

    static class JettyAccessLogCustomizer
    extends AccessLogCustomizer
    implements WebServerFactoryCustomizer<JettyServletWebServerFactory> {
        JettyAccessLogCustomizer() {
        }

        public void customize(JettyServletWebServerFactory factory) {
            factory.addServerCustomizers(new JettyServerCustomizer[]{this::customizeServer});
        }

        private void customizeServer(Server server) {
            RequestLog requestLog = server.getRequestLog();
            if (requestLog instanceof CustomRequestLog) {
                CustomRequestLog customRequestLog = (CustomRequestLog)requestLog;
                this.customizeRequestLog(customRequestLog);
            }
        }

        private void customizeRequestLog(CustomRequestLog requestLog) {
            RequestLog.Writer writer = requestLog.getWriter();
            if (writer instanceof RequestLogWriter) {
                RequestLogWriter requestLogWriter = (RequestLogWriter)writer;
                this.customizeRequestLogWriter(requestLogWriter);
            }
        }

        private void customizeRequestLogWriter(RequestLogWriter writer) {
            String filename = writer.getFileName();
            if (StringUtils.hasLength((String)filename)) {
                File file = new File(filename);
                file = new File(file.getParentFile(), this.customizePrefix(file.getName()));
                writer.setFilename(file.getPath());
            }
        }
    }

    static class UndertowAccessLogCustomizer
    extends AccessLogCustomizer
    implements WebServerFactoryCustomizer<UndertowServletWebServerFactory> {
        UndertowAccessLogCustomizer() {
        }

        public void customize(UndertowServletWebServerFactory factory) {
            factory.setAccessLogPrefix(this.customizePrefix(factory.getAccessLogPrefix()));
        }
    }

    static class TomcatAccessLogCustomizer
    extends AccessLogCustomizer
    implements WebServerFactoryCustomizer<TomcatServletWebServerFactory> {
        TomcatAccessLogCustomizer() {
        }

        public void customize(TomcatServletWebServerFactory factory) {
            AccessLogValve accessLogValve = this.findAccessLogValve(factory);
            if (accessLogValve == null) {
                return;
            }
            accessLogValve.setPrefix(this.customizePrefix(accessLogValve.getPrefix()));
        }

        private AccessLogValve findAccessLogValve(TomcatServletWebServerFactory factory) {
            for (Valve engineValve : factory.getEngineValves()) {
                if (!(engineValve instanceof AccessLogValve)) continue;
                AccessLogValve accessLogValve = (AccessLogValve)engineValve;
                return accessLogValve;
            }
            return null;
        }
    }

    static abstract class AccessLogCustomizer
    implements Ordered {
        private static final String MANAGEMENT_PREFIX = "management_";

        AccessLogCustomizer() {
        }

        protected String customizePrefix(String prefix) {
            String string = prefix = prefix != null ? prefix : "";
            if (prefix.startsWith(MANAGEMENT_PREFIX)) {
                return prefix;
            }
            return MANAGEMENT_PREFIX + prefix;
        }

        public int getOrder() {
            return 1;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={EnableWebSecurity.class, Filter.class})
    @ConditionalOnBean(name={"springSecurityFilterChain"}, search=SearchStrategy.ANCESTORS)
    static class ServletManagementContextSecurityConfiguration {
        ServletManagementContextSecurityConfiguration() {
        }

        @Bean
        Filter springSecurityFilterChain(HierarchicalBeanFactory beanFactory) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            return (Filter)parent.getBean("springSecurityFilterChain", Filter.class);
        }

        @Bean
        @ConditionalOnBean(name={"securityFilterChainRegistration"}, search=SearchStrategy.ANCESTORS)
        DelegatingFilterProxyRegistrationBean securityFilterChainRegistration(HierarchicalBeanFactory beanFactory) {
            return (DelegatingFilterProxyRegistrationBean)beanFactory.getParentBeanFactory().getBean("securityFilterChainRegistration", DelegatingFilterProxyRegistrationBean.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.eclipse.jetty.server.Server"})
    static class JettyConfiguration {
        JettyConfiguration() {
        }

        @Bean
        JettyAccessLogCustomizer jettyManagementAccessLogCustomizer() {
            return new JettyAccessLogCustomizer();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.apache.catalina.valves.AccessLogValve"})
    static class TomcatConfiguration {
        TomcatConfiguration() {
        }

        @Bean
        TomcatAccessLogCustomizer tomcatManagementAccessLogCustomizer() {
            return new TomcatAccessLogCustomizer();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"io.undertow.Undertow"})
    static class UndertowConfiguration {
        UndertowConfiguration() {
        }

        @Bean
        UndertowAccessLogCustomizer undertowManagementAccessLogCustomizer() {
            return new UndertowAccessLogCustomizer();
        }
    }
}

