/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.AttributeRepositoryStates;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.persondir.groovy.GroovyPersonAttributeDao;
import org.apereo.cas.persondir.groovy.InternalGroovyScriptDao;
import org.apereo.cas.persondir.groovy.PersonAttributeScriptDao;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnMissingGraalVMNativeImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PersonDirectory}, module="groovy")
@ConditionalOnMissingGraalVMNativeImage
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="CasPersonDirectoryGroovyConfiguration", proxyBeanMethods=false)
class CasPersonDirectoryGroovyConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasPersonDirectoryGroovyConfiguration.class);
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.attribute-repository.groovy[0].location").exists();

    CasPersonDirectoryGroovyConfiguration() {
    }

    @Configuration(value="GroovyAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class GroovyAttributeRepositoryPlanConfiguration {
        GroovyAttributeRepositoryPlanConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"groovyPersonDirectoryAttributeRepositoryPlanConfigurer"})
        public PersonDirectoryAttributeRepositoryPlanConfigurer groovyPersonDirectoryAttributeRepositoryPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="groovyAttributeRepositories") BeanContainer<PersonAttributeDao> groovyAttributeRepositories) {
            return (PersonDirectoryAttributeRepositoryPlanConfigurer)BeanSupplier.of(PersonDirectoryAttributeRepositoryPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
                List results = groovyAttributeRepositories.toList().stream().filter(PersonAttributeDao::isEnabled).collect(Collectors.toList());
                plan.registerAttributeRepositories(results);
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="GroovyAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class GroovyAttributeRepositoryConfiguration {
        GroovyAttributeRepositoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"groovyAttributeRepositories"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<PersonAttributeDao> groovyAttributeRepositories(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                ArrayList list = new ArrayList();
                casProperties.getAuthn().getAttributeRepository().getGroovy().stream().filter(groovy -> groovy.getLocation() != null).forEach(groovy -> {
                    GroovyPersonAttributeDao dao = new GroovyPersonAttributeDao((PersonAttributeScriptDao)new InternalGroovyScriptDao((ApplicationContext)applicationContext, casProperties, groovy));
                    dao.setOrder(groovy.getOrder());
                    dao.setEnabled(groovy.getState() != AttributeRepositoryStates.DISABLED);
                    dao.putTag(PersonDirectoryAttributeRepositoryPlanConfigurer.class.getSimpleName(), (Object)(groovy.getState() == AttributeRepositoryStates.ACTIVE ? 1 : 0));
                    FunctionUtils.doIfNotNull((Object)groovy.getId(), id -> dao.setId(new String[]{id}));
                    LOGGER.debug("Configured Groovy attribute sources from [{}]", (Object)groovy.getLocation());
                    list.add(dao);
                });
                return BeanContainer.of(list);
            }).otherwise(BeanContainer::empty).get();
        }
    }
}

