/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import org.apache.wicket.model.IDetachable;
import org.apache.wicket.util.lang.Args;
import org.danekja.java.util.function.serializable.SerializableBiFunction;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.danekja.java.util.function.serializable.SerializablePredicate;
import org.danekja.java.util.function.serializable.SerializableSupplier;

@FunctionalInterface
public interface IModel<T>
extends IDetachable {
    public T getObject();

    default public void setObject(T object) {
        throw new UnsupportedOperationException("Override this method to support setObject(Object)");
    }

    @Override
    default public void detach() {
    }

    default public IModel<T> filter(final SerializablePredicate<? super T> predicate) {
        Args.notNull(predicate, (String)"predicate");
        return new IModel<T>(){

            @Override
            public T getObject() {
                Object object = IModel.this.getObject();
                if (object != null && predicate.test(object)) {
                    return object;
                }
                return null;
            }

            @Override
            public void detach() {
                IModel.this.detach();
            }
        };
    }

    default public <R> IModel<R> map(final SerializableFunction<? super T, R> mapper) {
        Args.notNull(mapper, (String)"mapper");
        return new IModel<R>(){

            @Override
            public R getObject() {
                Object object = IModel.this.getObject();
                if (object == null) {
                    return null;
                }
                return mapper.apply(object);
            }

            @Override
            public void detach() {
                IModel.this.detach();
            }
        };
    }

    default public <R, U> IModel<R> combineWith(final IModel<U> other, final SerializableBiFunction<? super T, ? super U, R> combiner) {
        Args.notNull(combiner, (String)"combiner");
        Args.notNull(other, (String)"other");
        return new IModel<R>(){

            @Override
            public R getObject() {
                Object t = IModel.this.getObject();
                Object u = other.getObject();
                if (t != null && u != null) {
                    return combiner.apply(t, u);
                }
                return null;
            }

            @Override
            public void detach() {
                other.detach();
                IModel.this.detach();
            }
        };
    }

    default public <R> IModel<R> flatMap(final SerializableFunction<? super T, IModel<R>> mapper) {
        Args.notNull(mapper, (String)"mapper");
        return new IModel<R>(){
            private static final long serialVersionUID = 1L;

            @Override
            public R getObject() {
                Object object = IModel.this.getObject();
                if (object != null) {
                    IModel model = (IModel)mapper.apply(object);
                    if (model != null) {
                        return model.getObject();
                    }
                    return null;
                }
                return null;
            }

            @Override
            public void setObject(R object) {
                IModel model;
                Object modelObject = IModel.this.getObject();
                if (modelObject != null && (model = (IModel)mapper.apply(modelObject)) != null) {
                    model.setObject(object);
                }
            }

            @Override
            public void detach() {
                IModel model;
                Object object = IModel.this.getObject();
                IModel.this.detach();
                if (object != null && (model = (IModel)mapper.apply(object)) != null) {
                    model.detach();
                }
            }
        };
    }

    default public IModel<T> orElse(final T other) {
        return new IModel<T>(){

            @Override
            public T getObject() {
                Object object = IModel.this.getObject();
                if (object == null) {
                    return other;
                }
                return object;
            }

            @Override
            public void detach() {
                IModel.this.detach();
            }
        };
    }

    default public IModel<T> orElseGet(final SerializableSupplier<? extends T> other) {
        Args.notNull(other, (String)"other");
        return new IModel<T>(){

            @Override
            public T getObject() {
                Object object = IModel.this.getObject();
                if (object == null) {
                    return other.get();
                }
                return object;
            }

            @Override
            public void detach() {
                IModel.this.detach();
            }
        };
    }

    default public IModel<Boolean> isPresent() {
        return new IModel<Boolean>(){

            @Override
            public Boolean getObject() {
                return IModel.this.getObject() != null;
            }

            @Override
            public void detach() {
                IModel.this.detach();
            }
        };
    }

    default public <R extends T> IModel<R> as(Class<R> clazz) {
        Args.notNull(clazz, (String)"clazz");
        return this.filter(clazz::isInstance).map(clazz::cast);
    }

    public static <T> IModel<T> of(IModel<?> model) {
        return model;
    }
}

