/*
 * Decompiled with CFR 0.152.
 */
package kafka.testkit;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kafka.testkit.TestKitNode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;

public class ControllerNode
implements TestKitNode {
    private final MetaPropertiesEnsemble initialMetaPropertiesEnsemble;
    private final boolean combined;
    private final Map<String, String> propertyOverrides;

    public static Builder builder() {
        return new Builder();
    }

    private ControllerNode(MetaPropertiesEnsemble initialMetaPropertiesEnsemble, boolean combined, Map<String, String> propertyOverrides) {
        this.initialMetaPropertiesEnsemble = Objects.requireNonNull(initialMetaPropertiesEnsemble);
        this.combined = combined;
        this.propertyOverrides = Objects.requireNonNull(propertyOverrides);
    }

    @Override
    public MetaPropertiesEnsemble initialMetaPropertiesEnsemble() {
        return this.initialMetaPropertiesEnsemble;
    }

    @Override
    public boolean combined() {
        return this.combined;
    }

    public Map<String, String> propertyOverrides() {
        return this.propertyOverrides;
    }

    public static class Builder {
        private int id = -1;
        private String baseDirectory;
        private Uuid clusterId;
        private boolean combined;
        private Map<String, String> propertyOverrides = Collections.emptyMap();

        private Builder() {
        }

        public int id() {
            return this.id;
        }

        public Builder setId(int id) {
            this.id = id;
            return this;
        }

        public Builder setClusterId(Uuid clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder setBaseDirectory(String baseDirectory) {
            this.baseDirectory = baseDirectory;
            return this;
        }

        public Builder setCombined(boolean combined) {
            this.combined = combined;
            return this;
        }

        public Builder setPropertyOverrides(Map<String, String> propertyOverrides) {
            this.propertyOverrides = Collections.unmodifiableMap(new HashMap<String, String>(propertyOverrides));
            return this;
        }

        public ControllerNode build() {
            if (this.id == -1) {
                throw new IllegalArgumentException("You must set the node id.");
            }
            if (this.baseDirectory == null) {
                throw new IllegalArgumentException("You must set the base directory.");
            }
            String metadataDirectory = new File(this.baseDirectory, this.combined ? String.format("combined_%d_0", this.id) : String.format("controller_%d", this.id)).getAbsolutePath();
            MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(MetaPropertiesEnsemble.EMPTY);
            copier.setMetaLogDir(Optional.of(metadataDirectory));
            copier.setLogDirProps(metadataDirectory, new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(this.clusterId.toString()).setNodeId(this.id).setDirectoryId(copier.generateValidDirectoryId()).build());
            return new ControllerNode(copier.copy(), this.combined, this.propertyOverrides);
        }
    }
}

