/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Properties;
import kafka.server.DefaultAlterPartitionManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.QuorumTestHarness;
import kafka.server.ZkAlterPartitionManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.config.ZkConfigs;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005q3A!\u0004\b\u0001'!)\u0001\u0004\u0001C\u00013!)1\u0004\u0001C\u00019!)\u0001\u0007\u0001C\u00019!)!\u0007\u0001C\u00019!)A\u0007\u0001C\u00019!)a\u0007\u0001C\u00019!)\u0001\b\u0001C\u00019!)!\b\u0001C\u00019!)A\b\u0001C\u00019!)a\b\u0001C\u00019!)\u0001\t\u0001C\u0001\u0003\")\u0011\f\u0001C\u00015\ny1*\u00194lCN+'O^3s)\u0016\u001cHO\u0003\u0002\u0010!\u000511/\u001a:wKJT\u0011!E\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u0016-5\ta\"\u0003\u0002\u0018\u001d\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005Q\u0002CA\u000b\u0001\u0003!\"Xm\u001d;BYJ,\u0017\rZ=SK\u001eL7\u000f^3sK\u0012\fEM^3si&\u001cX\r\u001a'jgR,g.\u001a:t)\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSRD#A\u0001\u0013\u0011\u0005\u0015rS\"\u0001\u0014\u000b\u0005\u001dB\u0013aA1qS*\u0011\u0011FK\u0001\bUV\u0004\u0018\u000e^3s\u0015\tYC&A\u0003kk:LGOC\u0001.\u0003\ry'oZ\u0005\u0003_\u0019\u0012A\u0001V3ti\u0006aB/Z:u\u0019&\u001cH/\u001a8feB{'\u000f^!me\u0016\fG-_%o+N,\u0007FA\u0002%\u0003%\"Xm\u001d;De\u0016\fG/Z:Qe>\u0004XM\u001d.l\u0007>tg-[4XQ\u0016t7+Y:m\t&\u001c\u0018M\u00197fI\"\u0012A\u0001J\u0001)i\u0016\u001cHo\u0011:fCR,7\u000f\u0015:pa\u0016\u0014(l\u001b+mg\u000e{gNZ5h/\",g\u000eR5tC\ndW\r\u001a\u0015\u0003\u000b\u0011\n!\u0006^3ti\u000e\u0013X-\u0019;fgB\u0013x\u000e]3s5.$Fn]\"p]\u001aLwmV5uQR\u0013X/\u001a,bYV,7\u000f\u000b\u0002\u0007I\u0005\u0011D/Z:u\u0007J,\u0017\r^3t!J|\u0007/\u001a:[WRc7oQ8oM&<w+\u001b;i\r\u0006d7/Z!oI2K7\u000f\u001e,bYV,7\u000f\u000b\u0002\bI\u0005\u0001B/Z:u5.L5O]'b]\u0006<WM\u001d\u0015\u0003\u0011\u0011\n1\u0003^3ti\u0006cG/\u001a:JgJl\u0015M\\1hKJD#!\u0003\u0013\u0002CQ,7\u000f\u001e*f[>$X\rT8h\u001b\u0006t\u0017mZ3s\u0013:\u001cH/\u00198uS\u0006$\u0018n\u001c8)\u0005)!\u0013\u0001D2sK\u0006$XmU3sm\u0016\u0014H\u0003\u0002\"F\u0015^\u0003\"!F\"\n\u0005\u0011s!aC&bM.\f7+\u001a:wKJDQAR\u0006A\u0002\u001d\u000baA\\8eK&#\u0007C\u0001\u0010I\u0013\tIuDA\u0002J]RDQaS\u0006A\u00021\u000b\u0001\u0002[8ti:\u000bW.\u001a\t\u0003\u001bRs!A\u0014*\u0011\u0005={R\"\u0001)\u000b\u0005E\u0013\u0012A\u0002\u001fs_>$h(\u0003\u0002T?\u00051\u0001K]3eK\u001aL!!\u0016,\u0003\rM#(/\u001b8h\u0015\t\u0019v\u0004C\u0003Y\u0017\u0001\u0007q)\u0001\u0003q_J$\u0018AH2sK\u0006$XmU3sm\u0016\u0014x+\u001b;i\u0019&\u001cH/\u001a8fe>s\u0007k\u001c:u)\t\u00115\fC\u0003Y\u0019\u0001\u0007q\t")
public class KafkaServerTest
extends QuorumTestHarness {
    @Test
    public void testAlreadyRegisteredAdvertisedListeners() {
        KafkaServer server1 = this.createServer(1, "myhost", TestUtils$.MODULE$.RandomPort());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createServer(2, "myhost", TestUtils$.MODULE$.boundPort((KafkaBroker)server1, SecurityProtocol.PLAINTEXT)));
        KafkaServer server2 = this.createServer(2, "myhost", TestUtils$.MODULE$.RandomPort());
        TestUtils$.MODULE$.shutdownServers(new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)Nil$.MODULE$)), true);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListenerPortAlreadyInUse() {
        ServerSocket serverSocket = new ServerSocket(0, 0, InetAddress.getLoopbackAddress());
        ObjectRef kafkaServer = ObjectRef.create((Object)None$.MODULE$);
        try {
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!serverSocket.isBound()) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Server socket failed to bind.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertThrows(RuntimeException.class, () -> {
                kafkaServer$1.elem = Option$.MODULE$.apply((Object)this.createServerWithListenerOnPort(serverSocket.getLocalPort()));
            }, (String)"Expected RuntimeException due to address already in use during KafkaServer startup");
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> serverSocket.close(), (Logging)this, Level.WARN);
            TestUtils$.MODULE$.shutdownServers(((Option)kafkaServer.elem).toList(), true);
        }
    }

    @Test
    public void testCreatesProperZkConfigWhenSaslDisabled() {
        Properties props = new Properties();
        props.put("zookeeper.connect", this.zkConnect());
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        Assertions.assertEquals((Object)"false", (Object)zkClientConfig.getProperty("zookeeper.sasl.client"));
    }

    @Test
    public void testCreatesProperZkTlsConfigWhenDisabled() {
        Properties props = new Properties();
        props.put("zookeeper.connect", this.zkConnect());
        props.put("zookeeper.ssl.client.enable", "false");
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        CollectionConverters$.MODULE$.MapHasAsScala(ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP).asScala().keys().foreach((Function1 & Serializable)propName -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(zkClientConfig, propName);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithTrueValues() {
        Properties props = new Properties();
        props.put("zookeeper.connect", this.zkConnect());
        String someValue = "some_value";
        CollectionConverters$.MODULE$.MapHasAsScala(ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP).asScala().keys().foreach((Function1 & Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$1(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        CollectionConverters$.MODULE$.MapHasAsScala(ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP).asScala().keys().foreach((Function1 & Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithFalseAndListValues() {
        Properties props = new Properties();
        props.put("zookeeper.connect", this.zkConnect());
        String someValue = "some_value";
        CollectionConverters$.MODULE$.MapHasAsScala(ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP).asScala().keys().foreach((Function1 & Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$2(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        CollectionConverters$.MODULE$.MapHasAsScala(ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP).asScala().keys().foreach((Function1 & Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkIsrManager() {
        void createServer_time;
        void createServer_config;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        props.put("inter.broker.protocol.version", "2.7-IV1");
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean createServer_createServer_createServer_startup = true;
        Object var6_5 = null;
        Object var3_4 = null;
        kafkaConfig = null;
        time = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false);
        if (!(server.replicaManager().alterPartitionManager() instanceof ZkAlterPartitionManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use ZK for ISR manager in versions before 2.7-IV2");
        }
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterIsrManager() {
        void createServer_time;
        void createServer_config;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        props.put("inter.broker.protocol.version", MetadataVersion.latestTesting().toString());
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean createServer_createServer_createServer_startup = true;
        Object var6_5 = null;
        Object var3_4 = null;
        kafkaConfig = null;
        time = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false);
        if (!(server.replicaManager().alterPartitionManager() instanceof DefaultAlterPartitionManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use AlterIsr for ISR manager in versions after 2.7-IV2");
        }
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRemoteLogManagerInstantiation() {
        void createServer_time;
        void createServer_config;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        props.put("remote.log.storage.system.enable", Boolean.toString(true));
        props.put("remote.log.metadata.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager");
        props.put("remote.log.storage.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager");
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean createServer_createServer_createServer_startup = true;
        Object var7_5 = null;
        Object var4_4 = null;
        kafkaConfig = null;
        time = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false);
        Option option = server.remoteLogManagerOpt();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"RemoteLogManager should be initialized");
            } else {
                throw new MatchError((Object)option);
            }
        }
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createServer(int nodeId, String hostName, int port) {
        void createServer_time;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put("advertised.listeners", new StringBuilder(13).append("PLAINTEXT://").append(hostName).append(":").append(port).toString());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Time time = Time.SYSTEM;
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean createServer_createServer_createServer_startup = true;
        return createServer_this.createServer(kafkaConfig, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false);
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createServerWithListenerOnPort(int port) {
        void createServer_time;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put("listeners", new StringBuilder(22).append("PLAINTEXT://localhost:").append(port).toString());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Time time = Time.SYSTEM;
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean createServer_createServer_createServer_startup = true;
        return createServer_this.createServer(kafkaConfig, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false);
    }

    public static final /* synthetic */ boolean $anonfun$testListenerPortAlreadyInUse$1(ServerSocket serverSocket$1) {
        return serverSocket$1.isBound();
    }

    public static final /* synthetic */ String $anonfun$testListenerPortAlreadyInUse$2() {
        return "Server socket failed to bind.";
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(ZKClientConfig zkClientConfig$1, String propName) {
        Assertions.assertNull((Object)zkClientConfig$1.getProperty(propName));
    }

    private static final String kafkaConfigValueToSet$1(String kafkaProp, String someValue$1) {
        block10: {
            switch (kafkaProp == null ? 0 : kafkaProp.hashCode()) {
                case -491987326: {
                    if ("zookeeper.ssl.client.enable".equals(kafkaProp)) {
                        break;
                    }
                    break block10;
                }
                case -271587656: {
                    if ("zookeeper.ssl.crl.enable".equals(kafkaProp)) {
                        break;
                    }
                    break block10;
                }
                case 510167900: {
                    if ("zookeeper.ssl.ocsp.enable".equals(kafkaProp)) {
                        break;
                    }
                    break block10;
                }
                case 1699909284: {
                    if ("zookeeper.ssl.endpoint.identification.algorithm".equals(kafkaProp)) {
                        return "HTTPS";
                    }
                    break block10;
                }
                default: {
                    break block10;
                }
            }
            return "true";
        }
        return someValue$1;
    }

    private static final String zkClientValueToExpect$1(String kafkaProp, String someValue$1) {
        block10: {
            switch (kafkaProp == null ? 0 : kafkaProp.hashCode()) {
                case -491987326: {
                    if ("zookeeper.ssl.client.enable".equals(kafkaProp)) {
                        break;
                    }
                    break block10;
                }
                case -271587656: {
                    if ("zookeeper.ssl.crl.enable".equals(kafkaProp)) {
                        break;
                    }
                    break block10;
                }
                case 510167900: {
                    if ("zookeeper.ssl.ocsp.enable".equals(kafkaProp)) {
                        break;
                    }
                    break block10;
                }
                case 1699909284: {
                    if ("zookeeper.ssl.endpoint.identification.algorithm".equals(kafkaProp)) {
                        return "true";
                    }
                    break block10;
                }
                default: {
                    break block10;
                }
            }
            return "true";
        }
        return someValue$1;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(ZKClientConfig zkClientConfig$2, String someValue$1, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$1(kafkaProp, someValue$1), (Object)zkClientConfig$2.getProperty((String)ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP.get(kafkaProp)));
    }

    private static final String kafkaConfigValueToSet$2(String kafkaProp, String someValue$2) {
        block12: {
            block13: {
                switch (kafkaProp == null ? 0 : kafkaProp.hashCode()) {
                    case -858437830: {
                        if (!"zookeeper.ssl.cipher.suites".equals(kafkaProp)) break block12;
                        break block13;
                    }
                    case -491987326: {
                        if ("zookeeper.ssl.client.enable".equals(kafkaProp)) {
                            return "true";
                        }
                        break block12;
                    }
                    case -271587656: {
                        if ("zookeeper.ssl.crl.enable".equals(kafkaProp)) {
                            break;
                        }
                        break block12;
                    }
                    case 510167900: {
                        if ("zookeeper.ssl.ocsp.enable".equals(kafkaProp)) {
                            break;
                        }
                        break block12;
                    }
                    case 1154513386: {
                        if (!"zookeeper.ssl.enabled.protocols".equals(kafkaProp)) break block12;
                        break block13;
                    }
                    case 1699909284: {
                        if ("zookeeper.ssl.endpoint.identification.algorithm".equals(kafkaProp)) {
                            return "";
                        }
                        break block12;
                    }
                    default: {
                        break block12;
                    }
                }
                return "false";
            }
            return "A,B";
        }
        return someValue$2;
    }

    private static final String zkClientValueToExpect$2(String kafkaProp, String someValue$2) {
        block12: {
            block13: {
                switch (kafkaProp == null ? 0 : kafkaProp.hashCode()) {
                    case -858437830: {
                        if (!"zookeeper.ssl.cipher.suites".equals(kafkaProp)) break block12;
                        break block13;
                    }
                    case -491987326: {
                        if ("zookeeper.ssl.client.enable".equals(kafkaProp)) {
                            return "true";
                        }
                        break block12;
                    }
                    case -271587656: {
                        if ("zookeeper.ssl.crl.enable".equals(kafkaProp)) {
                            break;
                        }
                        break block12;
                    }
                    case 510167900: {
                        if ("zookeeper.ssl.ocsp.enable".equals(kafkaProp)) {
                            break;
                        }
                        break block12;
                    }
                    case 1154513386: {
                        if (!"zookeeper.ssl.enabled.protocols".equals(kafkaProp)) break block12;
                        break block13;
                    }
                    case 1699909284: {
                        if ("zookeeper.ssl.endpoint.identification.algorithm".equals(kafkaProp)) {
                            return "false";
                        }
                        break block12;
                    }
                    default: {
                        break block12;
                    }
                }
                return "false";
            }
            return "A,B";
        }
        return someValue$2;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(ZKClientConfig zkClientConfig$3, String someValue$2, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$2(kafkaProp, someValue$2), (Object)zkClientConfig$3.getProperty((String)ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP.get(kafkaProp)));
    }
}

