/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.server.AlterPartitionManager;
import kafka.server.AlterPartitionManagerTest$;
import kafka.server.DefaultAlterPartitionManager;
import kafka.server.ZkAlterPartitionManager;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r-e\u0001\u0002 @\u0001\u0011CQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004Z\u0001\u0001\u0006I!\u0015\u0005\b5\u0002\u0011\r\u0011\"\u0001\\\u0011\u00199\u0007\u0001)A\u00059\"9\u0001\u000e\u0001b\u0001\n\u0003I\u0007BB9\u0001A\u0003%!\u000eC\u0004s\u0001\t\u0007I\u0011A:\t\re\u0004\u0001\u0015!\u0003u\u0011\u001dQ\bA1A\u0005\u0002mDaa \u0001!\u0002\u0013a\bbCA\u0001\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0007A1\"!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0010!Y\u00111\u0004\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0003\u0011%\ti\u0002\u0001b\u0001\n\u0003\ty\u0002\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u0011\u0011%\tI\u0003\u0001b\u0001\n\u0003\ty\u0002\u0003\u0005\u0002,\u0001\u0001\u000b\u0011BA\u0011\u0011%\ti\u0003\u0001b\u0001\n\u0003\ty\u0002\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\u0011\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!a\u0013\u0001\t\u0003\ti\u0005C\u0004\u0002\u0002\u0002!\t!a!\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\"9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0006bBA]\u0001\u0011\u0005\u00111\u0018\u0005\b\u0003\u000b\u0004A\u0011AA\u001a\u0011\u001d\ty\r\u0001C\u0001\u0003gAq!a5\u0001\t\u0003\t\u0019\u0004C\u0004\u0002X\u0002!\t!a\r\t\u000f\u0005m\u0007\u0001\"\u0001\u00024!9\u0011q\u001c\u0001\u0005\u0002\u0005M\u0002bBAr\u0001\u0011%\u0011Q\u001d\u0005\b\u0003o\u0004A\u0011BA}\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003gAqAa\u0004\u0001\t\u0003\t\u0019\u0004C\u0004\u0003\u0014\u0001!\t!a\r\t\u000f\t]\u0001\u0001\"\u0001\u00024!9!1\u0004\u0001\u0005\n\tu\u0001b\u0002B\u0011\u0001\u0011%!1\u0005\u0005\b\u0005c\u0001A\u0011\u0001B\u001a\u0011\u001d\u0011i\u0004\u0001C\u0001\u0005\u007fAqA!\u0013\u0001\t\u0003\u0011Y\u0005C\u0004\u0003V\u0001!IAa\u0016\t\u000f\tu\u0005\u0001\"\u0003\u0003 \"9!\u0011\u001b\u0001\u0005\n\tM\u0007b\u0002Bq\u0001\u0011%!1\u001d\u0005\b\u0007\u001f\u0001A\u0011BB\t\u0011\u001d\u0019I\u0002\u0001C\u0001\u0003gAqa!\b\u0001\t\u0013\u0019y\u0002C\u0005\u0004<\u0001\t\n\u0011\"\u0003\u0004>!I11\u000b\u0001\u0012\u0002\u0013%1Q\u000b\u0005\n\u00073\u0002\u0011\u0013!C\u0005\u00077B\u0011ba\u0018\u0001#\u0003%Iaa\u0017\t\u0013\r\u0005\u0004!%A\u0005\n\rm\u0003\"CB2\u0001E\u0005I\u0011BB3\u000f\u001d\u0019Ig\u0010E\u0001\u0007W2aAP \t\u0002\r5\u0004BB&;\t\u0003\u0019y\u0007C\u0004\u0002\u0000i\"\ta!\u001d\t\u000f\u0005-&\b\"\u0001\u0004\u0002\nI\u0012\t\u001c;feB\u000b'\u000f^5uS>tW*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0001\u0015)\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0005\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001F!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0014\t\u0003\u001d\u0002i\u0011aP\u0001\u0006i>\u0004\u0018nY\u000b\u0002#B\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u0005Y\u0006twMC\u0001W\u0003\u0011Q\u0017M^1\n\u0005a\u001b&AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\bi>\u0004\u0018nY%e+\u0005a\u0006CA/f\u001b\u0005q&BA0a\u0003\u0019\u0019w.\\7p]*\u0011!)\u0019\u0006\u0003E\u000e\fa!\u00199bG\",'\"\u00013\u0002\u0007=\u0014x-\u0003\u0002g=\n!Q+^5e\u0003!!x\u000e]5d\u0013\u0012\u0004\u0013\u0001\u0002;j[\u0016,\u0012A\u001b\t\u0003W>l\u0011\u0001\u001c\u0006\u0003[:\fA!\u001e;jY*\u0011\u0001\tY\u0005\u0003a2\u0014\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\b[\u0016$(/[2t+\u0005!\bCA;x\u001b\u00051(B\u0001:_\u0013\tAhOA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002yB\u0011a)`\u0005\u0003}\u001e\u00131!\u00138u\u0003%\u0011'o\\6fe&#\u0007%\u0001\nce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u0014XCAA\u0003!\u0011\t9!!\u0003\u000e\u00039L1!a\u0003o\u0005yqu\u000eZ3U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/\u0001\fce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u0014x\fJ3r)\u0011\t\t\"a\u0006\u0011\u0007\u0019\u000b\u0019\"C\u0002\u0002\u0016\u001d\u0013A!\u00168ji\"I\u0011\u0011D\u0007\u0002\u0002\u0003\u0007\u0011QA\u0001\u0004q\u0012\n\u0014a\u00052s_.,'\u000fV8D_:$(o\u001c7mKJ\u0004\u0013a\u0001;qaU\u0011\u0011\u0011\u0005\t\u0004;\u0006\r\u0012bAA\u0013=\n\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0001\u0005iB\u0004\u0004%A\u0002uaF\nA\u0001\u001e92A\u0005\u0019A\u000f\u001d\u001a\u0002\tQ\u0004(\u0007I\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0003\u0003#A3!FA\u001c!\u0011\tI$a\u0012\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u007f\t1!\u00199j\u0015\u0011\t\t%a\u0011\u0002\u000f),\b/\u001b;fe*\u0019\u0011QI2\u0002\u000b),h.\u001b;\n\t\u0005%\u00131\b\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!\u0003;fgR\u0014\u0015m]5d)\u0011\t\t\"a\u0014\t\u000f\u0005Ec\u00031\u0001\u0002T\u0005yQ.\u001a;bI\u0006$\u0018MV3sg&|g\u000e\u0005\u0003\u0002V\u0005eSBAA,\u0015\tyf.\u0003\u0003\u0002\\\u0005]#aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8)\u0007Y\ty\u0006\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\u0011\t)'a\u0010\u0002\rA\f'/Y7t\u0013\u0011\tI'a\u0019\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000fK\u0004\u0017\u0003[\nI(a\u001f\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cRA!a\u001d\u0002d\u0005A\u0001O]8wS\u0012,'/\u0003\u0003\u0002x\u0005E$\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,GFAA?C\t\ty(A\fqe>4\u0018\u000eZ3NKR\fG-\u0019;b-\u0016\u00148/[8og\u0006AB/Z:u\u0005\u0006\u001c\u0018nY,ji\"\u0014%o\\6fe\u0016\u0003xn\u00195\u0015\t\u0005E\u0011Q\u0011\u0005\b\u0003#:\u0002\u0019AA*Q\r9\u0012q\f\u0015\b/\u00055\u0014\u0011PAFY\t\ti(\u0001\u0011uKN$()Y:jGN+g\u000e\u001e'fC\u0012,'OU3d_Z,'/_*uCR,GCBA\t\u0003#\u000b\u0019\nC\u0004\u0002Ra\u0001\r!a\u0015\t\u000f\u0005U\u0005\u00041\u0001\u0002\u0018\u0006\u0019B.Z1eKJ\u0014VmY8wKJL8\u000b^1uKB!\u0011\u0011TAP\u001b\t\tYJC\u0002\u0002\u001e\u0002\f\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003C\u000bYJA\nMK\u0006$WM\u001d*fG>4XM]=Ti\u0006$X\rK\u0002\u0019\u0003?Bs\u0001GA7\u0003s\n9\u000b\f\u0002\u0002*\u0006\u0012\u00111V\u0001\u001baJ|g/\u001b3f\u0019\u0016\fG-\u001a:SK\u000e|g/\u001a:z'R\fG/Z\u0001\u0019i\u0016\u001cHo\u0014<fe^\u0014\u0018\u000e^3XSRD\u0017N\u001c\"bi\u000eDG\u0003BA\t\u0003cCq!!\u0015\u001a\u0001\u0004\t\u0019\u0006K\u0002\u001a\u0003?Bs!GA7\u0003s\n9\f\f\u0002\u0002~\u0005yA/Z:u'&tw\r\\3CCR\u001c\u0007\u000e\u0006\u0003\u0002\u0012\u0005u\u0006bBA)5\u0001\u0007\u00111\u000b\u0015\u00045\u0005}\u0003f\u0002\u000e\u0002n\u0005e\u00141\u0019\u0017\u0003\u0003{\na\u0003^3tiN+(-\\5u\rJ|WnQ1mY\n\f7m\u001b\u0015\u00047\u0005%\u0007\u0003BA\u001d\u0003\u0017LA!!4\u0002<\t!A+Z:u\u0003]!Xm\u001d;BkRDwN]5{CRLwN\u001c$bS2,G\rK\u0002\u001d\u0003\u0013\fA\u0003^3tiN#\u0018\r\\3Ce>\\WM]#q_\u000eD\u0007fA\u000f\u0002J\u0006\tB/Z:u+:\\gn\\<o'\u0016\u0014h/\u001a:)\u0007y\tI-\u0001\u0011uKN$(+\u001a;ss>s\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007fA\u0010\u0002J\u0006\u0011C/Z:u%\u0016$(/_(o+:\u001cX\u000f\u001d9peR,GMV3sg&|g.\u0012:s_JD3\u0001IAe\u0003a!Xm\u001d;SKR\u0014\u0018p\u00148U_BdUM^3m\u000bJ\u0014xN\u001d\u000b\u0005\u0003#\t9\u000fC\u0004\u0002j\u0006\u0002\r!a;\u0002\u000b\u0015\u0014(o\u001c:\u0011\t\u00055\u00181_\u0007\u0003\u0003_T1!!=_\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA{\u0003_\u0014a!\u0012:s_J\u001c\u0018\u0001\u0007;fgR\u0014V\r\u001e:z\u001f:,%O]8s%\u0016\u001c\bo\u001c8tKR!\u0011\u0011CA~\u0011\u001d\tiP\ta\u0001\u0003\u007f\f\u0001B]3ta>t7/\u001a\t\u0005\u0005\u0003\u00119!\u0004\u0002\u0003\u0004)\u0019!Q\u00011\u0002\u000f\rd\u0017.\u001a8ug&!!\u0011\u0002B\u0002\u00059\u0019E.[3oiJ+7\u000f]8og\u0016\f\u0001\u0004^3ti&sg/\u00197jIV\u0003H-\u0019;f-\u0016\u00148/[8oQ\r\u0019\u0013\u0011Z\u0001\u001ai\u0016\u001cH/\u00168l]><h\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eK\u0002%\u0003\u0013\fq\u0003^3ti:{G\u000fT3bI\u0016\u0014xJ\u001d$pY2|w/\u001a:)\u0007\u0015\nI-\u0001\nuKN$\u0018J\u001c<bY&$'+Z9vKN$\bf\u0001\u0014\u0002J\u0006\u00192\r[3dWB\u000b'\u000f^5uS>tWI\u001d:peR!\u0011\u0011\u0003B\u0010\u0011\u001d\tIo\na\u0001\u0003W\f!\u0003^3tiB\u000b'\u000f^5uS>tWI\u001d:peR1!Q\u0005B\u0016\u0005_\u00012A\u0014B\u0014\u0013\r\u0011Ic\u0010\u0002\u0016\u00032$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s\u0011\u001d\u0011i\u0003\u000ba\u0001\u0003C\t!\u0001\u001e9\t\u000f\u0005%\b\u00061\u0001\u0002l\u0006yA/Z:u\u001f:,\u0017J\u001c$mS\u001eDG\u000f\u0006\u0003\u0002\u0012\tU\u0002bBA)S\u0001\u0007\u00111\u000b\u0015\u0004S\u0005}\u0003fB\u0015\u0002n\u0005e$1\b\u0017\u0003\u0003{\na\u0004^3tiB\u000b'\u000f^5uS>tW*[:tS:<\u0017J\u001c*fgB|gn]3\u0015\t\u0005E!\u0011\t\u0005\b\u0003#R\u0003\u0019AA*Q\rQ\u0013q\f\u0015\bU\u00055\u0014\u0011\u0010B$Y\t\ti(A\nuKN$\b+\u0019:uS\u0006dGk\u001c9jG&#7\u000f\u0006\u0003\u0002\u0012\t5\u0003bBA)W\u0001\u0007\u00111\u000b\u0015\u0004W\u0005}\u0003fB\u0016\u0002n\u0005e$1\u000b\u0017\u0003\u0003{\n\u0011C^3sS\u001aL8+\u001a8e%\u0016\fX/Z:u)\u0019\u0011IFa\u0018\u0003bA!\u0011q\u0001B.\u0013\r\u0011iF\u001c\u0002#\u0007>tGO]8mY\u0016\u0014(+Z9vKN$8i\\7qY\u0016$\u0018n\u001c8IC:$G.\u001a:\t\u000f\u0005\u0005A\u00061\u0001\u0002\u0006!9!1\r\u0017A\u0002\t\u0015\u0014aD3ya\u0016\u001cG/\u001a3SKF,Xm\u001d;\u0011\r\t\u001d$Q\u000eB9\u001b\t\u0011IGC\u0002\u0003l\r\fq!\\8dW&$x.\u0003\u0003\u0003p\t%$aD!sOVlWM\u001c;NCR\u001c\u0007.\u001a:1\t\tM$1\u0012\t\u0007\u0005k\u0012\tIa\"\u000f\t\t]$QP\u0007\u0003\u0005sR1Aa\u001f_\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002B@\u0005s\nq\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0005\u0005\u0005\u0007\u0013)IA\u0004Ck&dG-\u001a:\u000b\t\t}$\u0011\u0010\t\u0005\u0005\u0013\u0013Y\t\u0004\u0001\u0005\u0019\t5%\u0011MA\u0001\u0002\u0003\u0015\tAa$\u0003\u0007}##'\u0005\u0003\u0003\u0012\n]\u0005c\u0001$\u0003\u0014&\u0019!QS$\u0003\u000f9{G\u000f[5oOB!!q\u000fBM\u0013\u0011\u0011YJ!\u001f\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgR\fA$\u00197uKJ\u0004\u0016M\u001d;ji&|gNU3rk\u0016\u001cH/T1uG\",'\u000f\u0006\u0004\u0003\"\n5&q\u0019\t\u0007\u0005O\u0012iGa)1\t\t\u0015&\u0011\u0016\t\u0007\u0005k\u0012\tIa*\u0011\t\t%%\u0011\u0016\u0003\f\u0005Wk\u0013\u0011!A\u0001\u0006\u0003\u0011yIA\u0002`IMBqAa,.\u0001\u0004\u0011\t,A\ffqB,7\r^3e)>\u0004\u0018n\u0019)beRLG/[8ogB1!1\u0017Ba\u0003CqAA!.\u0003>B\u0019!qW$\u000e\u0005\te&b\u0001B^\u0007\u00061AH]8pizJ1Aa0H\u0003\u0019\u0001&/\u001a3fM&!!1\u0019Bc\u0005\r\u0019V\r\u001e\u0006\u0004\u0005\u007f;\u0005b\u0002Be[\u0001\u0007!1Z\u0001\u0010Kb\u0004Xm\u0019;fIZ+'o]5p]B\u0019aI!4\n\u0007\t=wIA\u0003TQ>\u0014H/\u0001\nnC.,7\t\\5f]R\u0014Vm\u001d9p]N,GCBA\u0000\u0005+\u0014i\u000eC\u0004\u0002~:\u0002\rAa6\u0011\t\t]$\u0011\\\u0005\u0005\u00057\u0014IH\u0001\fBYR,'\u000fU1si&$\u0018n\u001c8SKN\u0004xN\\:f\u0011\u001d\u0011yN\fa\u0001\u0005\u0017\fqA^3sg&|g.\u0001\nnC.,\u0017\t\u001c;feB\u000b'\u000f^5uS>tG\u0003\u0002Bl\u0005KDqAa:0\u0001\u0004\u0011I/\u0001\u0004u_BL7m\u001d\t\u0007\u0005W\u0014)Pa?\u000f\t\t5(\u0011\u001f\b\u0005\u0005o\u0013y/C\u0001I\u0013\r\u0011\u0019pR\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00119P!?\u0003\u0007M+\u0017OC\u0002\u0003t\u001e\u0003BA!@\u0004\n9!!q`B\u0003\u001b\t\u0019\tAC\u0002\u0004\u0004y\u000bq!\\3tg\u0006<W-\u0003\u0003\u0004\b\r\u0005\u0011AG!mi\u0016\u0014\b+\u0019:uSRLwN\u001c*fgB|gn]3ECR\f\u0017\u0002BB\u0006\u0007\u001b\u0011\u0011\u0002V8qS\u000e$\u0015\r^1\u000b\t\r\u001d1\u0011A\u0001\u001c[\u0006\\W-\u00117uKJ\u0004\u0016M\u001d;ji&|g\u000eV8qS\u000e$\u0015\r^1\u0015\r\tm81CB\f\u0011\u001d\u0019)\u0002\ra\u0001\u0003C\t\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\t\u000f\u0005%\b\u00071\u0001\u0002l\u0006YA/Z:u5.\u0014\u0015m]5dQ\r\t\u0014\u0011Z\u0001\u0012a\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,GC\u0004Bl\u0007C\u0019\u0019c!\n\u0004*\r52\u0011\u0007\u0005\n\u0005[\u0011\u0004\u0013!a\u0001\u0003CA\u0011\"!;3!\u0003\u0005\r!a;\t\u0011\r\u001d\"\u0007%AA\u0002q\fa\u0002]1si&$\u0018n\u001c8Fa>\u001c\u0007\u000e\u0003\u0005\u0004,I\u0002\n\u00111\u0001}\u0003!aW-\u00193fe&#\u0007\u0002CB\u0018eA\u0005\t\u0019\u0001?\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\n\u0007g\u0011\u0004\u0013!a\u0001\u0007k\t1![:s!\u0015\u0011Yoa\u000e}\u0013\u0011\u0019ID!?\u0003\t1K7\u000f^\u0001\u001ca\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\r}\"\u0006BA\u0011\u0007\u0003Z#aa\u0011\u0011\t\r\u00153qJ\u0007\u0003\u0007\u000fRAa!\u0013\u0004L\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007\u001b:\u0015AC1o]>$\u0018\r^5p]&!1\u0011KB$\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001ca\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r]#\u0006BAv\u0007\u0003\n1\u0004]1si&$\u0018n\u001c8SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012\u001aTCAB/U\ra8\u0011I\u0001\u001ca\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000f\n\u001b\u00027A\f'\u000f^5uS>t'+Z:q_:\u001cX\r\n3fM\u0006,H\u000e\u001e\u00136\u0003m\u0001\u0018M\u001d;ji&|gNU3ta>t7/\u001a\u0013eK\u001a\fW\u000f\u001c;%mU\u00111q\r\u0016\u0005\u0007k\u0019\t%A\rBYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:UKN$\bC\u0001(;'\tQT\t\u0006\u0002\u0004lQ\u001111\u000f\t\u0007\u0007k\u001ai(a\u0015\u000e\u0005\r]$\u0002BB=\u0007w\naa\u001d;sK\u0006l'BA7V\u0013\u0011\u0019yha\u001e\u0003\rM#(/Z1n)\t\u0019\u0019\t\u0005\u0004\u0004v\ru4Q\u0011\t\u0005\u0003_\u001a9)\u0003\u0003\u0004\n\u0006E$!C!sOVlWM\u001c;t\u0001")
public class AlterPartitionManagerTest {
    private final String topic;
    private final Uuid topicId = Uuid.randomUuid();
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private NodeToControllerChannelManager brokerToController;
    private final TopicIdPartition tp0 = new TopicIdPartition(this.topicId(), 0, this.topic());
    private final TopicIdPartition tp1 = new TopicIdPartition(this.topicId(), 1, this.topic());
    private final TopicIdPartition tp2 = new TopicIdPartition(this.topicId(), 2, this.topic());

    public static Stream<Arguments> provideLeaderRecoveryState() {
        return AlterPartitionManagerTest$.MODULE$.provideLeaderRecoveryState();
    }

    public static Stream<MetadataVersion> provideMetadataVersions() {
        return AlterPartitionManagerTest$.MODULE$.provideMetadataVersions();
    }

    public String topic() {
        return this.topic;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public NodeToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(NodeToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public TopicIdPartition tp0() {
        return this.tp0;
    }

    public TopicIdPartition tp1() {
        return this.tp1;
    }

    public TopicIdPartition tp2() {
        return this.tp2;
    }

    @BeforeEach
    public void setup() {
        this.brokerToController_$eq((NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class));
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testBasic(MetadataVersion metadataVersion) {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testBasicWithBrokerEpoch(MetadataVersion metadataVersion) {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 101L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        ListBuffer isrWithBrokerEpoch = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).foreach((Function1 & Serializable)ii -> AlterPartitionManagerTest.$anonfun$testBasicWithBrokerEpoch$3(isrWithBrokerEpoch, BoxesRunTime.unboxToInt((Object)ii)));
        alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, LeaderRecoveryState.RECOVERED, isrWithBrokerEpoch.toList(), 10), 0);
        AlterPartitionRequestData expectedAlterPartitionData = new AlterPartitionRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(101L);
        AlterPartitionRequestData.TopicData topicData = new AlterPartitionRequestData.TopicData().setTopicName(this.topic()).setTopicId(this.topicId());
        if (metadataVersion.isTopicIdsSupported()) {
            ListBuffer newIsrWithBrokerEpoch = new ListBuffer();
            newIsrWithBrokerEpoch.append((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(1).setBrokerEpoch(101L));
            newIsrWithBrokerEpoch.append((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(2).setBrokerEpoch(102L));
            newIsrWithBrokerEpoch.append((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(3).setBrokerEpoch(103L));
            topicData.partitions().add(new AlterPartitionRequestData.PartitionData().setPartitionIndex(0).setLeaderEpoch(1).setPartitionEpoch(10).setNewIsrWithEpochs(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)newIsrWithBrokerEpoch.toList()).asJava()));
        } else {
            topicData.partitions().add(new AlterPartitionRequestData.PartitionData().setPartitionIndex(0).setLeaderEpoch(1).setPartitionEpoch(10).setNewIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()));
        }
        expectedAlterPartitionData.topics().add(topicData);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ArgumentCaptor captor = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)captor.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedAlterPartitionData, (Object)((AlterPartitionRequest)((AlterPartitionRequest.Builder)captor.getValue()).build()).data());
    }

    @ParameterizedTest
    @MethodSource(value={"provideLeaderRecoveryState"})
    public void testBasicSentLeaderRecoveryState(MetadataVersion metadataVersion, LeaderRecoveryState leaderRecoveryState) {
        ArgumentCaptor requestCapture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), leaderRecoveryState, 10), 0);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)requestCapture.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)requestCapture.getValue()).build();
        Assertions.assertEquals((byte)(metadataVersion.isAtLeast(MetadataVersion.IBP_3_2_IV0) ? leaderRecoveryState : LeaderRecoveryState.RECOVERED).value(), (byte)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).leaderRecoveryState());
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testOverwriteWithinBatch(MetadataVersion metadataVersion) {
        boolean canUseTopicIds = metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV0);
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        Assertions.assertFalse((boolean)alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0).isDone());
        CompletableFuture failedSubmitFuture = alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), LeaderRecoveryState.RECOVERED, 10), 0);
        Assertions.assertTrue((boolean)failedSubmitFuture.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)failedSubmitFuture, OperationNotAttemptedException.class);
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(this.tp0(), Errors.NONE, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertFalse((boolean)alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), LeaderRecoveryState.RECOVERED, 10), 0).isDone());
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        if (request.version() < 3) {
            Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
            return;
        }
        Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsrWithEpochs().size(), (int)1);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testSingleBatch(MetadataVersion metadataVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(new TopicIdPartition(this.topicId(), 0, this.topic()), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 9).foreach((Function1 & Serializable)i -> alterPartitionManager.submit(new TopicIdPartition(this.topicId(), BoxesRunTime.unboxToInt((Object)i), this.topic()), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0));
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().size(), (int)10);
    }

    @Test
    public void testSubmitFromCallback() {
        AlterPartitionResponse alterPartitionRespWithPartitionError = this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse errorResponse = this.makeClientResponse(alterPartitionRespWithPartitionError, ApiKeys.ALTER_PARTITION.latestVersion());
        int leaderId = 1;
        int leaderEpoch = 1;
        int partitionEpoch = 10;
        List isr = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderId, leaderEpoch, isr, LeaderRecoveryState.RECOVERED, partitionEpoch);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0);
        CompletableFuture finalFuture = new CompletableFuture();
        future.whenComplete((x$2, e2) -> {
            if (e2 != null) {
                alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0).whenComplete((result, e) -> {
                    if (e != null) {
                        finalFuture.completeExceptionally((Throwable)e);
                        return;
                    }
                    finalFuture.complete(result);
                });
                return;
            }
            finalFuture.completeExceptionally((Throwable)((Object)new AssertionError((Object)"Expected the future to be failed")));
        });
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{this.brokerToController()});
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(errorResponse);
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, partitionEpoch, leaderId, leaderEpoch, (List<Object>)isr);
        ClientResponse retryResponse = this.makeClientResponse(retryAlterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertEquals((Object)leaderAndIsr, finalFuture.get(200L, TimeUnit.MILLISECONDS));
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
    }

    @Test
    public void testAuthorizationFailed() {
        this.testRetryOnTopLevelError(Errors.CLUSTER_AUTHORIZATION_FAILED);
    }

    @Test
    public void testStaleBrokerEpoch() {
        this.testRetryOnTopLevelError(Errors.STALE_BROKER_EPOCH);
    }

    @Test
    public void testUnknownServer() {
        this.testRetryOnTopLevelError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void testRetryOnAuthenticationFailure() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, null, new AuthenticationException("authentication failed"), null));
    }

    @Test
    public void testRetryOnUnsupportedVersionError() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, new UnsupportedVersionException("unsupported version"), null, null));
    }

    private void testRetryOnTopLevelError(Errors error) {
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData().setErrorCode(error.code()));
        ClientResponse response = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        this.testRetryOnErrorResponse(response);
    }

    private void testRetryOnErrorResponse(ClientResponse response) {
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(response);
        Assertions.assertTrue((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{this.brokerToController()});
        this.time().sleep(100L);
        scheduler.tick();
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse retryResponse = this.makeClientResponse(retryAlterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
    }

    @Test
    public void testInvalidUpdateVersion() {
        this.checkPartitionError(Errors.INVALID_UPDATE_VERSION);
    }

    @Test
    public void testUnknownTopicPartition() {
        this.checkPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testNotLeaderOrFollower() {
        this.checkPartitionError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    @Test
    public void testInvalidRequest() {
        this.checkPartitionError(Errors.INVALID_REQUEST);
    }

    private void checkPartitionError(Errors error) {
        Assertions.assertFalse((boolean)this.testPartitionError(this.tp0(), error).submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0).isDone());
    }

    private AlterPartitionManager testPartitionError(TopicIdPartition tp, Errors error) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(tp, LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(tp, error, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, (Class)error.exception().getClass());
        return alterPartitionManager;
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testOneInFlight(MetadataVersion metadataVersion) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        alterPartitionManager.submit(this.tp1(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        alterPartitionManager.submit(this.tp2(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testPartitionMissingInResponse(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isTopicIdsSupported() ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1;
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10);
        int controlledEpoch = 0;
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        NodeToControllerChannelManager brokerToController = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(brokerToController, (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> brokerEpoch, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        CompletableFuture future1 = alterPartitionManager.submit(this.tp0(), leaderAndIsr, controlledEpoch);
        ControllerRequestCompletionHandler callback1 = this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp0()}))), expectedVersion));
        CompletableFuture future2 = alterPartitionManager.submit(this.tp1(), leaderAndIsr, controlledEpoch);
        CompletableFuture future3 = alterPartitionManager.submit(this.tp2(), leaderAndIsr, controlledEpoch);
        callback1.onComplete(this.makeClientResponse(this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future1, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp1(), this.tp2()}))), expectedVersion)).onComplete(this.makeClientResponse(this.partitionResponse(this.tp2(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future3, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp1()}))), expectedVersion)).onComplete(this.makeClientResponse(this.partitionResponse(this.tp1(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future2, UnknownServerException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testPartialTopicIds(MetadataVersion metadataVersion) {
        boolean canUseTopicIds = metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV0);
        TopicIdPartition foo = new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo");
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), 0, "bar");
        TopicIdPartition zar = new TopicIdPartition(Uuid.randomUuid(), 0, "zar");
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10);
        int controlledEpoch = 0;
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        NodeToControllerChannelManager brokerToController = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(brokerToController, (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> brokerEpoch, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        CompletableFuture future1 = alterPartitionManager.submit(zar, leaderAndIsr, controlledEpoch);
        ControllerRequestCompletionHandler callback1 = this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{zar}))), canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1));
        CompletableFuture future2 = alterPartitionManager.submit(foo, leaderAndIsr, controlledEpoch);
        CompletableFuture future3 = alterPartitionManager.submit(bar, leaderAndIsr, controlledEpoch);
        callback1.onComplete(this.makeClientResponse(this.makeAlterPartition((scala.collection.immutable.Seq<AlterPartitionResponseData.TopicData>)new .colon.colon((Object)this.makeAlterPartitionTopicData(zar, Errors.NONE), (List)Nil$.MODULE$)), canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1));
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo, bar}))), (short)1)).onComplete(this.makeClientResponse(this.makeAlterPartition((scala.collection.immutable.Seq<AlterPartitionResponseData.TopicData>)new .colon.colon((Object)this.makeAlterPartitionTopicData(foo, Errors.NONE), (List)new .colon.colon((Object)this.makeAlterPartitionTopicData(bar, Errors.NONE), (List)Nil$.MODULE$))), (short)1));
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertTrue((boolean)future2.isDone());
        Assertions.assertTrue((boolean)future3.isDone());
    }

    private ControllerRequestCompletionHandler verifySendRequest(NodeToControllerChannelManager brokerToController, ArgumentMatcher<AbstractRequest.Builder<? extends AbstractRequest>> expectedRequest) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((NodeToControllerChannelManager)Mockito.verify((Object)brokerToController)).sendRequest((AbstractRequest.Builder)ArgumentMatchers.argThat(expectedRequest), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{brokerToController});
        return (ControllerRequestCompletionHandler)callbackCapture.getValue();
    }

    private ArgumentMatcher<AbstractRequest.Builder<? extends AbstractRequest>> alterPartitionRequestMatcher(Set<TopicIdPartition> expectedTopicPartitions, short expectedVersion) {
        return request -> {
            Assertions.assertEquals((Object)ApiKeys.ALTER_PARTITION, (Object)request.apiKey());
            AlterPartitionRequest alterPartitionRequest = (AlterPartitionRequest)((AlterPartitionRequest.Builder)request).build();
            Assertions.assertEquals((short)expectedVersion, (short)alterPartitionRequest.version());
            Set requestTopicPartitions = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(alterPartitionRequest.data().topics()).asScala().flatMap((Function1 & Serializable)topicData -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicData.partitions()).asScala().map((Function1 & Serializable)partitionData -> new TopicIdPartition(topicData.topicId(), partitionData.partitionIndex(), topicData.topicName())))).toSet();
            Set set = expectedTopicPartitions;
            return !(set != null ? !set.equals(requestTopicPartitions) : requestTopicPartitions != null);
        };
    }

    private ClientResponse makeClientResponse(AlterPartitionResponse response, short version) {
        return new ClientResponse(new RequestHeader(response.apiKey(), version, "", 0), null, "", 0L, 0L, false, null, null, (AbstractResponse)AlterPartitionResponse.parse((ByteBuffer)MessageUtil.toByteBuffer((Message)response.data(), (short)version), (short)version));
    }

    private AlterPartitionResponse makeAlterPartition(scala.collection.immutable.Seq<AlterPartitionResponseData.TopicData> topics) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics(CollectionConverters$.MODULE$.SeqHasAsJava(topics).asJava()));
    }

    private AlterPartitionResponseData.TopicData makeAlterPartitionTopicData(TopicIdPartition topicIdPartition, Errors error) {
        return new AlterPartitionResponseData.TopicData().setTopicName(topicIdPartition.topic()).setTopicId(topicIdPartition.topicId()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(topicIdPartition.partition()).setErrorCode(error.code())));
    }

    @Test
    public void testZkBasic() {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$3 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.doAnswer(x$4 -> new Tuple2.mcZI.sp(false, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)3), (Option)ArgumentMatchers.any());
        ZkAlterPartitionManager zkIsrManager = new ZkAlterPartitionManager((Scheduler)scheduler, (Time)this.time(), kafkaZkClient);
        zkIsrManager.start();
        CompletableFuture future1 = zkIsrManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 1), 0);
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertEquals((Object)LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 2), future1.get());
        CompletableFuture future2 = zkIsrManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 3), 0);
        Assertions.assertTrue((boolean)future2.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future2, InvalidUpdateVersionException.class);
    }

    private AlterPartitionResponse partitionResponse(TopicIdPartition tp, Errors error, int partitionEpoch, int leaderId, int leaderEpoch, List<Object> isr) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics(Collections.singletonList(new AlterPartitionResponseData.TopicData().setTopicName(tp.topic()).setTopicId(tp.topicId()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(tp.partition()).setPartitionEpoch(partitionEpoch).setLeaderEpoch(leaderEpoch).setLeaderId(leaderId).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)isr.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setErrorCode(error.code()))))));
    }

    private TopicIdPartition partitionResponse$default$1() {
        return this.tp0();
    }

    private Errors partitionResponse$default$2() {
        return Errors.NONE;
    }

    private int partitionResponse$default$3() {
        return 0;
    }

    private int partitionResponse$default$4() {
        return 0;
    }

    private int partitionResponse$default$5() {
        return 0;
    }

    private List<Object> partitionResponse$default$6() {
        return package$.MODULE$.List().empty();
    }

    public static final /* synthetic */ ListBuffer $anonfun$testBasicWithBrokerEpoch$3(ListBuffer isrWithBrokerEpoch$1, int ii) {
        return (ListBuffer)isrWithBrokerEpoch$1.$plus$eq((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(ii).setBrokerEpoch((long)(100 + ii)));
    }

    public AlterPartitionManagerTest() {
        this.topic = "test-topic";
        this.brokerId = 1;
    }
}

