/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.layout.AnyObjectFormLayoutInfo;
import org.apache.syncope.client.console.rest.AnyObjectRestClient;
import org.apache.syncope.client.console.wizards.any.AnyObjectWizardBuilder;
import org.apache.syncope.client.console.wizards.any.AnyObjectWrapper;
import org.apache.syncope.client.console.wizards.any.Details;
import org.apache.syncope.client.console.wizards.any.TemplateWizardBuilder;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.TemplatableTO;
import org.apache.wicket.PageReference;

public class AnyObjectTemplateWizardBuilder
extends AnyObjectWizardBuilder
implements TemplateWizardBuilder<AnyObjectTO> {
    private static final long serialVersionUID = 6716803168859873877L;
    protected final TemplatableTO templatable;

    public AnyObjectTemplateWizardBuilder(TemplatableTO templatable, String anyType, List<String> anyTypeClasses, AnyObjectFormLayoutInfo formLayoutInfo, AnyObjectRestClient anyObjectRestClient, PageReference pageRef) {
        super(null, anyTypeClasses, formLayoutInfo, anyObjectRestClient, pageRef);
        this.templatable = templatable;
        if (templatable.getTemplates().containsKey(anyType)) {
            this.setItem((Serializable)((Object)new AnyObjectWrapper((AnyObjectTO)AnyObjectTO.class.cast(templatable.getTemplates().get(anyType)))));
        } else {
            AnyObjectTO anyObjectTO = new AnyObjectTO();
            anyObjectTO.setType(anyType);
            if (templatable instanceof RealmTO) {
                RealmTO realmTO = (RealmTO)templatable;
                anyObjectTO.setRealm(String.format("'%s'", RealmsUtils.getFullPath(realmTO.getFullPath())));
            }
            this.setItem((Serializable)((Object)new AnyObjectWrapper(anyObjectTO)));
        }
    }

    @Override
    protected Optional<Details<AnyObjectTO>> addOptionalDetailsPanel(AnyWrapper<AnyObjectTO> modelObject) {
        Optional<Details<AnyObjectTO>> details = super.addOptionalDetailsPanel(modelObject);
        if (this.templatable instanceof RealmTO) {
            details.ifPresent(Details::disableRealmSpecification);
        }
        return details;
    }

    @Override
    public AjaxWizard<AnyWrapper<AnyObjectTO>> build(String id) {
        return super.build(id, AjaxWizard.Mode.TEMPLATE);
    }
}

