/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.impl;

import java.io.Serializable;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.configuration.model.support.pm.ResetPasswordManagementProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.pm.InvalidPasswordException;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.inspektr.audit.annotation.Audit;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePasswordManagementService
implements PasswordManagementService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePasswordManagementService.class);
    protected final PasswordManagementProperties properties;
    private final CipherExecutor<Serializable, String> cipherExecutor;
    private final String issuer;
    private final PasswordHistoryService passwordHistoryService;

    @Override
    public String parseToken(String token) {
        try {
            String json = (String)this.cipherExecutor.decode((Object)token);
            JwtClaims claims = JwtClaims.parse((String)json);
            ResetPasswordManagementProperties resetProperties = this.properties.getReset();
            if (!claims.getIssuer().equals(this.issuer)) {
                LOGGER.error("Token issuer does not match CAS");
                return null;
            }
            if (claims.getAudience().isEmpty() || !((String)claims.getAudience().get(0)).equals(this.issuer)) {
                LOGGER.error("Token audience does not match CAS");
                return null;
            }
            if (StringUtils.isBlank((CharSequence)claims.getSubject())) {
                LOGGER.error("Token has no subject identifier");
                return null;
            }
            ClientInfo holder = ClientInfoHolder.getClientInfo();
            if (resetProperties.isIncludeServerIpAddress() && !claims.getStringClaimValue("origin").equals(holder.getServerIpAddress())) {
                LOGGER.error("Token origin server IP address does not match CAS");
                return null;
            }
            if (resetProperties.isIncludeClientIpAddress() && !claims.getStringClaimValue("client").equals(holder.getClientIpAddress())) {
                LOGGER.error("Token client IP address does not match CAS");
                return null;
            }
            NumericDate expirationTime = claims.getExpirationTime();
            if (expirationTime.isBefore(NumericDate.now())) {
                LOGGER.error("Token has expired.");
                return null;
            }
            return claims.getSubject();
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    @Override
    public String createToken(PasswordManagementQuery query) {
        try {
            String token = UUID.randomUUID().toString();
            JwtClaims claims = new JwtClaims();
            ResetPasswordManagementProperties resetProperties = this.properties.getReset();
            claims.setJwtId(token);
            claims.setIssuer(this.issuer);
            claims.setAudience(this.issuer);
            long minutes = Beans.newDuration((String)resetProperties.getExpiration()).toMinutes();
            claims.setExpirationTimeMinutesInTheFuture((float)minutes);
            claims.setIssuedAtToNow();
            ClientInfo holder = ClientInfoHolder.getClientInfo();
            if (holder != null) {
                if (resetProperties.isIncludeServerIpAddress()) {
                    claims.setStringClaim("origin", holder.getServerIpAddress());
                }
                if (resetProperties.isIncludeClientIpAddress()) {
                    claims.setStringClaim("client", holder.getClientIpAddress());
                }
            }
            claims.setSubject(query.getUsername());
            LOGGER.debug("Creating password management token for [{}]", (Object)query.getUsername());
            String json = claims.toJson();
            LOGGER.debug("Encoding the generated JSON token...");
            return (String)this.cipherExecutor.encode((Object)json);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    @Override
    @Audit(action="CHANGE_PASSWORD", actionResolverName="CHANGE_PASSWORD_ACTION_RESOLVER", resourceResolverName="CHANGE_PASSWORD_RESOURCE_RESOLVER")
    public boolean change(Credential credential, PasswordChangeRequest bean) throws InvalidPasswordException {
        if (this.passwordHistoryService != null && this.passwordHistoryService.exists(bean)) {
            LOGGER.debug("Password history policy disallows reusing the password for [{}]", (Object)credential.getId());
            return false;
        }
        if (this.changeInternal(credential, bean)) {
            if (this.passwordHistoryService != null) {
                LOGGER.debug("Password successfully changed; storing used password in history for [{}]...", (Object)credential.getId());
                return this.passwordHistoryService.store(bean);
            }
            return true;
        }
        return false;
    }

    public abstract boolean changeInternal(Credential var1, PasswordChangeRequest var2) throws InvalidPasswordException;

    @Generated
    public BasePasswordManagementService(PasswordManagementProperties properties, CipherExecutor<Serializable, String> cipherExecutor, String issuer, PasswordHistoryService passwordHistoryService) {
        this.properties = properties;
        this.cipherExecutor = cipherExecutor;
        this.issuer = issuer;
        this.passwordHistoryService = passwordHistoryService;
    }

    @Generated
    public PasswordManagementProperties getProperties() {
        return this.properties;
    }

    @Generated
    public CipherExecutor<Serializable, String> getCipherExecutor() {
        return this.cipherExecutor;
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public PasswordHistoryService getPasswordHistoryService() {
        return this.passwordHistoryService;
    }
}

