/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.Task;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.api.DecisionServiceExecutionAuditContainer;
import org.flowable.dmn.api.DmnDecisionService;
import org.flowable.dmn.api.ExecuteDecisionBuilder;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.DelegateHelper;
import org.flowable.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.DynamicPropertyUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;

public class DmnActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected static final String EXPRESSION_DECISION_TABLE_REFERENCE_KEY = "decisionTableReferenceKey";
    protected static final String EXPRESSION_DECISION_TABLE_THROW_ERROR_FLAG = "decisionTaskThrowErrorOnNoHits";
    protected static final String EXPRESSION_DECISION_TABLE_FALLBACK_TO_DEFAULT_TENANT = "fallbackToDefaultTenant";
    protected static final String EXPRESSION_DECISION_TABLE_SAME_DEPLOYMENT = "sameDeployment";
    protected Task task;

    public DmnActivityBehavior(Task task) {
        this.task = task;
    }

    @Override
    public void execute(DelegateExecution execution) {
        FieldExtension fieldExtension = DelegateHelper.getFlowElementField(execution, EXPRESSION_DECISION_TABLE_REFERENCE_KEY);
        if (fieldExtension == null || (fieldExtension.getStringValue() == null || fieldExtension.getStringValue().length() == 0) && (fieldExtension.getExpression() == null || fieldExtension.getExpression().length() == 0)) {
            throw new FlowableException("decisionTableReferenceKey is a required field extension for the dmn task " + this.task.getId());
        }
        String activeDecisionKey = null;
        activeDecisionKey = fieldExtension.getExpression() != null && fieldExtension.getExpression().length() > 0 ? fieldExtension.getExpression() : fieldExtension.getStringValue();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        if (processEngineConfiguration.isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(this.task.getId(), execution.getProcessDefinitionId());
            activeDecisionKey = DynamicPropertyUtil.getActiveValue(activeDecisionKey, "dmnTaskDecisionTableKey", taskElementProperties);
        }
        String finalDecisionKeyValue = null;
        Object decisionKeyValue = expressionManager.createExpression(activeDecisionKey).getValue((VariableContainer)execution);
        if (decisionKeyValue != null) {
            if (decisionKeyValue instanceof String) {
                finalDecisionKeyValue = (String)decisionKeyValue;
            } else {
                throw new FlowableIllegalArgumentException("decisionTableReferenceKey expression does not resolve to a string: " + decisionKeyValue);
            }
        }
        if (finalDecisionKeyValue == null || finalDecisionKeyValue.length() == 0) {
            throw new FlowableIllegalArgumentException("decisionTableReferenceKey expression resolves to an empty value: " + decisionKeyValue);
        }
        DmnDecisionService ruleService = CommandContextUtil.getDmnRuleService();
        ExecuteDecisionBuilder executeDecisionBuilder = ruleService.createExecuteDecisionBuilder().decisionKey(finalDecisionKeyValue).instanceId(execution.getProcessInstanceId()).executionId(execution.getId()).activityId(this.task.getId()).variables(execution.getVariables()).tenantId(execution.getTenantId());
        this.applyFallbackToDefaultTenant(execution, executeDecisionBuilder);
        this.applyParentDeployment(execution, executeDecisionBuilder, processEngineConfiguration);
        DecisionExecutionAuditContainer decisionExecutionAuditContainer = executeDecisionBuilder.executeWithAuditTrail();
        if (decisionExecutionAuditContainer.isFailed().booleanValue()) {
            throw new FlowableException("DMN decision with key " + finalDecisionKeyValue + " execution failed. Cause: " + decisionExecutionAuditContainer.getExceptionMessage());
        }
        FieldExtension throwErrorFieldExtension = DelegateHelper.getFlowElementField(execution, EXPRESSION_DECISION_TABLE_THROW_ERROR_FLAG);
        if (throwErrorFieldExtension != null) {
            String throwErrorString = null;
            if (StringUtils.isNotEmpty((CharSequence)throwErrorFieldExtension.getStringValue())) {
                throwErrorString = throwErrorFieldExtension.getStringValue();
            } else if (StringUtils.isNotEmpty((CharSequence)throwErrorFieldExtension.getExpression())) {
                throwErrorString = throwErrorFieldExtension.getExpression();
            }
            if (decisionExecutionAuditContainer.getDecisionResult().isEmpty() && throwErrorString != null) {
                Expression expression;
                Object expressionValue;
                if ("true".equalsIgnoreCase(throwErrorString)) {
                    throw new FlowableException("DMN decision with key " + finalDecisionKeyValue + " did not hit any rules for the provided input.");
                }
                if (!"false".equalsIgnoreCase(throwErrorString) && (expressionValue = (expression = expressionManager.createExpression(throwErrorString)).getValue((VariableContainer)execution)) instanceof Boolean && ((Boolean)expressionValue).booleanValue()) {
                    throw new FlowableException("DMN decision with key " + finalDecisionKeyValue + " did not hit any rules for the provided input.");
                }
            }
        }
        if (processEngineConfiguration.getDecisionTableVariableManager() != null) {
            if (decisionExecutionAuditContainer instanceof DecisionServiceExecutionAuditContainer) {
                DecisionServiceExecutionAuditContainer decisionServiceExecutionAuditContainer = (DecisionServiceExecutionAuditContainer)decisionExecutionAuditContainer;
                processEngineConfiguration.getDecisionTableVariableManager().setDecisionServiceVariablesOnExecution(decisionServiceExecutionAuditContainer.getDecisionServiceResult(), finalDecisionKeyValue, execution, processEngineConfiguration.getObjectMapper(), decisionExecutionAuditContainer.isMultipleResults());
            } else {
                processEngineConfiguration.getDecisionTableVariableManager().setVariablesOnExecution(decisionExecutionAuditContainer.getDecisionResult(), finalDecisionKeyValue, execution, processEngineConfiguration.getObjectMapper(), decisionExecutionAuditContainer.isMultipleResults());
            }
        } else {
            boolean multipleResults;
            boolean bl = multipleResults = decisionExecutionAuditContainer.isMultipleResults() && processEngineConfiguration.isAlwaysUseArraysForDmnMultiHitPolicies();
            if (decisionExecutionAuditContainer instanceof DecisionServiceExecutionAuditContainer) {
                DecisionServiceExecutionAuditContainer decisionServiceExecutionAuditContainer = (DecisionServiceExecutionAuditContainer)decisionExecutionAuditContainer;
                this.setDecisionServiceVariablesOnExecution(decisionServiceExecutionAuditContainer.getDecisionServiceResult(), finalDecisionKeyValue, execution, processEngineConfiguration.getObjectMapper(), multipleResults);
            } else {
                this.setVariablesOnExecution(decisionExecutionAuditContainer.getDecisionResult(), finalDecisionKeyValue, execution, processEngineConfiguration.getObjectMapper(), multipleResults);
            }
        }
        this.leave(execution);
    }

    protected void applyFallbackToDefaultTenant(DelegateExecution execution, ExecuteDecisionBuilder executeDecisionBuilder) {
        String fallbackToDefaultTenant;
        FieldExtension fallbackfieldExtension = DelegateHelper.getFlowElementField(execution, EXPRESSION_DECISION_TABLE_FALLBACK_TO_DEFAULT_TENANT);
        if (fallbackfieldExtension != null && fallbackfieldExtension.getStringValue() != null && fallbackfieldExtension.getStringValue().length() != 0 && StringUtils.isNotEmpty((CharSequence)(fallbackToDefaultTenant = fallbackfieldExtension.getStringValue())) && Boolean.parseBoolean(fallbackToDefaultTenant)) {
            executeDecisionBuilder.fallbackToDefaultTenant();
        }
    }

    protected void applyParentDeployment(DelegateExecution execution, ExecuteDecisionBuilder executeDecisionBuilder, ProcessEngineConfigurationImpl processEngineConfiguration) {
        FieldExtension sameDeploymentFieldExtension = DelegateHelper.getFlowElementField(execution, EXPRESSION_DECISION_TABLE_SAME_DEPLOYMENT);
        String parentDeploymentId = sameDeploymentFieldExtension != null ? (Boolean.parseBoolean(sameDeploymentFieldExtension.getStringValue()) ? ProcessDefinitionUtil.getDefinitionDeploymentId(execution.getProcessDefinitionId(), processEngineConfiguration) : null) : ProcessDefinitionUtil.getDefinitionDeploymentId(execution.getProcessDefinitionId(), processEngineConfiguration);
        executeDecisionBuilder.parentDeploymentId(parentDeploymentId);
    }

    protected void setDecisionServiceVariablesOnExecution(Map<String, List<Map<String, Object>>> executionResult, String decisionServiceKey, DelegateExecution execution, ObjectMapper objectMapper, boolean multipleResults) {
        if (executionResult == null || executionResult.isEmpty() && !multipleResults) {
            return;
        }
        if (this.hasMultipleResults(executionResult) || multipleResults) {
            ObjectNode decisionResultNode = objectMapper.createObjectNode();
            for (Map.Entry<String, List<Map<String, Object>>> decisionExecutionResult : executionResult.entrySet()) {
                ArrayNode ruleResultNode = objectMapper.createArrayNode();
                for (Map<String, Object> ruleResult : decisionExecutionResult.getValue()) {
                    ObjectNode outputResultNode = objectMapper.createObjectNode();
                    for (Map.Entry<String, Object> outputResult : ruleResult.entrySet()) {
                        outputResultNode.set(outputResult.getKey(), (JsonNode)objectMapper.convertValue(outputResult.getValue(), JsonNode.class));
                    }
                    ruleResultNode.add((JsonNode)outputResultNode);
                }
                decisionResultNode.set(decisionExecutionResult.getKey(), (JsonNode)ruleResultNode);
            }
            execution.setVariable(decisionServiceKey, decisionResultNode);
        } else {
            executionResult.values().forEach(decisionResult -> {
                for (Map.Entry outputResult : ((Map)decisionResult.get(0)).entrySet()) {
                    execution.setVariable((String)outputResult.getKey(), outputResult.getValue());
                }
            });
        }
    }

    protected void setVariablesOnExecution(List<Map<String, Object>> executionResult, String decisionKey, DelegateExecution execution, ObjectMapper objectMapper, boolean multipleResults) {
        if (executionResult == null || executionResult.isEmpty() && !multipleResults) {
            return;
        }
        if (executionResult.size() > 1 || multipleResults) {
            ArrayNode ruleResultNode = objectMapper.createArrayNode();
            for (Map<String, Object> ruleResult : executionResult) {
                ObjectNode outputResultNode = objectMapper.createObjectNode();
                for (Map.Entry<String, Object> outputResult : ruleResult.entrySet()) {
                    outputResultNode.set(outputResult.getKey(), (JsonNode)objectMapper.convertValue(outputResult.getValue(), JsonNode.class));
                }
                ruleResultNode.add((JsonNode)outputResultNode);
            }
            execution.setVariable(decisionKey, ruleResultNode);
        } else {
            Map<String, Object> ruleResult = executionResult.get(0);
            for (Map.Entry<String, Object> outputResult : ruleResult.entrySet()) {
                execution.setVariable(outputResult.getKey(), outputResult.getValue());
            }
        }
    }

    protected boolean hasMultipleResults(Map<String, List<Map<String, Object>>> executionResult) {
        boolean hasMultipleResults = false;
        for (Map.Entry<String, List<Map<String, Object>>> entry : executionResult.entrySet()) {
            List<Map<String, Object>> decisionResult = entry.getValue();
            if (decisionResult.size() <= 1) continue;
            hasMultipleResults = true;
            break;
        }
        return hasMultipleResults;
    }
}

