/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.event.hook;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.okta.sdk.client.Client;
import com.okta.sdk.resource.event.hook.EventHook;
import com.okta.sdk.resource.event.hook.EventHookBuilder;
import com.okta.sdk.resource.event.hook.EventHookChannel;
import com.okta.sdk.resource.event.hook.EventHookChannelConfig;
import com.okta.sdk.resource.event.hook.EventHookChannelConfigAuthScheme;
import com.okta.sdk.resource.event.hook.EventHookChannelConfigAuthSchemeType;
import com.okta.sdk.resource.event.hook.EventHookChannelConfigHeader;
import com.okta.sdk.resource.event.hook.EventSubscriptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DefaultEventHookBuilder
implements EventHookBuilder {
    private static final String LIFECYCLE_EVENT_CREATE = "user.lifecycle.create";
    private static final String LIFECYCLE_EVENT_ACTIVATE = "user.lifecycle.activate";
    private static final String VERSION = "1.0.0";
    private String name;
    private String url;
    private String authorizationHeaderValue;
    private Map<String, String> headerMap = Maps.newHashMap();

    public EventHookBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public EventHookBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public EventHookBuilder setAuthorizationHeaderValue(String authorizationHeaderValue) {
        this.authorizationHeaderValue = authorizationHeaderValue;
        return this;
    }

    public EventHookBuilder addHeader(String name, String value) {
        this.headerMap.put(name, value);
        return this;
    }

    public EventHook buildAndCreate(Client client) {
        EventSubscriptions eventSubscriptions = ((EventSubscriptions)client.instantiate(EventSubscriptions.class)).setType(EventSubscriptions.TypeEnum.EVENT_TYPE).setItems(Arrays.asList(LIFECYCLE_EVENT_CREATE, LIFECYCLE_EVENT_ACTIVATE));
        EventHookChannelConfigAuthScheme eventHookChannelConfigAuthScheme = ((EventHookChannelConfigAuthScheme)client.instantiate(EventHookChannelConfigAuthScheme.class)).setType(EventHookChannelConfigAuthSchemeType.HEADER).setKey("Authorization").setValue(this.authorizationHeaderValue);
        ArrayList headers = Lists.newArrayList();
        for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
            headers.add(((EventHookChannelConfigHeader)client.instantiate(EventHookChannelConfigHeader.class)).setKey(entry.getKey()).setValue(entry.getValue()));
        }
        EventHookChannelConfig eventHookChannelConfig = ((EventHookChannelConfig)client.instantiate(EventHookChannelConfig.class)).setUri(this.url).setHeaders((List)headers).setAuthScheme(eventHookChannelConfigAuthScheme);
        EventHookChannel eventHookChannel = ((EventHookChannel)client.instantiate(EventHookChannel.class)).setType(EventHookChannel.TypeEnum.HTTP).setVersion(VERSION).setConfig(eventHookChannelConfig);
        EventHook createdEventHook = client.createEventHook(((EventHook)client.instantiate(EventHook.class)).setName(this.name).setEvents(eventSubscriptions).setChannel(eventHookChannel));
        return createdEventHook;
    }
}

