/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.SurrogateAuthenticationExpirationPolicyBuilder;
import org.apereo.cas.authentication.SurrogateAuthenticationPostProcessor;
import org.apereo.cas.authentication.SurrogateMultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.SurrogatePrincipalBuilder;
import org.apereo.cas.authentication.SurrogatePrincipalElectionStrategy;
import org.apereo.cas.authentication.SurrogatePrincipalResolver;
import org.apereo.cas.authentication.event.DefaultSurrogateAuthenticationEventListener;
import org.apereo.cas.authentication.event.SurrogateAuthenticationEventListener;
import org.apereo.cas.authentication.principal.PrincipalElectionStrategyConfigurer;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolutionExecutionPlanConfigurer;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.surrogate.GroovySurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.JsonResourceSurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SimpleSurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.configuration.model.support.surrogate.SurrogateAuthenticationProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.expiration.builder.TicketGrantingTicketExpirationPolicyBuilder;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.merger.IAttributeMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.SurrogateAuthentication)
@AutoConfiguration
public class SurrogateAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateAuthenticationConfiguration.class);

    @Configuration(value="SurrogateAuthenticationPrincipalPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationPrincipalPlanConfiguration {
        @ConditionalOnMissingBean(name={"surrogatePrincipalResolutionExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalResolutionExecutionPlanConfigurer surrogatePrincipalResolutionExecutionPlanConfigurer(@Qualifier(value="surrogatePrincipalResolver") PrincipalResolver surrogatePrincipalResolver) {
            return plan -> plan.registerPrincipalResolver(surrogatePrincipalResolver);
        }
    }

    @Configuration(value="SurrogateAuthenticationPrincipalFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationPrincipalFactoryConfiguration {
        @ConditionalOnMissingBean(name={"surrogatePrincipalFactory"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public PrincipalFactory surrogatePrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }
    }

    @Configuration(value="SurrogateAuthenticationPrincipalResolutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @DependsOn(value={"attributeRepository"})
    public static class SurrogateAuthenticationPrincipalResolutionConfiguration {
        @ConditionalOnMissingBean(name={"surrogatePrincipalResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalResolver surrogatePrincipalResolver(CasConfigurationProperties casProperties, @Qualifier(value="surrogatePrincipalFactory") PrincipalFactory surrogatePrincipalFactory, @Qualifier(value="surrogatePrincipalBuilder") SurrogatePrincipalBuilder surrogatePrincipalBuilder, @Qualifier(value="attributeRepository") IPersonAttributeDao attributeRepository) {
            PersonDirectoryPrincipalResolverProperties principal = casProperties.getAuthn().getSurrogate().getPrincipal();
            PersonDirectoryPrincipalResolverProperties personDirectory = casProperties.getPersonDirectory();
            IAttributeMerger attributeMerger = CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger());
            SurrogatePrincipalResolver resolver = (SurrogatePrincipalResolver)CoreAuthenticationUtils.newPersonDirectoryPrincipalResolver((PrincipalFactory)surrogatePrincipalFactory, (IPersonAttributeDao)attributeRepository, (IAttributeMerger)attributeMerger, SurrogatePrincipalResolver.class, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
            resolver.setSurrogatePrincipalBuilder(surrogatePrincipalBuilder);
            return resolver;
        }
    }

    @Configuration(value="SurrogateAuthenticationPrincipalBuilderConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationPrincipalBuilderConfiguration {
        @ConditionalOnMissingBean(name={"surrogatePrincipalBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SurrogatePrincipalBuilder surrogatePrincipalBuilder(@Qualifier(value="surrogateAuthenticationService") SurrogateAuthenticationService surrogateAuthenticationService, @Qualifier(value="surrogatePrincipalFactory") PrincipalFactory surrogatePrincipalFactory, @Qualifier(value="attributeRepository") IPersonAttributeDao attributeRepository) throws Exception {
            return new SurrogatePrincipalBuilder(surrogatePrincipalFactory, attributeRepository, surrogateAuthenticationService);
        }
    }

    @Configuration(value="SurrogateAuthenticationPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationPlanConfiguration {
        @ConditionalOnMissingBean(name={"surrogateAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer surrogateAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="surrogateAuthenticationPostProcessor") AuthenticationPostProcessor surrogateAuthenticationPostProcessor) throws Exception {
            return plan -> plan.registerAuthenticationPostProcessor(surrogateAuthenticationPostProcessor);
        }
    }

    @Configuration(value="SurrogateAuthenticationServiceConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationServiceConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"surrogateAuthenticationService"})
        @Bean
        public SurrogateAuthenticationService surrogateAuthenticationService(@Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) throws Exception {
            SurrogateAuthenticationProperties su = casProperties.getAuthn().getSurrogate();
            if (su.getGroovy().getLocation() != null) {
                LOGGER.debug("Using Groovy resource [{}] to locate surrogate accounts", (Object)su.getGroovy().getLocation());
                return new GroovySurrogateAuthenticationService(servicesManager, su.getGroovy().getLocation());
            }
            if (su.getJson().getLocation() != null) {
                LOGGER.debug("Using JSON resource [{}] to locate surrogate accounts", (Object)su.getJson().getLocation());
                return new JsonResourceSurrogateAuthenticationService(su.getJson().getLocation(), servicesManager);
            }
            HashMap<String, List> accounts = new HashMap<String, List>();
            su.getSimple().getSurrogates().forEach((k, v) -> accounts.put((String)k, new ArrayList(StringUtils.commaDelimitedListToSet((String)v))));
            LOGGER.debug("Using accounts [{}] for surrogate authentication", accounts);
            return new SimpleSurrogateAuthenticationService(accounts, servicesManager);
        }
    }

    @Configuration(value="SurrogateAuthenticationPrincipalElectionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationPrincipalElectionConfiguration {
        @ConditionalOnMissingBean(name={"surrogatePrincipalElectionStrategyConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalElectionStrategyConfigurer surrogatePrincipalElectionStrategyConfigurer(CasConfigurationProperties casProperties) {
            return chain -> {
                SurrogatePrincipalElectionStrategy strategy = new SurrogatePrincipalElectionStrategy();
                IAttributeMerger merger = CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger());
                strategy.setAttributeMerger(merger);
                chain.registerElectionStrategy((PrincipalElectionStrategy)strategy);
            };
        }
    }

    @Configuration(value="SurrogateAuthenticationEventsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationEventsConfiguration {
        @ConditionalOnMissingBean(name={"surrogateAuthenticationEventListener"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SurrogateAuthenticationEventListener surrogateAuthenticationEventListener(@Qualifier(value="communicationsManager") CommunicationsManager communicationsManager, CasConfigurationProperties casProperties) {
            return new DefaultSurrogateAuthenticationEventListener(communicationsManager, casProperties);
        }
    }

    @Configuration(value="SurrogateAuthenticationExpirationPolicyConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationExpirationPolicyConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder grantingTicketExpirationPolicy(CasConfigurationProperties casProperties) {
            TicketGrantingTicketExpirationPolicyBuilder grantingTicketExpirationPolicy = new TicketGrantingTicketExpirationPolicyBuilder(casProperties);
            return new SurrogateAuthenticationExpirationPolicyBuilder((ExpirationPolicyBuilder<TicketGrantingTicket>)grantingTicketExpirationPolicy, casProperties);
        }
    }

    @Configuration(value="SurrogateAuthenticationMultifactorPrincipalResolutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationMultifactorPrincipalResolutionConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"surrogateMultifactorAuthenticationPrincipalResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationPrincipalResolver surrogateMultifactorAuthenticationPrincipalResolver() {
            return new SurrogateMultifactorAuthenticationPrincipalResolver();
        }
    }

    @Configuration(value="SurrogateAuthenticationProcessorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationProcessorConfiguration {
        @ConditionalOnMissingBean(name={"surrogateAuthenticationPostProcessor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationPostProcessor surrogateAuthenticationPostProcessor(@Qualifier(value="surrogateAuthenticationService") SurrogateAuthenticationService surrogateAuthenticationService, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="surrogateEligibilityAuditableExecution") AuditableExecution surrogateEligibilityAuditableExecution, ConfigurableApplicationContext applicationContext) throws Exception {
            return new SurrogateAuthenticationPostProcessor(surrogateAuthenticationService, servicesManager, (ApplicationEventPublisher)applicationContext, registeredServiceAccessStrategyEnforcer, surrogateEligibilityAuditableExecution);
        }
    }
}

