/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.lang.reflect.Field;
import java.time.OffsetDateTime;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.RemediationDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Remediation;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPARemediation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

public class JPARemediationDAO
extends AbstractDAO<Remediation>
implements RemediationDAO {
    @Transactional(readOnly=true)
    public Remediation find(String key) {
        return (Remediation)this.entityManager().find(JPARemediation.class, (Object)key);
    }

    public List<Remediation> findByAnyType(AnyType anyType) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARemediation.class.getSimpleName() + " e WHERE e.anyType=:anyType", Remediation.class);
        query.setParameter("anyType", (Object)anyType);
        return query.getResultList();
    }

    public List<Remediation> findByPullTask(PullTask pullTask) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARemediation.class.getSimpleName() + " e WHERE e.pullTask=:pullTask", Remediation.class);
        query.setParameter("pullTask", (Object)pullTask);
        return query.getResultList();
    }

    protected StringBuilder query(StringBuilder select, OffsetDateTime before, OffsetDateTime after) {
        StringBuilder query = select.append(JPARemediation.class.getSimpleName()).append(" e WHERE 1=1 ");
        if (before != null) {
            query.append("AND e.instant <= :before ");
        }
        if (after != null) {
            query.append("AND e.instant >= :after ");
        }
        return query;
    }

    public int count(OffsetDateTime before, OffsetDateTime after) {
        StringBuilder queryString = this.query(new StringBuilder("SELECT COUNT(e) FROM "), before, after);
        Query query = this.entityManager().createQuery(queryString.toString());
        if (before != null) {
            query.setParameter("before", (Object)before);
        }
        if (after != null) {
            query.setParameter("after", (Object)after);
        }
        return ((Number)query.getSingleResult()).intValue();
    }

    public List<Remediation> findAll(OffsetDateTime before, OffsetDateTime after, int page, int itemsPerPage, List<OrderByClause> orderByClauses) {
        StringBuilder queryString = this.query(new StringBuilder("SELECT e FROM "), before, after);
        if (!orderByClauses.isEmpty()) {
            queryString.append(" ORDER BY ");
            orderByClauses.forEach(clause -> {
                String field = clause.getField().trim();
                boolean ack = true;
                if ("resource".equals(field)) {
                    queryString.append("e.pullTask.resource.id");
                } else {
                    Field beanField = ReflectionUtils.findField(JPARemediation.class, (String)field);
                    if (beanField == null) {
                        ack = false;
                        LOG.warn("Remediation sort request by {}: unsupported, ignoring", (Object)field);
                    } else {
                        queryString.append("e.").append(field);
                    }
                }
                if (ack) {
                    if (clause.getDirection() == OrderByClause.Direction.ASC) {
                        queryString.append(" ASC");
                    } else {
                        queryString.append(" DESC");
                    }
                    queryString.append(',');
                }
            });
            queryString.deleteCharAt(queryString.length() - 1);
        }
        TypedQuery query = this.entityManager().createQuery(queryString.toString(), Remediation.class);
        if (before != null) {
            query.setParameter("before", (Object)before);
        }
        if (after != null) {
            query.setParameter("after", (Object)after);
        }
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage > 0) {
            query.setMaxResults(itemsPerPage);
        }
        return query.getResultList();
    }

    public Remediation save(Remediation remediation) {
        return (Remediation)this.entityManager().merge((Object)remediation);
    }

    public void delete(Remediation remediation) {
        this.entityManager().remove((Object)remediation);
    }

    @Transactional
    public void delete(String key) {
        Remediation remediation = this.find(key);
        if (remediation == null) {
            return;
        }
        this.delete(remediation);
    }
}

