/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.Base64;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.spring.implementation.InstanceScope;
import org.apache.syncope.core.spring.implementation.SyncopeImplementation;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@SyncopeImplementation(scope=InstanceScope.PER_CONTEXT)
public class LDAPPasswordPropagationActions
implements PropagationActions {
    protected static final String CLEARTEXT = "CLEARTEXT";
    @Autowired
    protected UserDAO userDAO;

    @Transactional(readOnly=true)
    public void before(PropagationTaskInfo taskInfo) {
        if (AnyTypeKind.USER == taskInfo.getAnyTypeKind()) {
            User user = (User)this.userDAO.find(taskInfo.getEntityKey());
            if (user == null || user.getPassword() == null) {
                return;
            }
            Set attrs = taskInfo.getPropagationData().getAttributes();
            String cipherAlgorithm = this.getCipherAlgorithm(taskInfo.getResource().getConnector());
            Optional.ofNullable(AttributeUtil.find((String)"__MANDATORY_MISSING__", (Set)attrs)).filter(missing -> !CollectionUtils.isEmpty((Collection)missing.getValue()) && OperationalAttributes.PASSWORD_NAME.equals(missing.getValue().get(0)) && this.cipherAlgorithmMatches(cipherAlgorithm, user.getCipherAlgorithm())).ifPresent(missing -> {
                attrs.remove(missing);
                byte[] decodedPassword = DatatypeConverter.parseHexBinary((String)user.getPassword().toLowerCase());
                String base64EncodedPassword = Base64.getEncoder().encodeToString(decodedPassword);
                String cipherPlusPassword = "{" + cipherAlgorithm + "}" + base64EncodedPassword;
                attrs.add(AttributeBuilder.buildPassword((GuardedString)new GuardedString(cipherPlusPassword.toCharArray())));
            });
        }
    }

    protected String getCipherAlgorithm(ConnInstance connInstance) {
        return connInstance.getConf().stream().filter(property -> "passwordHashAlgorithm".equals(property.getSchema().getName()) && !property.getValues().isEmpty()).findFirst().map(cipherAlgorithm -> cipherAlgorithm.getValues().get(0).toString()).orElse(CLEARTEXT);
    }

    protected boolean cipherAlgorithmMatches(String connectorAlgo, CipherAlgorithm userAlgo) {
        if (userAlgo == null) {
            return false;
        }
        if (connectorAlgo.equals(userAlgo.name())) {
            return true;
        }
        return "SHA".equals(connectorAlgo) && userAlgo.name().startsWith("SHA") || "SSHA".equals(connectorAlgo) && userAlgo.name().startsWith("SSHA");
    }
}

