/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.github;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.Token;
import java.util.Arrays;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.converter.JsonConverter;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.oauth.profile.github.GitHubPlan;
import org.pac4j.oauth.profile.github.GitHubProfile;

public class GitHubProfileDefinition
extends OAuthProfileDefinition {
    public static final String TYPE = "type";
    public static final String BLOG = "blog";
    public static final String URL = "url";
    public static final String PUBLIC_GISTS = "public_gists";
    public static final String FOLLOWING = "following";
    public static final String PRIVATE_GISTS = "private_gists";
    public static final String PUBLIC_REPOS = "public_repos";
    public static final String GRAVATAR_ID = "gravatar_id";
    public static final String AVATAR_URL = "avatar_url";
    public static final String FOLLOWERS = "followers";
    public static final String LOGIN = "login";
    public static final String COMPANY = "company";
    public static final String HIREABLE = "hireable";
    public static final String COLLABORATORS = "collaborators";
    public static final String HTML_URL = "html_url";
    public static final String BIO = "bio";
    public static final String TOTAL_PRIVATE_REPOS = "total_private_repos";
    public static final String CREATED_AT = "created_at";
    public static final String UPDATED_AT = "updated_at";
    public static final String NAME = "name";
    public static final String DISK_USAGE = "disk_usage";
    public static final String PLAN = "plan";
    public static final String OWNED_PRIVATE_REPOS = "owned_private_repos";

    public GitHubProfileDefinition() {
        super(x -> new GitHubProfile());
        Arrays.asList(URL, COMPANY, NAME, BLOG, LOGIN, "location", TYPE, GRAVATAR_ID, BIO).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        Arrays.asList(FOLLOWING, PUBLIC_REPOS, PUBLIC_GISTS, DISK_USAGE, COLLABORATORS, OWNED_PRIVATE_REPOS, TOTAL_PRIVATE_REPOS, PRIVATE_GISTS, FOLLOWERS).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.INTEGER));
        this.primary(HIREABLE, (AttributeConverter)Converters.BOOLEAN);
        this.primary(CREATED_AT, (AttributeConverter)Converters.DATE_TZ_RFC822);
        this.primary(UPDATED_AT, (AttributeConverter)Converters.DATE_TZ_RFC822);
        this.primary(AVATAR_URL, (AttributeConverter)Converters.URL);
        this.primary(HTML_URL, (AttributeConverter)Converters.URL);
        this.primary(PLAN, new JsonConverter(GitHubPlan.class));
    }

    @Override
    public String getProfileUrl(Token accessToken, OAuthConfiguration configuration) {
        return "https://api.github.com/user";
    }

    @Override
    public GitHubProfile extractUserProfile(String body) {
        GitHubProfile profile = (GitHubProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((Object)JsonHelper.getElement(json, "id")));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }
}

