/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.report;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.provisioning.api.job.JobDelegate;
import org.apache.syncope.core.provisioning.api.job.report.ReportJobDelegate;
import org.apache.syncope.core.provisioning.java.job.AbstractInterruptableJob;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ReportJob
extends AbstractInterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(ReportJob.class);
    private final Map<String, ReportJobDelegate> perContextReportJobDelegates = new ConcurrentHashMap<String, ReportJobDelegate>();
    @Autowired
    private DomainHolder domainHolder;
    private ReportJobDelegate delegate;

    @Override
    public JobDelegate getDelegate() {
        return this.delegate;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String reportKey = context.getMergedJobDataMap().getString("reportKey");
        try {
            String domain = context.getMergedJobDataMap().getString("domain");
            if (this.domainHolder.getDomains().containsKey(domain)) {
                AuthContextUtils.callAsAdmin((String)domain, () -> {
                    try {
                        ImplementationDAO implementationDAO = (ImplementationDAO)ApplicationContextProvider.getApplicationContext().getBean(ImplementationDAO.class);
                        Implementation impl = implementationDAO.find(context.getMergedJobDataMap().getString("delegateImpl"));
                        if (impl == null) {
                            LOG.error("Could not find Implementation '{}', aborting", (Object)context.getMergedJobDataMap().getString("delegateImpl"));
                        } else {
                            this.delegate = (ReportJobDelegate)ImplementationManager.buildReportJobDelegate((Implementation)impl, () -> this.perContextReportJobDelegates.get(impl.getKey()), instance -> this.perContextReportJobDelegates.put(impl.getKey(), (ReportJobDelegate)instance)).orElseThrow(() -> new IllegalArgumentException("Could not instantiate " + impl.getBody()));
                            this.delegate.execute(reportKey, context.getMergedJobDataMap().getBoolean("dryRun"), context);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("While executing report {}", (Object)reportKey, (Object)e);
                        throw new RuntimeException(e);
                    }
                    return null;
                });
            } else {
                LOG.debug("Domain {} not found, skipping", (Object)domain);
            }
        }
        catch (RuntimeException e) {
            LOG.error("While executing report {}", (Object)reportKey, (Object)e);
            throw new JobExecutionException("While executing report " + reportKey, (Throwable)e);
        }
    }

    public static enum Status {
        SUCCESS,
        FAILURE;

    }
}

