/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import java.io.Serializable;
import lombok.Generated;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.util.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcJsonWebKeyCacheKey
implements Serializable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcJsonWebKeyCacheKey.class);
    private static final long serialVersionUID = -1238573226470492601L;
    private final String key;
    private final String issuer;
    private final OidcJsonWebKeyUsage usage;
    private OAuthRegisteredService registeredService;

    public OidcJsonWebKeyCacheKey(String issuer, OidcJsonWebKeyUsage usage) {
        this.issuer = issuer;
        this.usage = usage;
        this.key = DigestUtils.sha512((String)(this.issuer + "|" + this.usage.getValue()));
        LOGGER.trace("Hashed JSON web key cache key for [{}]:[{}] as [{}]", new Object[]{this.issuer, this.usage, this.key});
        LOGGER.trace("Calculated JSON web key cache key [{}]", (Object)this.key);
    }

    public OidcJsonWebKeyCacheKey(OAuthRegisteredService service, OidcJsonWebKeyUsage usage) {
        this(service.getServiceId() + "|" + service.getClientId(), usage);
        this.registeredService = service;
    }

    @Generated
    public String toString() {
        return "OidcJsonWebKeyCacheKey(key=" + this.key + ", issuer=" + this.issuer + ", usage=" + this.usage + ", registeredService=" + this.registeredService + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OidcJsonWebKeyCacheKey)) {
            return false;
        }
        OidcJsonWebKeyCacheKey other = (OidcJsonWebKeyCacheKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OidcJsonWebKeyCacheKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public OidcJsonWebKeyUsage getUsage() {
        return this.usage;
    }

    @Generated
    public OAuthRegisteredService getRegisteredService() {
        return this.registeredService;
    }
}

