/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.rabbit;

import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.InboundEvent;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.flowable.eventregistry.spring.rabbit.RabbitInboundEvent;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;

public class RabbitChannelMessageListenerAdapter
implements MessageListener {
    protected EventRegistry eventRegistry;
    protected InboundChannelModel inboundChannelModel;

    public RabbitChannelMessageListenerAdapter(EventRegistry eventRegistry, InboundChannelModel inboundChannelModel) {
        this.eventRegistry = eventRegistry;
        this.inboundChannelModel = inboundChannelModel;
    }

    public void onMessage(Message message) {
        this.eventRegistry.eventReceived(this.inboundChannelModel, (InboundEvent)new RabbitInboundEvent(message));
    }

    public EventRegistry getEventRegistry() {
        return this.eventRegistry;
    }

    public void setEventRegistry(EventRegistry eventRegistry) {
        this.eventRegistry = eventRegistry;
    }

    public InboundChannelModel getInboundChannelModel() {
        return this.inboundChannelModel;
    }

    public void setInboundChannelModel(InboundChannelModel inboundChannelModel) {
        this.inboundChannelModel = inboundChannelModel;
    }
}

