/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.pop3.commands;

import com.icegreen.greenmail.pop3.Pop3Connection;
import com.icegreen.greenmail.pop3.Pop3State;
import com.icegreen.greenmail.pop3.commands.Pop3Command;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.util.EncodingUtil;
import com.icegreen.greenmail.util.SaslMessage;
import java.io.IOException;
import java.util.Arrays;

public class AuthCommand
extends Pop3Command {
    public static final String CONTINUATION = "+ ";

    @Override
    public boolean isValidForState(Pop3State state) {
        return !state.isAuthenticated();
    }

    @Override
    public void execute(Pop3Connection conn, Pop3State state, String cmd) {
        if (state.isAuthenticated()) {
            conn.println("-ERR Already authenticated");
            return;
        }
        String[] args = cmd.split(" ");
        if (args.length < 2) {
            conn.println("-ERR Required syntax: AUTH mechanism [initial-response]");
            return;
        }
        String mechanism = args[1];
        if (Pop3SaslAuthMechanism.PLAIN.name().equalsIgnoreCase(mechanism)) {
            this.authPlain(conn, state, args);
        } else {
            conn.println("-ERR Required syntax: AUTH mechanism <" + mechanism + "> not supported, expected one of " + Arrays.toString((Object[])Pop3SaslAuthMechanism.values()));
        }
    }

    private void authPlain(Pop3Connection conn, Pop3State state, String[] args) {
        GreenMailUser user;
        SaslMessage saslMessage;
        String initialResponse;
        if (args.length == 2 || args.length == 3 && "=".equals(args[2])) {
            conn.println(CONTINUATION);
            try {
                initialResponse = conn.readLine();
            }
            catch (IOException e) {
                conn.println("-ERR Invalid syntax, expected continuation with iniital-response");
                return;
            }
        } else if (args.length == 3) {
            initialResponse = args[2];
        } else {
            conn.println("-ERR Invalid syntax, expected initial-response : AUTH PLAIN [initial-response]");
            return;
        }
        try {
            saslMessage = SaslMessage.parse(EncodingUtil.decodeBase64(initialResponse));
        }
        catch (IllegalArgumentException ex) {
            this.log.error("Expected base64 encoding but got <" + initialResponse + ">", (Throwable)ex);
            conn.println("-ERR Authentication failed, expected base64 encoding : " + ex.getMessage());
            return;
        }
        try {
            user = state.getUser(saslMessage.getAuthcid());
            state.setUser(user);
        }
        catch (UserException e) {
            this.log.error("Can not get user <" + saslMessage.getAuthcid() + ">", (Throwable)e);
            conn.println("-ERR Authentication failed: " + e.getMessage());
            return;
        }
        try {
            state.authenticate(saslMessage.getPasswd());
            conn.println("+OK");
        }
        catch (UserException e) {
            this.log.error("Can not authenticate using user <" + user.getLogin() + ">", (Throwable)e);
            conn.println("-ERR Authentication failed: " + e.getMessage());
        }
        catch (FolderException e) {
            this.log.error("Can not authenticate using user " + user + ", internal error", (Throwable)e);
            conn.println("-ERR Authentication failed, internal error: " + e.getMessage());
        }
    }

    public static enum Pop3SaslAuthMechanism {
        PLAIN;


        static String list() {
            StringBuilder buf = new StringBuilder();
            for (Pop3SaslAuthMechanism mechanism : Pop3SaslAuthMechanism.values()) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(mechanism.name());
            }
            return buf.toString();
        }
    }
}

