/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.surrogate;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apereo.cas.authentication.surrogate.SimpleSurrogateAuthenticationService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.io.FileWatcherService;
import org.apereo.cas.util.io.WatcherService;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;

public class JsonResourceSurrogateAuthenticationService
extends SimpleSurrogateAuthenticationService
implements DisposableBean {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final WatcherService watcherService;

    public JsonResourceSurrogateAuthenticationService(File json, ServicesManager servicesManager) throws Exception {
        super(JsonResourceSurrogateAuthenticationService.readAccountsFromFile(json), servicesManager);
        this.watcherService = new FileWatcherService(json, this::loadServices);
        this.watcherService.start(this.getClass().getSimpleName());
    }

    public JsonResourceSurrogateAuthenticationService(Resource json, ServicesManager servicesManager) throws Exception {
        this(json.getFile(), servicesManager);
    }

    private static Map readAccountsFromFile(File json) throws IOException {
        return (Map)MAPPER.readValue(json, Map.class);
    }

    private void loadServices(File file) {
        FunctionUtils.doAndHandle(unused -> {
            this.getEligibleAccounts().clear();
            this.getEligibleAccounts().putAll(JsonResourceSurrogateAuthenticationService.readAccountsFromFile(file));
        });
    }

    public void destroy() {
        if (this.watcherService != null) {
            this.watcherService.close();
        }
    }
}

