/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.springdoc.api.ErrorMessage;
import org.springdoc.api.OpenApiResourceNotFoundException;
import org.springdoc.core.CacheOrGroupedOpenApiCondition;
import org.springdoc.core.GenericParameterService;
import org.springdoc.core.GroupedOpenApi;
import org.springdoc.core.MultipleOpenApiSupportCondition;
import org.springdoc.core.OpenAPIService;
import org.springdoc.core.OperationService;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.RequestBodyService;
import org.springdoc.core.ReturnTypeParser;
import org.springdoc.core.SecurityService;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SpringDocProviders;
import org.springdoc.core.SpringDocUtils;
import org.springdoc.core.SpringdocActuatorBeanFactoryConfigurer;
import org.springdoc.core.SpringdocBeanFactoryConfigurer;
import org.springdoc.core.converters.AdditionalModelsConverter;
import org.springdoc.core.converters.FileSupportConverter;
import org.springdoc.core.converters.ModelConverterRegistrar;
import org.springdoc.core.converters.PageableOpenAPIConverter;
import org.springdoc.core.converters.PolymorphicModelConverter;
import org.springdoc.core.converters.PropertyCustomizingConverter;
import org.springdoc.core.converters.ResponseSupportConverter;
import org.springdoc.core.converters.SchemaPropertyDeprecatingConverter;
import org.springdoc.core.converters.SortOpenAPIConverter;
import org.springdoc.core.converters.models.Pageable;
import org.springdoc.core.converters.models.Sort;
import org.springdoc.core.customizers.ActuatorOpenApiCustomizer;
import org.springdoc.core.customizers.ActuatorOperationCustomizer;
import org.springdoc.core.customizers.DataRestDelegatingMethodParameterCustomizer;
import org.springdoc.core.customizers.DelegatingMethodParameterCustomizer;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springdoc.core.customizers.GlobalOperationCustomizer;
import org.springdoc.core.customizers.OpenApiBuilderCustomizer;
import org.springdoc.core.customizers.PropertyCustomizer;
import org.springdoc.core.customizers.ServerBaseUrlCustomizer;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.core.providers.CloudFunctionProvider;
import org.springdoc.core.providers.JavadocProvider;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springdoc.core.providers.RepositoryRestConfigurationProvider;
import org.springdoc.core.providers.RepositoryRestResourceProvider;
import org.springdoc.core.providers.RouterFunctionProvider;
import org.springdoc.core.providers.SecurityOAuth2Provider;
import org.springdoc.core.providers.SpringCloudFunctionProvider;
import org.springdoc.core.providers.SpringDataWebPropertiesProvider;
import org.springdoc.core.providers.SpringWebProvider;
import org.springdoc.core.providers.WebConversionServiceProvider;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.data.web.SpringDataWebProperties;
import org.springframework.boot.autoconfigure.web.format.WebConversionService;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.web.function.FunctionEndpointInitializer;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.async.DeferredResult;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication
public class SpringDocConfiguration {
    private static final String BINDRESULT_CLASS = "org.springframework.boot.context.properties.bind.BindResult";

    @Bean
    @Lazy(value=false)
    LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer() {
        return new LocalVariableTableParameterNameDiscoverer();
    }

    @Bean
    @Lazy(value=false)
    AdditionalModelsConverter additionalModelsConverter(ObjectMapperProvider objectMapperProvider) {
        return new AdditionalModelsConverter(objectMapperProvider);
    }

    @Bean
    @Lazy(value=false)
    @ConditionalOnBean(value={PropertyCustomizer.class})
    PropertyCustomizingConverter propertyCustomizingConverter(Optional<List<PropertyCustomizer>> customizers) {
        return new PropertyCustomizingConverter(customizers);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    FileSupportConverter fileSupportConverter(ObjectMapperProvider objectMapperProvider) {
        return new FileSupportConverter(objectMapperProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    ResponseSupportConverter responseSupportConverter(ObjectMapperProvider objectMapperProvider) {
        return new ResponseSupportConverter(objectMapperProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"springdoc.model-converters.deprecating-converter.enabled"}, matchIfMissing=true)
    @Lazy(value=false)
    SchemaPropertyDeprecatingConverter schemaPropertyDeprecatingConverter() {
        return new SchemaPropertyDeprecatingConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"springdoc.model-converters.polymorphic-converter.enabled"}, matchIfMissing=true)
    @Lazy(value=false)
    PolymorphicModelConverter polymorphicModelConverter(ObjectMapperProvider objectMapperProvider) {
        return new PolymorphicModelConverter(objectMapperProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    OpenAPIService openAPIBuilder(Optional<OpenAPI> openAPI, SecurityService securityParser, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils, Optional<List<OpenApiBuilderCustomizer>> openApiBuilderCustomisers, Optional<List<ServerBaseUrlCustomizer>> serverBaseUrlCustomisers, Optional<JavadocProvider> javadocProvider) {
        return new OpenAPIService(openAPI, securityParser, springDocConfigProperties, propertyResolverUtils, openApiBuilderCustomisers, serverBaseUrlCustomisers, javadocProvider);
    }

    @Bean
    @Lazy(value=false)
    ModelConverterRegistrar modelConverterRegistrar(Optional<List<ModelConverter>> modelConverters) {
        return new ModelConverterRegistrar(modelConverters.orElse(Collections.emptyList()));
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    OperationService operationBuilder(GenericParameterService parameterBuilder, RequestBodyService requestBodyService, SecurityService securityParser, PropertyResolverUtils propertyResolverUtils, Optional<JavadocProvider> javadocProvider) {
        return new OperationService(parameterBuilder, requestBodyService, securityParser, propertyResolverUtils, javadocProvider);
    }

    @Bean
    @Lazy(value=false)
    PropertyResolverUtils propertyResolverUtils(ConfigurableBeanFactory factory, MessageSource messageSource, SpringDocConfigProperties springDocConfigProperties) {
        return new PropertyResolverUtils(factory, messageSource, springDocConfigProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    RequestBodyService requestBodyBuilder(GenericParameterService parameterBuilder) {
        return new RequestBodyService(parameterBuilder);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    SecurityService securityParser(PropertyResolverUtils propertyResolverUtils) {
        return new SecurityService(propertyResolverUtils);
    }

    @Bean
    @Lazy(value=false)
    ReturnTypeParser genericReturnTypeParser() {
        return new ReturnTypeParser(){};
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    GenericParameterService parameterBuilder(PropertyResolverUtils propertyResolverUtils, Optional<DelegatingMethodParameterCustomizer> optionalDelegatingMethodParameterCustomizer, Optional<WebConversionServiceProvider> optionalWebConversionServiceProvider, ObjectMapperProvider objectMapperProvider) {
        return new GenericParameterService(propertyResolverUtils, optionalDelegatingMethodParameterCustomizer, optionalWebConversionServiceProvider, objectMapperProvider);
    }

    @Bean
    @ConditionalOnProperty(value={"springdoc.api-docs.resolve-schema-properties"})
    @Lazy(value=false)
    GlobalOpenApiCustomizer propertiesResolverForSchema(PropertyResolverUtils propertyResolverUtils) {
        return openApi -> {
            Components components = openApi.getComponents();
            Map schemas = components.getSchemas();
            if (!CollectionUtils.isEmpty((Map)schemas)) {
                schemas.values().forEach(schema -> propertyResolverUtils.resolveProperties((Schema<?>)schema, Locale.getDefault()));
            }
        };
    }

    @Bean
    @Conditional(value={CacheOrGroupedOpenApiCondition.class})
    @ConditionalOnClass(name={"org.springframework.boot.context.properties.bind.BindResult"})
    @Lazy(value=false)
    static BeanFactoryPostProcessor springdocBeanFactoryPostProcessor() {
        return new SpringdocBeanFactoryConfigurer();
    }

    @Bean
    @Conditional(value={CacheOrGroupedOpenApiCondition.class})
    @ConditionalOnMissingClass(value={"org.springframework.boot.context.properties.bind.BindResult"})
    @Lazy(value=false)
    static BeanFactoryPostProcessor springdocBeanFactoryPostProcessor2() {
        return SpringdocBeanFactoryConfigurer::initBeanFactoryPostProcessor;
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    SpringDocProviders springDocProviders(Optional<ActuatorProvider> actuatorProvider, Optional<CloudFunctionProvider> springCloudFunctionProvider, Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider, Optional<RepositoryRestResourceProvider> repositoryRestResourceProvider, Optional<RouterFunctionProvider> routerFunctionProvider, Optional<SpringWebProvider> springWebProvider, Optional<WebConversionServiceProvider> webConversionServiceProvider, ObjectMapperProvider objectMapperProvider) {
        return new SpringDocProviders(actuatorProvider, springCloudFunctionProvider, springSecurityOAuth2Provider, repositoryRestResourceProvider, routerFunctionProvider, springWebProvider, webConversionServiceProvider, objectMapperProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    ObjectMapperProvider springDocObjectMapperProvider(SpringDocConfigProperties springDocConfigProperties) {
        return new ObjectMapperProvider(springDocConfigProperties);
    }

    static {
        SpringDocUtils.getConfig().replaceWithSchema(ObjectNode.class, (Schema)new ObjectSchema()).replaceWithClass(Charset.class, String.class).addResponseWrapperToIgnore(DeferredResult.class);
    }

    @ConditionalOnClass(value={org.springframework.data.domain.Sort.class})
    static class SpringDocSortConfiguration {
        SpringDocSortConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(name={"springdoc.model-converters.sort-converter.enabled"}, matchIfMissing=true)
        @Lazy(value=false)
        SortOpenAPIConverter sortOpenAPIConverter(ObjectMapperProvider objectMapperProvider) {
            SpringDocUtils.getConfig().replaceParameterObjectWithClass(org.springframework.data.domain.Sort.class, Sort.class);
            return new SortOpenAPIConverter(objectMapperProvider);
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        DelegatingMethodParameterCustomizer delegatingMethodParameterCustomizer(Optional<SpringDataWebPropertiesProvider> optionalSpringDataWebPropertiesProvider, Optional<RepositoryRestConfigurationProvider> optionalRepositoryRestConfiguration) {
            return new DataRestDelegatingMethodParameterCustomizer(optionalSpringDataWebPropertiesProvider, optionalRepositoryRestConfiguration);
        }
    }

    @ConditionalOnClass(value={FunctionEndpointInitializer.class})
    @ConditionalOnProperty(name={"springdoc.show-spring-cloud-functions"}, matchIfMissing=true)
    static class SpringDocFunctionCatalogConfiguration {
        SpringDocFunctionCatalogConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        CloudFunctionProvider springCloudFunctionProvider(Optional<FunctionCatalog> functionCatalog, SpringDocConfigProperties springDocConfigProperties) {
            return new SpringCloudFunctionProvider(functionCatalog, springDocConfigProperties);
        }
    }

    @ConditionalOnClass(value={RepositoryRestConfiguration.class})
    static class SpringDocRepositoryRestConfiguration {
        SpringDocRepositoryRestConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        RepositoryRestConfigurationProvider repositoryRestConfigurationProvider(Optional<RepositoryRestConfiguration> optionalRepositoryRestConfiguration) {
            return new RepositoryRestConfigurationProvider(optionalRepositoryRestConfiguration);
        }
    }

    @ConditionalOnClass(value={SpringDataWebProperties.class})
    static class SpringDocSpringDataWebPropertiesProvider {
        SpringDocSpringDataWebPropertiesProvider() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        SpringDataWebPropertiesProvider springDataWebPropertiesProvider(Optional<SpringDataWebProperties> optionalSpringDataWebProperties) {
            return new SpringDataWebPropertiesProvider(optionalSpringDataWebProperties);
        }
    }

    @ConditionalOnClass(value={org.springframework.data.domain.Pageable.class})
    static class SpringDocPageableConfiguration {
        SpringDocPageableConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(name={"springdoc.model-converters.pageable-converter.enabled"}, matchIfMissing=true)
        @Lazy(value=false)
        PageableOpenAPIConverter pageableOpenAPIConverter(ObjectMapperProvider objectMapperProvider) {
            SpringDocUtils.getConfig().replaceParameterObjectWithClass(org.springframework.data.domain.Pageable.class, Pageable.class).replaceParameterObjectWithClass(PageRequest.class, Pageable.class);
            return new PageableOpenAPIConverter(objectMapperProvider);
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        DelegatingMethodParameterCustomizer delegatingMethodParameterCustomizer(Optional<SpringDataWebPropertiesProvider> optionalSpringDataWebPropertiesProvider, Optional<RepositoryRestConfigurationProvider> optionalRepositoryRestConfiguration) {
            return new DataRestDelegatingMethodParameterCustomizer(optionalSpringDataWebPropertiesProvider, optionalRepositoryRestConfiguration);
        }
    }

    @ConditionalOnClass(value={WebConversionService.class})
    static class WebConversionServiceConfiguration {
        WebConversionServiceConfiguration() {
        }

        @Bean
        @Lazy(value=false)
        WebConversionServiceProvider webConversionServiceProvider(Optional<List<GenericConversionService>> genericConversionServiceList) {
            return new WebConversionServiceProvider(genericConversionServiceList);
        }
    }

    @ConditionalOnClass(value={WebEndpointProperties.class})
    @ConditionalOnProperty(value={"springdoc.show-actuator"})
    static class SpringDocActuatorConfiguration {
        SpringDocActuatorConfiguration() {
        }

        @Bean
        @Lazy(value=false)
        @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
        @Conditional(value={MultipleOpenApiSupportCondition.class})
        static BeanFactoryPostProcessor springdocBeanFactoryPostProcessor3(List<GroupedOpenApi> groupedOpenApis) {
            return new SpringdocActuatorBeanFactoryConfigurer(groupedOpenApis);
        }

        @Bean
        @Lazy(value=false)
        @ConditionalOnManagementPort(value=ManagementPortType.SAME)
        GlobalOperationCustomizer actuatorCustomizer() {
            return new ActuatorOperationCustomizer();
        }

        @Bean
        @Lazy(value=false)
        @ConditionalOnManagementPort(value=ManagementPortType.SAME)
        GlobalOpenApiCustomizer actuatorOpenApiCustomiser(WebEndpointProperties webEndpointProperties) {
            return new ActuatorOpenApiCustomizer(webEndpointProperties);
        }
    }

    @RestControllerAdvice
    @Hidden
    class OpenApiResourceAdvice {
        OpenApiResourceAdvice() {
        }

        @ExceptionHandler(value={OpenApiResourceNotFoundException.class})
        @ResponseStatus(value=HttpStatus.NOT_FOUND)
        public ResponseEntity<ErrorMessage> handleNoHandlerFound(OpenApiResourceNotFoundException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)new ErrorMessage(e.getMessage()));
        }
    }
}

