/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.chartjs.Chart;
import org.apache.syncope.client.console.chartjs.ChartJSPanel;
import org.apache.syncope.client.console.chartjs.Doughnut;
import org.apache.syncope.client.console.chartjs.DoughnutAndPieChartData;
import org.apache.syncope.client.console.pages.Notifications;
import org.apache.syncope.client.console.pages.Policies;
import org.apache.syncope.client.console.pages.Security;
import org.apache.syncope.client.console.pages.Types;
import org.apache.syncope.client.console.widgets.BaseWidget;
import org.apache.syncope.common.lib.info.NumbersInfo;
import org.apache.wicket.Component;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class CompletenessWidget
extends BaseWidget {
    private static final long serialVersionUID = 7667120094526529934L;
    private Map<String, Boolean> confCompleteness;
    private final ChartJSPanel chart;
    private final WebMarkupContainer actions;
    private final BookmarkablePageLink<Policies> policies;
    private final BookmarkablePageLink<Notifications> notifications;
    private final BookmarkablePageLink<Types> types;
    private final BookmarkablePageLink<Security> securityquestions;
    private final BookmarkablePageLink<Security> roles;

    public CompletenessWidget(String id, Map<String, Boolean> confCompleteness) {
        super(id);
        this.confCompleteness = confCompleteness;
        this.setOutputMarkupId(true);
        Pair<Doughnut, Integer> built = this.build(confCompleteness);
        this.chart = new ChartJSPanel("chart", (IModel<? extends Chart<?>>)Model.of((Serializable)((Doughnut)built.getLeft())));
        this.add(new Component[]{this.chart});
        this.actions = new WebMarkupContainer("actions");
        this.actions.setOutputMarkupPlaceholderTag(true);
        this.actions.setVisible((Integer)built.getRight() > 0);
        this.add(new Component[]{this.actions});
        this.policies = BookmarkablePageLinkBuilder.build("policies", Policies.class);
        this.policies.setOutputMarkupPlaceholderTag(true);
        MetaDataRoleAuthorizationStrategy.authorize(this.policies, (Action)WebPage.ENABLE, (String)"POLICY_LIST");
        this.actions.add(new Component[]{this.policies});
        this.policies.setVisible(confCompleteness.get(NumbersInfo.ConfItem.ACCOUNT_POLICY.name()) == false || confCompleteness.get(NumbersInfo.ConfItem.PASSWORD_POLICY.name()) == false);
        this.notifications = BookmarkablePageLinkBuilder.build("notifications", Notifications.class);
        this.notifications.setOutputMarkupPlaceholderTag(true);
        MetaDataRoleAuthorizationStrategy.authorize(this.notifications, (Action)WebPage.ENABLE, (String)"NOTIFICATION_LIST");
        this.actions.add(new Component[]{this.notifications});
        this.notifications.setVisible(confCompleteness.get(NumbersInfo.ConfItem.NOTIFICATION.name()) == false);
        this.types = BookmarkablePageLinkBuilder.build("types", Types.class);
        this.types.setOutputMarkupPlaceholderTag(true);
        MetaDataRoleAuthorizationStrategy.authorize(this.types, (Action)WebPage.ENABLE, (String)"ANYTYPECLASS_LIST");
        this.actions.add(new Component[]{this.types});
        this.types.setVisible(confCompleteness.get(NumbersInfo.ConfItem.VIR_SCHEMA.name()) == false || confCompleteness.get(NumbersInfo.ConfItem.ANY_TYPE.name()) == false);
        this.securityquestions = BookmarkablePageLinkBuilder.build("securityquestions", Security.class);
        this.securityquestions.setOutputMarkupPlaceholderTag(true);
        this.actions.add(new Component[]{this.securityquestions});
        this.securityquestions.setVisible(confCompleteness.get(NumbersInfo.ConfItem.SECURITY_QUESTION.name()) == false);
        this.roles = BookmarkablePageLinkBuilder.build("roles", Security.class);
        this.roles.setOutputMarkupPlaceholderTag(true);
        MetaDataRoleAuthorizationStrategy.authorize(this.roles, (Action)WebPage.ENABLE, (String)"ROLE_LIST");
        this.actions.add(new Component[]{this.roles});
        this.roles.setVisible(confCompleteness.get(NumbersInfo.ConfItem.ROLE.name()) == false);
    }

    private Pair<Doughnut, Integer> build(Map<String, Boolean> confCompleteness) {
        Doughnut doughnut = new Doughnut();
        doughnut.getOptions().setResponsive(true);
        doughnut.getOptions().setMaintainAspectRatio(true);
        doughnut.getOptions().setTooltipTemplate("<%= label %>");
        int done = 0;
        int todo = 0;
        for (Map.Entry<String, Boolean> entry : confCompleteness.entrySet()) {
            if (BooleanUtils.isTrue((Boolean)entry.getValue())) {
                done += NumbersInfo.ConfItem.getScore((String)entry.getKey());
                continue;
            }
            ++todo;
        }
        DoughnutAndPieChartData data = new DoughnutAndPieChartData();
        doughnut.setData(data);
        DoughnutAndPieChartData.DataSet dataset = new DoughnutAndPieChartData.DataSet();
        data.getDatasets().add(dataset);
        dataset.getData().add(done);
        dataset.getData().add(100 - done);
        dataset.getBackgroundColor().add("green");
        dataset.getBackgroundColor().add("red");
        data.getLabels().add(this.getString("done"));
        data.getLabels().add(this.getString("todo") + ": " + todo);
        return Pair.of((Object)doughnut, (Object)todo);
    }

    public boolean refresh(Map<String, Boolean> confCompleteness) {
        if (!this.confCompleteness.equals(confCompleteness)) {
            this.confCompleteness = confCompleteness;
            Pair<Doughnut, Integer> built = this.build(confCompleteness);
            this.chart.setDefaultModelObject(built.getLeft());
            this.actions.setVisible((Integer)built.getRight() > 0);
            this.policies.setVisible(confCompleteness.get(NumbersInfo.ConfItem.ACCOUNT_POLICY.name()) == false || confCompleteness.get(NumbersInfo.ConfItem.PASSWORD_POLICY.name()) == false);
            this.notifications.setVisible(confCompleteness.get(NumbersInfo.ConfItem.NOTIFICATION.name()) == false);
            this.types.setVisible(confCompleteness.get(NumbersInfo.ConfItem.VIR_SCHEMA.name()) == false || confCompleteness.get(NumbersInfo.ConfItem.ANY_TYPE.name()) == false);
            this.securityquestions.setVisible(confCompleteness.get(NumbersInfo.ConfItem.SECURITY_QUESTION.name()) == false);
            this.roles.setVisible(confCompleteness.get(NumbersInfo.ConfItem.ROLE.name()) == false);
            return true;
        }
        return false;
    }
}

