/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Base64;
import org.identityconnectors.common.security.EncryptorFactory;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

class GuardedStringSerializer
extends JsonSerializer<GuardedString> {
    private static final Logger LOG = LoggerFactory.getLogger(GuardedStringSerializer.class);
    private static final String READONLY = "readOnly";
    private static final String DISPOSED = "disposed";
    private static final String ENCRYPTED_BYTES = "encryptedBytes";
    private static final String BASE64_SHA1_HASH = "base64SHA1Hash";
    private static final String LOG_ERROR_MESSAGE = "Could not get field value";

    GuardedStringSerializer() {
    }

    public void serialize(GuardedString source, JsonGenerator jgen, SerializerProvider sp) throws IOException {
        jgen.writeStartObject();
        boolean readOnly = false;
        try {
            Field field = GuardedString.class.getDeclaredField(READONLY);
            ReflectionUtils.makeAccessible((Field)field);
            readOnly = field.getBoolean(source);
        }
        catch (Exception e) {
            LOG.error(LOG_ERROR_MESSAGE, (Throwable)e);
        }
        jgen.writeBooleanField(READONLY, readOnly);
        boolean disposed = false;
        try {
            Field field = GuardedString.class.getDeclaredField(DISPOSED);
            ReflectionUtils.makeAccessible((Field)field);
            disposed = field.getBoolean(source);
        }
        catch (Exception e) {
            LOG.error(LOG_ERROR_MESSAGE, (Throwable)e);
        }
        jgen.writeBooleanField(DISPOSED, disposed);
        byte[] encryptedBytes = EncryptorFactory.getInstance().getDefaultEncryptor().encrypt(SecurityUtil.decrypt((GuardedString)source).getBytes());
        jgen.writeStringField(ENCRYPTED_BYTES, Base64.getEncoder().encodeToString(encryptedBytes));
        String base64SHA1Hash = null;
        try {
            Field field = GuardedString.class.getDeclaredField(BASE64_SHA1_HASH);
            ReflectionUtils.makeAccessible((Field)field);
            base64SHA1Hash = field.get(source).toString();
        }
        catch (Exception e) {
            LOG.error(LOG_ERROR_MESSAGE, (Throwable)e);
        }
        if (base64SHA1Hash != null) {
            jgen.writeStringField(BASE64_SHA1_HASH, base64SHA1Hash);
        }
        jgen.writeEndObject();
    }
}

