/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy11.builders;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.model.RequiredElements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredElementsBuilder
implements AssertionBuilder<OMElement> {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        RequiredElements requiredElements = new RequiredElements(1);
        OMAttribute attrXPathVersion = element.getAttribute(SP11Constants.ATTR_XPATH_VERSION);
        if (attrXPathVersion != null) {
            requiredElements.setXPathVersion(attrXPathVersion.getAttributeValue());
        }
        Iterator iterator = element.getChildElements();
        while (iterator.hasNext()) {
            this.processElement((OMElement)iterator.next(), requiredElements);
        }
        return requiredElements;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.REQUIRED_ELEMENTS};
    }

    private void processElement(OMElement element, RequiredElements parent) {
        QName name = element.getQName();
        if (SP11Constants.XPATH.equals(name)) {
            parent.addXPathExpression(element.getText());
            Iterator namespaces = element.getNamespacesInScope();
            while (namespaces.hasNext()) {
                OMNamespace nm = (OMNamespace)namespaces.next();
                parent.addDeclaredNamespaces(nm.getNamespaceURI(), nm.getPrefix());
            }
        }
    }
}

