/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.security.Key;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSDerivedKeyTokenPrincipal;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.AlgorithmSuite;
import org.apache.ws.security.components.crypto.AlgorithmSuiteValidator;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.ReferenceListProcessor;
import org.apache.ws.security.processor.X509Util;
import org.apache.ws.security.str.SecurityTokenRefSTRParser;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedDataProcessor
implements Processor {
    private static Log log = LogFactory.getLog(EncryptedDataProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData request, WSDocInfo wsDocInfo) throws WSSecurityException {
        Element kiElem;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found EncryptedData element");
        }
        if ((kiElem = WSSecurityUtil.getDirectChildElement(elem, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#")) == null) {
            throw new WSSecurityException(2, "noKeyinfo");
        }
        String symEncAlgo = X509Util.getEncAlgo(elem);
        if (request.getWssConfig().isWsiBSPCompliant()) {
            EncryptedDataProcessor.checkBSPCompliance(symEncAlgo);
        }
        Element secRefToken = WSSecurityUtil.getDirectChildElement(kiElem, "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        Element encryptedKeyElement = WSSecurityUtil.getDirectChildElement(kiElem, "EncryptedKey", "http://www.w3.org/2001/04/xmlenc#");
        if (elem != null && request.isRequireSignedEncryptedDataElements()) {
            WSSecurityUtil.verifySignedElement(elem, elem.getOwnerDocument(), wsDocInfo.getSecurityHeader());
        }
        SecretKey key = null;
        List<WSSecurityEngineResult> encrKeyResults = null;
        Principal principal = null;
        if (secRefToken != null) {
            SecurityTokenRefSTRParser strParser = new SecurityTokenRefSTRParser();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("signature_method", symEncAlgo);
            strParser.parseSecurityTokenReference(secRefToken, request, wsDocInfo, parameters);
            byte[] secretKey = strParser.getSecretKey();
            principal = strParser.getPrincipal();
            key = WSSecurityUtil.prepareSecretKey(symEncAlgo, secretKey);
        } else if (encryptedKeyElement != null) {
            EncryptedKeyProcessor encrKeyProc = new EncryptedKeyProcessor();
            encrKeyResults = encrKeyProc.handleToken(encryptedKeyElement, request, wsDocInfo);
            byte[] symmKey = (byte[])encrKeyResults.get(0).get("secret");
            key = WSSecurityUtil.prepareSecretKey(symEncAlgo, symmKey);
        } else {
            throw new WSSecurityException(2, "noEncKey");
        }
        AlgorithmSuite algorithmSuite = request.getAlgorithmSuite();
        if (algorithmSuite != null) {
            AlgorithmSuiteValidator algorithmSuiteValidator = new AlgorithmSuiteValidator(algorithmSuite);
            if (principal instanceof WSDerivedKeyTokenPrincipal) {
                algorithmSuiteValidator.checkDerivedKeyAlgorithm(((WSDerivedKeyTokenPrincipal)principal).getAlgorithm());
                algorithmSuiteValidator.checkEncryptionDerivedKeyLength(((WSDerivedKeyTokenPrincipal)principal).getLength());
            }
            algorithmSuiteValidator.checkSymmetricKeyLength(key.getEncoded().length);
            algorithmSuiteValidator.checkSymmetricEncryptionAlgorithm(symEncAlgo);
        }
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)symEncAlgo);
            xmlCipher.setSecureValidation(true);
            xmlCipher.init(2, (Key)key);
        }
        catch (XMLEncryptionException ex) {
            throw new WSSecurityException(2, null, null, ex);
        }
        Node previousSibling = elem.getPreviousSibling();
        Node parent = elem.getParentNode();
        try {
            xmlCipher.doFinal(elem.getOwnerDocument(), elem, false);
        }
        catch (Exception e) {
            throw new WSSecurityException(6, null, null, e);
        }
        WSDataRef dataRef = new WSDataRef();
        dataRef.setWsuId(elem.getAttributeNS(null, "Id"));
        dataRef.setAlgorithm(symEncAlgo);
        dataRef.setContent(false);
        Node decryptedNode = previousSibling == null ? parent.getFirstChild() : previousSibling.getNextSibling();
        if (decryptedNode != null && 1 == decryptedNode.getNodeType()) {
            dataRef.setProtectedElement((Element)decryptedNode);
        }
        dataRef.setXpath(ReferenceListProcessor.getXPath(decryptedNode));
        if (decryptedNode != null && decryptedNode.getParentNode().getLocalName().equals("EncryptedAssertion") && decryptedNode.getParentNode().getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
            Node soapHeader = decryptedNode.getParentNode().getParentNode();
            soapHeader.replaceChild(decryptedNode, decryptedNode.getParentNode());
        }
        WSSecurityEngineResult result = new WSSecurityEngineResult(4, Collections.singletonList(dataRef));
        result.put("id", elem.getAttributeNS(null, "Id"));
        wsDocInfo.addResult(result);
        wsDocInfo.addTokenElement(elem);
        ArrayList<WSSecurityEngineResult> completeResults = new ArrayList<WSSecurityEngineResult>();
        if (encrKeyResults != null) {
            completeResults.addAll(encrKeyResults);
        }
        completeResults.add(result);
        WSSConfig wssConfig = request.getWssConfig();
        if (wssConfig != null) {
            Element decryptedElem = dataRef.getProtectedElement();
            QName el = new QName(decryptedElem.getNamespaceURI(), decryptedElem.getLocalName());
            Processor proc = request.getWssConfig().getProcessor(el);
            if (proc != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Processing decrypted element with: " + proc.getClass().getName()));
                }
                List<WSSecurityEngineResult> results = proc.handleToken(decryptedElem, request, wsDocInfo);
                completeResults.addAll(0, results);
                return completeResults;
            }
        }
        return completeResults;
    }

    private static void checkBSPCompliance(String encAlgo) throws WSSecurityException {
        if (encAlgo == null) {
            throw new WSSecurityException(2, "noEncAlgo");
        }
        if (!("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(encAlgo) || "http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(encAlgo) || "http://www.w3.org/2009/xmlenc11#aes128-gcm".equals(encAlgo) || "http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(encAlgo) || "http://www.w3.org/2009/xmlenc11#aes256-gcm".equals(encAlgo))) {
            throw new WSSecurityException(3, "badEncAlgo", new Object[]{encAlgo});
        }
    }
}

