/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.securevault.keystore;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.securevault.SecureVaultException;
import org.apache.synapse.securevault.definition.IdentityKeyStoreInformation;
import org.apache.synapse.securevault.definition.KeyStoreInformation;
import org.apache.synapse.securevault.definition.TrustKeyStoreInformation;

public abstract class KeyStoreWrapper {
    protected Log log = LogFactory.getLog(this.getClass());
    private KeyStoreInformation keyStoreInformation;
    private KeyStore keyStore;
    private String keyPassword;

    protected KeyStoreWrapper() {
    }

    protected void init(KeyStoreInformation information, String keyPassword) {
        if (information == null) {
            throw new SecureVaultException("KeyStore information cannot be found", this.log);
        }
        this.keyStoreInformation = information;
        this.keyPassword = keyPassword;
        if (information instanceof TrustKeyStoreInformation) {
            this.keyStore = ((TrustKeyStoreInformation)information).getTrustStore();
        } else if (information instanceof IdentityKeyStoreInformation) {
            this.keyStore = ((IdentityKeyStoreInformation)information).getIdentityKeyStore();
        } else {
            throw new SecureVaultException("Invalid KeyStore type", this.log);
        }
    }

    protected Key getKey(String alias, String keyPassword) {
        if (alias == null || "".equals(alias)) {
            throw new SecureVaultException("The alias need to provided to get certificate", this.log);
        }
        if (keyPassword != null) {
            try {
                return this.keyStore.getKey(alias, keyPassword.toCharArray());
            }
            catch (KeyStoreException e) {
                throw new SecureVaultException("Error loading key for alias : " + alias, e, this.log);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecureVaultException("Error loading key for alias : " + alias, e, this.log);
            }
            catch (UnrecoverableKeyException e) {
                throw new SecureVaultException("Error loading key for alias : " + alias, e, this.log);
            }
        }
        return null;
    }

    protected Key getPublicKeyFromCertificate(String alias) {
        try {
            Certificate certificate = this.keyStore.getCertificate(alias);
            if (certificate != null) {
                return certificate.getPublicKey();
            }
        }
        catch (KeyStoreException e) {
            throw new SecureVaultException("Error loading key for alias : " + alias, e, this.log);
        }
        return null;
    }

    protected Key getDefaultPrivateKey() {
        if (this.keyPassword != null) {
            return this.getKey(this.keyStoreInformation.getAlias(), this.keyPassword);
        }
        return null;
    }

    protected Key getPrivateKey(String alias) {
        return this.getKey(alias, this.keyPassword);
    }

    public PublicKey getPublicKey(String alias) {
        Key key = this.getPublicKeyFromCertificate(alias);
        if (key instanceof PublicKey) {
            return (PublicKey)key;
        }
        return null;
    }

    public PublicKey getPublicKey() {
        Key key = this.getPublicKeyFromCertificate(this.keyStoreInformation.getAlias());
        if (key instanceof PublicKey) {
            return (PublicKey)key;
        }
        return null;
    }

    protected KeyStore getKeyStore() {
        return this.keyStore;
    }

    public SecretKey getSecretKey(String alias, String keyPassword) {
        Key key = this.getKey(alias, keyPassword);
        if (key instanceof SecretKey) {
            return (SecretKey)key;
        }
        return null;
    }

    public SecretKey getSecretKey() {
        Key key = this.getKey(this.keyStoreInformation.getAlias(), this.keyStoreInformation.getKeyStorePasswordProvider().getResolvedSecret());
        if (key instanceof SecretKey) {
            return (SecretKey)key;
        }
        return null;
    }
}

