/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.securevault.definition;

import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import org.apache.synapse.securevault.definition.KeyStoreInformation;
import org.apache.synapse.securevault.secret.SecretInformation;

public class IdentityKeyStoreInformation
extends KeyStoreInformation {
    private SecretInformation keyPasswordProvider;

    public void setKeyPasswordProvider(SecretInformation keyPasswordProvider) {
        this.keyPasswordProvider = keyPasswordProvider;
    }

    public KeyManagerFactory getIdentityKeyManagerFactoryInstance() {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Creating a IdentityKeyManagerFactory instance");
            }
            KeyStore keyStore = this.getIdentityKeyStore();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, this.keyPasswordProvider.getResolvedSecret().toCharArray());
            return keyManagerFactory;
        }
        catch (Exception e) {
            this.handleException("Error getting KeyManagerFactory: ", e);
            return null;
        }
    }

    public KeyStore getIdentityKeyStore() {
        return super.getKeyStore();
    }

    public SecretInformation getKeyPasswordProvider() {
        return this.keyPasswordProvider;
    }
}

