/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.axiom.util.UIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.TrustException;
import org.apache.rahas.impl.util.CommonUtil;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.util.Base64;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.Attribute;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.AttributeValue;
import org.opensaml.saml1.core.AuthenticationStatement;
import org.opensaml.saml1.core.Conditions;
import org.opensaml.saml1.core.ConfirmationMethod;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml1.core.Statement;
import org.opensaml.saml1.core.Subject;
import org.opensaml.saml1.core.SubjectConfirmation;
import org.opensaml.saml1.core.SubjectStatement;
import org.opensaml.ws.wssecurity.KeyIdentifier;
import org.opensaml.ws.wssecurity.SecurityTokenReference;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.CipherData;
import org.opensaml.xml.encryption.CipherValue;
import org.opensaml.xml.encryption.EncryptedKey;
import org.opensaml.xml.encryption.EncryptionMethod;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.signature.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLUtils {
    private static final Log log = LogFactory.getLog(SAMLUtils.class);

    public static Collection<X509Certificate> getCertChainCollection(X509Certificate[] issuerCerts) {
        ArrayList<X509Certificate> certCollection = new ArrayList<X509Certificate>();
        if (issuerCerts == null) {
            return certCollection;
        }
        Collections.addAll(certCollection, issuerCerts);
        return certCollection;
    }

    public static Assertion buildAssertion(Element assertionElement) {
        return (Assertion)Configuration.getBuilderFactory().getBuilder(Assertion.DEFAULT_ELEMENT_NAME).buildObject(assertionElement);
    }

    public static void signAssertion(Assertion assertion, Crypto crypto, String issuerKeyAlias, String issuerKeyPassword) throws TrustException {
        PrivateKey issuerPrivateKey;
        X509Certificate issuerCerts = CommonUtil.getCertificateByAlias(crypto, issuerKeyAlias);
        String signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        PublicKey issuerPublicKey = issuerCerts.getPublicKey();
        String publicKeyAlgorithm = issuerPublicKey.getAlgorithm();
        if (publicKeyAlgorithm.equalsIgnoreCase("DSA")) {
            signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
        try {
            issuerPrivateKey = crypto.getPrivateKey(issuerKeyAlias, issuerKeyPassword);
        }
        catch (Exception e) {
            log.debug((Object)("Unable to get issuer private key for issuer alias " + issuerKeyAlias));
            throw new TrustException("issuerPrivateKeyNotFound", new Object[]{issuerKeyAlias});
        }
        BasicCredential signingCredential = SecurityHelper.getSimpleCredential((PublicKey)issuerPublicKey, (PrivateKey)issuerPrivateKey);
        Signature signature = (Signature)CommonUtil.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        signature.setSigningCredential((Credential)signingCredential);
        signature.setSignatureAlgorithm(signatureAlgorithm);
        X509Data x509Data = CommonUtil.createX509Data(issuerCerts);
        KeyInfo keyInfo = SAMLUtils.createKeyInfo(x509Data);
        signature.setKeyInfo(keyInfo);
        assertion.setSignature(signature);
        try {
            Document document = CommonUtil.getOMDOMDocument();
            Configuration.getMarshallerFactory().getMarshaller((XMLObject)assertion).marshall((XMLObject)assertion, document);
        }
        catch (MarshallingException e) {
            log.debug((Object)"Error while marshalling assertion ", (Throwable)e);
            throw new TrustException("errorMarshallingAssertion", e);
        }
        try {
            Signer.signObject((Signature)signature);
        }
        catch (SignatureException e) {
            log.debug((Object)("Error signing SAML Assertion. An error occurred while signing SAML Assertion with alias " + issuerKeyAlias), (Throwable)e);
            throw new TrustException("errorSigningAssertion", e);
        }
    }

    public static String getSAML11SubjectConfirmationMethod(Assertion assertion) {
        List confirmationMethods;
        SubjectConfirmation subjectConfirmation;
        SubjectStatement subjectStatement;
        Subject subject;
        String subjectConfirmationMethod = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
        List statements = assertion.getStatements();
        if (!statements.isEmpty() && (subject = (subjectStatement = (SubjectStatement)statements.get(0)).getSubject()) != null && (subjectConfirmation = subject.getSubjectConfirmation()) != null && !(confirmationMethods = subjectConfirmation.getConfirmationMethods()).isEmpty()) {
            subjectConfirmationMethod = ((ConfirmationMethod)confirmationMethods.get(0)).getConfirmationMethod();
        }
        return subjectConfirmationMethod;
    }

    public static NameIdentifier createNamedIdentifier(String principalName, String format) throws TrustException {
        NameIdentifier nameId = (NameIdentifier)CommonUtil.buildXMLObject(NameIdentifier.DEFAULT_ELEMENT_NAME);
        nameId.setNameIdentifier(principalName);
        nameId.setFormat(format);
        return nameId;
    }

    public static ConfirmationMethod createSubjectConfirmationMethod(String confirmationMethod) throws TrustException {
        ConfirmationMethod confirmationMethodObject = (ConfirmationMethod)CommonUtil.buildXMLObject(ConfirmationMethod.DEFAULT_ELEMENT_NAME);
        confirmationMethodObject.setConfirmationMethod(confirmationMethod);
        return confirmationMethodObject;
    }

    public static SubjectConfirmation createSubjectConfirmation(String confirmationMethod, KeyInfo keyInfoContent) throws TrustException {
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)CommonUtil.buildXMLObject(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        ConfirmationMethod method = SAMLUtils.createSubjectConfirmationMethod(confirmationMethod);
        subjectConfirmation.getConfirmationMethods().add(method);
        if (keyInfoContent != null) {
            subjectConfirmation.setKeyInfo(keyInfoContent);
        }
        return subjectConfirmation;
    }

    public static Subject createSubject(NameIdentifier nameIdentifier, String confirmationMethod, KeyInfo keyInfoContent) throws TrustException {
        Subject subject = (Subject)CommonUtil.buildXMLObject(Subject.DEFAULT_ELEMENT_NAME);
        subject.setNameIdentifier(nameIdentifier);
        SubjectConfirmation subjectConfirmation = SAMLUtils.createSubjectConfirmation(confirmationMethod, keyInfoContent);
        subject.setSubjectConfirmation(subjectConfirmation);
        return subject;
    }

    public static AuthenticationStatement createAuthenticationStatement(Subject subject, String authenticationMethod, DateTime authenticationInstant) throws TrustException {
        AuthenticationStatement authenticationStatement = (AuthenticationStatement)CommonUtil.buildXMLObject(AuthenticationStatement.DEFAULT_ELEMENT_NAME);
        authenticationStatement.setSubject(subject);
        authenticationStatement.setAuthenticationMethod(authenticationMethod);
        authenticationStatement.setAuthenticationInstant(authenticationInstant);
        return authenticationStatement;
    }

    public static AttributeStatement createAttributeStatement(Subject subject, List<Attribute> attributeList) throws TrustException {
        AttributeStatement attributeStatement = (AttributeStatement)CommonUtil.buildXMLObject(AttributeStatement.DEFAULT_ELEMENT_NAME);
        attributeStatement.setSubject(subject);
        attributeStatement.getAttributes().addAll(attributeList);
        return attributeStatement;
    }

    public static Conditions createConditions(DateTime notBefore, DateTime notOnOrAfter) throws TrustException {
        Conditions conditions = (Conditions)CommonUtil.buildXMLObject(Conditions.DEFAULT_ELEMENT_NAME);
        conditions.setNotBefore(notBefore);
        conditions.setNotOnOrAfter(notOnOrAfter);
        return conditions;
    }

    public static Assertion createAssertion(String issuerName, DateTime notBefore, DateTime notOnOrAfter, List<Statement> statements) throws TrustException {
        Assertion assertion = (Assertion)CommonUtil.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME);
        assertion.setIssuer(issuerName);
        assertion.setConditions(SAMLUtils.createConditions(notBefore, notOnOrAfter));
        assertion.getStatements().addAll(statements);
        assertion.setID(UIDGenerator.generateUID());
        assertion.setIssueInstant(new DateTime());
        return assertion;
    }

    public static Attribute createAttribute(String name, String namespace, String value) throws TrustException {
        Attribute attribute = (Attribute)CommonUtil.buildXMLObject(Attribute.DEFAULT_ELEMENT_NAME);
        attribute.setAttributeName(name);
        attribute.setAttributeNamespace(namespace);
        XSStringBuilder attributeValueBuilder = (XSStringBuilder)Configuration.getBuilderFactory().getBuilder(XSString.TYPE_NAME);
        XSString stringValue = (XSString)attributeValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        stringValue.setValue(value);
        attribute.getAttributeValues().add(stringValue);
        return attribute;
    }

    public static KeyInfo createKeyInfo() throws TrustException {
        return (KeyInfo)CommonUtil.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
    }

    public static KeyInfo createKeyInfo(EncryptedKey encryptedKey) throws TrustException {
        KeyInfo keyInfo = SAMLUtils.createKeyInfo();
        keyInfo.getEncryptedKeys().add(encryptedKey);
        return keyInfo;
    }

    public static KeyInfo createKeyInfo(X509Data x509Data) throws TrustException {
        KeyInfo keyInfo = SAMLUtils.createKeyInfo();
        keyInfo.getX509Datas().add(x509Data);
        return keyInfo;
    }

    static EncryptedKey createEncryptedKey(X509Certificate certificate, WSSecEncryptedKey wsSecEncryptedKey) throws TrustException {
        SecurityTokenReference securityTokenReference = (SecurityTokenReference)CommonUtil.buildXMLObject(SecurityTokenReference.ELEMENT_NAME);
        KeyIdentifier keyIdentifier = (KeyIdentifier)CommonUtil.buildXMLObject(KeyIdentifier.ELEMENT_NAME);
        keyIdentifier.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        keyIdentifier.setValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1");
        keyIdentifier.setValue(SAMLUtils.getThumbprintSha1(certificate));
        securityTokenReference.getUnknownXMLObjects().add(keyIdentifier);
        KeyInfo keyInfo = SAMLUtils.createKeyInfo();
        keyInfo.getXMLObjects().add(securityTokenReference);
        CipherValue cipherValue = (CipherValue)CommonUtil.buildXMLObject(CipherValue.DEFAULT_ELEMENT_NAME);
        cipherValue.setValue(Base64.encode((byte[])wsSecEncryptedKey.getEncryptedEphemeralKey()));
        CipherData cipherData = (CipherData)CommonUtil.buildXMLObject(CipherData.DEFAULT_ELEMENT_NAME);
        cipherData.setCipherValue(cipherValue);
        EncryptionMethod encryptionMethod = (EncryptionMethod)CommonUtil.buildXMLObject(EncryptionMethod.DEFAULT_ELEMENT_NAME);
        encryptionMethod.setAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        EncryptedKey encryptedKey = (EncryptedKey)CommonUtil.buildXMLObject(EncryptedKey.DEFAULT_ELEMENT_NAME);
        encryptedKey.setID(wsSecEncryptedKey.getId());
        encryptedKey.setEncryptionMethod(encryptionMethod);
        encryptedKey.setCipherData(cipherData);
        encryptedKey.setKeyInfo(keyInfo);
        return encryptedKey;
    }

    private static String getThumbprintSha1(X509Certificate cert) throws TrustException {
        MessageDigest sha;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e1) {
            throw new TrustException("sha1NotFound", e1);
        }
        sha.reset();
        try {
            sha.update(cert.getEncoded());
        }
        catch (CertificateEncodingException e1) {
            throw new TrustException("certificateEncodingError", e1);
        }
        byte[] data = sha.digest();
        return Base64.encode((byte[])data);
    }
}

