/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.osgi.BundleAccessor;
import org.apache.struts2.osgi.OsgiUtil;
import org.apache.struts2.osgi.host.OsgiHost;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class DefaultBundleAccessor
implements BundleAccessor {
    private static DefaultBundleAccessor self;
    private static final Logger LOG;
    private BundleContext bundleContext;
    private Map<String, String> packageToBundle = new HashMap<String, String>();
    private Map<Bundle, Set<String>> packagesByBundle = new HashMap<Bundle, Set<String>>();
    private OsgiHost osgiHost;

    public DefaultBundleAccessor() {
        if (self == null) {
            self = this;
        } else {
            this.bundleContext = DefaultBundleAccessor.self.bundleContext;
            this.packageToBundle = DefaultBundleAccessor.self.packageToBundle;
            this.packagesByBundle = DefaultBundleAccessor.self.packagesByBundle;
            this.osgiHost = DefaultBundleAccessor.self.osgiHost;
            self = this;
        }
    }

    public static DefaultBundleAccessor getInstance() {
        return self;
    }

    @Override
    public Object getService(ServiceReference ref) {
        return this.bundleContext != null ? this.bundleContext.getService(ref) : null;
    }

    @Override
    public ServiceReference getServiceReference(String className) {
        return this.bundleContext != null ? this.bundleContext.getServiceReference(className) : null;
    }

    @Override
    public ServiceReference[] getAllServiceReferences(String className) {
        if (this.bundleContext != null) {
            try {
                return this.bundleContext.getServiceReferences(className, null);
            }
            catch (InvalidSyntaxException e) {
                LOG.error("Invalid syntax for service lookup", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public ServiceReference[] getServiceReferences(String className, String params) throws InvalidSyntaxException {
        return this.bundleContext != null ? this.bundleContext.getServiceReferences(className, params) : null;
    }

    @Override
    public void addPackageFromBundle(Bundle bundle, String packageName) {
        this.packageToBundle.put(packageName, bundle.getSymbolicName());
        Set<String> pkgs = this.packagesByBundle.get(bundle);
        if (pkgs == null) {
            pkgs = new HashSet<String>();
            this.packagesByBundle.put(bundle, pkgs);
        }
        pkgs.add(packageName);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        Bundle bundle = this.getCurrentBundle();
        if (bundle != null) {
            Class cls = bundle.loadClass(className);
            LOG.trace("Located class [{}] in bundle [{}]", (Object)className, (Object)bundle.getSymbolicName());
            return cls;
        }
        throw new ClassNotFoundException("Unable to find class " + className);
    }

    private Bundle getCurrentBundle() {
        ActionContext ctx = ActionContext.getContext();
        if (ctx == null) {
            throw new IllegalStateException("Unable to get current bundle, ActionContext is null");
        }
        String bundleName = (String)ctx.get("__bundle_name__");
        if (bundleName == null) {
            ActionInvocation inv = ctx.getActionInvocation();
            ActionProxy proxy = inv.getProxy();
            ActionConfig actionConfig = proxy.getConfig();
            bundleName = this.packageToBundle.get(actionConfig.getPackageName());
        }
        if (bundleName != null) {
            return this.osgiHost.getActiveBundles().get(bundleName);
        }
        return null;
    }

    public List<URL> loadResources(String name) throws IOException {
        return this.loadResources(name, false);
    }

    public List<URL> loadResources(String name, boolean translate) throws IOException {
        Bundle bundle = this.getCurrentBundle();
        if (bundle != null) {
            ArrayList<URL> resources = new ArrayList<URL>();
            Enumeration e = bundle.getResources(name);
            if (e != null) {
                while (e.hasMoreElements()) {
                    resources.add(translate ? OsgiUtil.translateBundleURLToJarURL((URL)e.nextElement(), this.getCurrentBundle()) : (URL)e.nextElement());
                }
            }
            return resources;
        }
        return null;
    }

    @Override
    public URL loadResourceFromAllBundles(String name) throws IOException {
        for (Map.Entry<String, Bundle> entry : this.osgiHost.getActiveBundles().entrySet()) {
            Enumeration e = entry.getValue().getResources(name);
            if (e == null || !e.hasMoreElements()) continue;
            return (URL)e.nextElement();
        }
        return null;
    }

    @Override
    public InputStream loadResourceFromAllBundlesAsStream(String name) throws IOException {
        URL url = this.loadResourceFromAllBundles(name);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    public URL loadResource(String name) {
        return this.loadResource(name, false);
    }

    public URL loadResource(String name, boolean translate) {
        Bundle bundle = this.getCurrentBundle();
        if (bundle != null) {
            URL url = bundle.getResource(name);
            try {
                return translate ? OsgiUtil.translateBundleURLToJarURL(url, this.getCurrentBundle()) : url;
            }
            catch (Exception e) {
                LOG.error("Unable to translate bundle URL to jar URL", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public Set<String> getPackagesByBundle(Bundle bundle) {
        return this.packagesByBundle.get(bundle);
    }

    @Override
    public InputStream loadResourceAsStream(String name) throws IOException {
        URL url = this.loadResource(name);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    @Override
    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void setOsgiHost(OsgiHost osgiHost) {
        this.osgiHost = osgiHost;
    }

    static {
        LOG = LogManager.getLogger(DefaultBundleAccessor.class);
    }
}

