/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.validation;

import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hibernate.validator.parameternameprovider.ReflectionParameterNameProvider;

public class JerseyParameterNameProvider
extends ReflectionParameterNameProvider {
    public List<String> getParameterNames(Method method) {
        Parameter[] parameters = method.getParameters();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<String> names = new ArrayList<String>(parameterAnnotations.length);
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            String name = JerseyParameterNameProvider.getParameterNameFromAnnotations(annotations).orElse(parameters[i].getName());
            names.add(name);
        }
        return names;
    }

    public static Optional<String> getParameterNameFromAnnotations(Annotation[] memberAnnotations) {
        for (Annotation a : memberAnnotations) {
            if (a instanceof QueryParam) {
                QueryParam queryParam = (QueryParam)a;
                return Optional.of("query param " + queryParam.value());
            }
            if (a instanceof PathParam) {
                PathParam pathParam = (PathParam)a;
                return Optional.of("path param " + pathParam.value());
            }
            if (a instanceof HeaderParam) {
                HeaderParam headerParam = (HeaderParam)a;
                return Optional.of("header " + headerParam.value());
            }
            if (a instanceof CookieParam) {
                CookieParam cookieParam = (CookieParam)a;
                return Optional.of("cookie " + cookieParam.value());
            }
            if (a instanceof FormParam) {
                FormParam formParam = (FormParam)a;
                return Optional.of("form field " + formParam.value());
            }
            if (a instanceof Context) {
                return Optional.of("context");
            }
            if (!(a instanceof MatrixParam)) continue;
            MatrixParam matrixParam = (MatrixParam)a;
            return Optional.of("matrix param " + matrixParam.value());
        }
        return Optional.empty();
    }
}

