/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.storm.generated.NodeInfo;
import org.apache.storm.messaging.IConnection;
import org.apache.storm.messaging.TaskMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferDrainer {
    private static final Logger LOG = LoggerFactory.getLogger(TransferDrainer.class);
    private final Map<Integer, ArrayList<TaskMessage>> bundles = new HashMap<Integer, ArrayList<TaskMessage>>();

    public void add(TaskMessage taskMsg) {
        int destId = taskMsg.task();
        ArrayList<TaskMessage> msgs = this.bundles.get(destId);
        if (msgs == null) {
            msgs = new ArrayList();
            this.bundles.put(destId, msgs);
        }
        msgs.add(taskMsg);
    }

    public void send(Map<Integer, NodeInfo> taskToNode, Map<NodeInfo, IConnection> connections) {
        HashMap<NodeInfo, Stream<TaskMessage>> bundleMapByDestination = this.groupBundleByDestination(taskToNode);
        for (Map.Entry<NodeInfo, Stream<TaskMessage>> entry : bundleMapByDestination.entrySet()) {
            NodeInfo node = entry.getKey();
            IConnection conn = connections.get(node);
            if (conn != null) {
                Iterator<TaskMessage> iter = entry.getValue().iterator();
                if (!iter.hasNext()) continue;
                conn.send(iter);
                continue;
            }
            LOG.warn("Connection not available for hostPort {}", (Object)node);
        }
    }

    private HashMap<NodeInfo, Stream<TaskMessage>> groupBundleByDestination(Map<Integer, NodeInfo> taskToNode) {
        HashMap<NodeInfo, Stream<TaskMessage>> result2 = new HashMap<NodeInfo, Stream<TaskMessage>>();
        for (Map.Entry<Integer, ArrayList<TaskMessage>> entry : this.bundles.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            NodeInfo node = taskToNode.get(entry.getKey());
            if (node != null) {
                result2.merge(node, entry.getValue().stream(), Stream::concat);
                continue;
            }
            LOG.warn("No remote destination available for task {}", (Object)entry.getKey());
        }
        return result2;
    }

    public void clear() {
        for (ArrayList<TaskMessage> taskMessages : this.bundles.values()) {
            taskMessages.clear();
        }
    }
}

