/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.drpc.webapp;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import org.apache.storm.daemon.drpc.DRPC;
import org.apache.storm.metric.StormMetricsRegistry;

@Path(value="/drpc/")
public class DRPCResource {
    private final Meter meterHttpRequests;
    private final Timer responseDuration;
    private final DRPC drpc;

    public DRPCResource(DRPC drpc, StormMetricsRegistry metricsRegistry) {
        this.drpc = drpc;
        this.meterHttpRequests = metricsRegistry.registerMeter("drpc:num-execute-http-requests");
        this.responseDuration = metricsRegistry.registerTimer("drpc:HTTP-request-response-duration");
    }

    @POST
    @Path(value="/{func}")
    public String post(@PathParam(value="func") String func, String args, @Context HttpServletRequest request) throws Exception {
        this.meterHttpRequests.mark();
        return (String)this.responseDuration.time(() -> this.drpc.executeBlocking(func, args));
    }

    @GET
    @Path(value="/{func}/{args}")
    public String get(@PathParam(value="func") String func, @PathParam(value="args") String args, @Context HttpServletRequest request) throws Exception {
        this.meterHttpRequests.mark();
        return (String)this.responseDuration.time(() -> this.drpc.executeBlocking(func, args));
    }

    @GET
    @Path(value="/{func}")
    public String get(@PathParam(value="func") String func, @Context HttpServletRequest request) throws Exception {
        this.meterHttpRequests.mark();
        return (String)this.responseDuration.time(() -> this.drpc.executeBlocking(func, ""));
    }
}

