/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.shaded.framework.imps;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.curator.shaded.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.shaded.framework.imps.NamespaceFacade;
import org.apache.curator.shaded.shaded.com.google.common.cache.CacheBuilder;
import org.apache.curator.shaded.shaded.com.google.common.cache.CacheLoader;
import org.apache.curator.shaded.shaded.com.google.common.cache.LoadingCache;

class NamespaceFacadeCache {
    private final CuratorFrameworkImpl client;
    private final NamespaceFacade nullNamespace;
    private final CacheLoader<String, NamespaceFacade> loader = new CacheLoader<String, NamespaceFacade>(){

        @Override
        public NamespaceFacade load(String namespace) throws Exception {
            return new NamespaceFacade(NamespaceFacadeCache.this.client, namespace);
        }
    };
    private final LoadingCache<String, NamespaceFacade> cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(this.loader);

    NamespaceFacadeCache(CuratorFrameworkImpl client) {
        this.client = client;
        this.nullNamespace = new NamespaceFacade(client, null);
    }

    NamespaceFacade get(String namespace) {
        try {
            return namespace != null ? this.cache.get(namespace) : this.nullNamespace;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

