/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.thumbnails.RenditionSupport;
import org.apache.sling.thumbnails.ThumbnailSupport;
import org.apache.sling.thumbnails.internal.TransformationServiceUser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RenditionSupport.class})
public class RenditionSupportImpl
implements RenditionSupport {
    private final ThumbnailSupport thumbnailSupport;
    private final TransformationServiceUser transformationServiceUser;

    @Activate
    public RenditionSupportImpl(@Reference ThumbnailSupport thumbnailSupport, @Reference TransformationServiceUser transformationServiceUser) {
        this.thumbnailSupport = thumbnailSupport;
        this.transformationServiceUser = transformationServiceUser;
    }

    @Override
    @Nullable
    public Resource getRendition(@NotNull Resource file, @NotNull String renditionName) {
        if (this.supportsRenditions(file)) {
            String subpath = this.thumbnailSupport.getRenditionPath(file.getResourceType());
            return file.getChild(subpath + "/" + renditionName);
        }
        return null;
    }

    @Override
    @Nullable
    public InputStream getRenditionContent(@NotNull Resource file, @NotNull String renditionName) {
        return Optional.ofNullable(this.getRendition(file, renditionName)).map(r -> (InputStream)r.adaptTo(InputStream.class)).orElse(null);
    }

    @Override
    @NotNull
    public List<Resource> listRenditions(@NotNull Resource file) {
        ArrayList<Resource> renditions = new ArrayList<Resource>();
        if (this.supportsRenditions(file)) {
            Optional.ofNullable(file.getChild(this.thumbnailSupport.getRenditionPath(file.getResourceType()))).ifPresent(renditionFolder -> StreamSupport.stream(renditionFolder.getChildren().spliterator(), false).filter(c -> "nt:file".equals(c.getResourceType())).forEach(renditions::add));
        }
        return renditions;
    }

    @Override
    public boolean renditionExists(@NotNull Resource file, @NotNull String renditionName) {
        return this.getRendition(file, renditionName) != null;
    }

    @Override
    public boolean supportsRenditions(@NotNull Resource file) {
        return this.thumbnailSupport.getPersistableTypes().contains(file.getResourceType());
    }

    @Override
    public void setRendition(@NotNull Resource file, @NotNull String renditionName, @NotNull InputStream contents) throws PersistenceException {
        if (renditionName.indexOf("/") != 0) {
            renditionName = "/" + renditionName;
        }
        try (ResourceResolver serviceResolver = this.transformationServiceUser.getTransformationServiceUser();){
            Resource renditionFile = ResourceUtil.getOrCreateResource((ResourceResolver)serviceResolver, (String)(file.getPath() + "/" + this.thumbnailSupport.getRenditionPath(file.getResourceType()) + renditionName), Collections.singletonMap("jcr:primaryType", "nt:file"), (String)"nt:unstructured", (boolean)false);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("jcr:primaryType", "nt:unstructured");
            properties.put("jcr:data", contents);
            ResourceUtil.getOrCreateResource((ResourceResolver)serviceResolver, (String)(renditionFile.getPath() + "/" + "jcr:content"), properties, (String)"nt:unstructured", (boolean)true);
        }
        catch (LoginException le) {
            throw new PersistenceException("Could not save due to LoginException", (Throwable)le);
        }
    }
}

