/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.composite;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.PolicyOwner;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregationFilter;
import org.jetbrains.annotations.NotNull;

class CompositeAccessControlManager
extends AbstractAccessControlManager {
    private final List<AccessControlManager> acMgrs;
    private final AggregationFilter aggregationFilter;

    public CompositeAccessControlManager(@NotNull Root root, @NotNull NamePathMapper namePathMapper, @NotNull SecurityProvider securityProvider, @NotNull List<AccessControlManager> acMgrs, @NotNull AggregationFilter aggregationFilter) {
        super(root, namePathMapper, securityProvider);
        this.acMgrs = acMgrs;
        this.aggregationFilter = aggregationFilter;
    }

    @Override
    @NotNull
    public Privilege[] getSupportedPrivileges(String absPath) throws RepositoryException {
        LinkedHashSet<Privilege> privs = new LinkedHashSet<Privilege>();
        for (AccessControlManager acMgr : this.acMgrs) {
            privs.addAll(Arrays.asList(acMgr.getSupportedPrivileges(absPath)));
        }
        return privs.toArray(new Privilege[0]);
    }

    public AccessControlPolicy[] getPolicies(String absPath) throws RepositoryException {
        ArrayList<AccessControlPolicy> policies = new ArrayList<AccessControlPolicy>();
        for (AccessControlManager acMgr : this.acMgrs) {
            policies.addAll(Arrays.asList(acMgr.getPolicies(absPath)));
        }
        return policies.toArray(new AccessControlPolicy[0]);
    }

    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws RepositoryException {
        ArrayList<AccessControlPolicy> policies = new ArrayList<AccessControlPolicy>();
        for (AccessControlManager acMgr : this.acMgrs) {
            policies.addAll(Arrays.asList(acMgr.getEffectivePolicies(absPath)));
            if (!this.aggregationFilter.stop(acMgr, absPath)) continue;
            break;
        }
        return (AccessControlPolicy[])policies.stream().distinct().toArray(AccessControlPolicy[]::new);
    }

    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws RepositoryException {
        ArrayList<AccessControlPolicyIterator> l = new ArrayList<AccessControlPolicyIterator>();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof PolicyOwner)) continue;
            l.add(acMgr.getApplicablePolicies(absPath));
        }
        return new AccessControlPolicyIteratorAdapter(IteratorUtils.chainedIterator((Iterator[])l.toArray(new AccessControlPolicyIterator[0])));
    }

    public void setPolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof PolicyOwner) || !((PolicyOwner)acMgr).defines(absPath, policy)) continue;
            acMgr.setPolicy(absPath, policy);
            return;
        }
        throw new AccessControlException("Cannot set access control policy " + String.valueOf(policy) + "; no PolicyOwner found.");
    }

    public void removePolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof PolicyOwner) || !((PolicyOwner)acMgr).defines(absPath, policy)) continue;
            acMgr.removePolicy(absPath, policy);
            return;
        }
        throw new AccessControlException("Cannot remove access control policy " + String.valueOf(policy) + "; no PolicyOwner found.");
    }

    @Override
    @NotNull
    public JackrabbitAccessControlPolicy[] getApplicablePolicies(@NotNull Principal principal) throws RepositoryException {
        ArrayList<JackrabbitAccessControlPolicy> policies = new ArrayList<JackrabbitAccessControlPolicy>();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof JackrabbitAccessControlManager) || !(acMgr instanceof PolicyOwner)) continue;
            policies.addAll(Arrays.asList(((JackrabbitAccessControlManager)acMgr).getApplicablePolicies(principal)));
        }
        return policies.toArray(new JackrabbitAccessControlPolicy[0]);
    }

    @Override
    @NotNull
    public JackrabbitAccessControlPolicy[] getPolicies(@NotNull Principal principal) throws RepositoryException {
        ArrayList<JackrabbitAccessControlPolicy> policies = new ArrayList<JackrabbitAccessControlPolicy>();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof JackrabbitAccessControlManager)) continue;
            policies.addAll(Arrays.asList(((JackrabbitAccessControlManager)acMgr).getPolicies(principal)));
        }
        return policies.toArray(new JackrabbitAccessControlPolicy[0]);
    }

    @Override
    @NotNull
    public AccessControlPolicy[] getEffectivePolicies(@NotNull Set<Principal> principals) throws RepositoryException {
        ArrayList<AccessControlPolicy> policies = new ArrayList<AccessControlPolicy>();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof JackrabbitAccessControlManager)) continue;
            JackrabbitAccessControlManager jAcMgr = (JackrabbitAccessControlManager)acMgr;
            policies.addAll(Arrays.asList(jAcMgr.getEffectivePolicies(principals)));
            if (!this.aggregationFilter.stop(jAcMgr, principals)) continue;
            break;
        }
        return policies.toArray(new AccessControlPolicy[0]);
    }

    @Override
    @NotNull
    public Iterator<AccessControlPolicy> getEffectivePolicies(@NotNull Set<Principal> principals, String ... absPaths) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        ArrayList<Iterator<AccessControlPolicy>> iterators = new ArrayList<Iterator<AccessControlPolicy>>();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof JackrabbitAccessControlManager)) continue;
            JackrabbitAccessControlManager jAcMgr = (JackrabbitAccessControlManager)acMgr;
            iterators.add(jAcMgr.getEffectivePolicies(principals, absPaths));
            if (!this.aggregationFilter.stop(jAcMgr, principals)) continue;
            break;
        }
        return IteratorUtils.chainedIterator(iterators.toArray(new Iterator[0]));
    }
}

