/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.samples.impl;

import aQute.bnd.annotation.component.Deactivate;
import javax.script.Bindings;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.hc.util.FormattingResultLog;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Property(name="context", value={"healthcheck"})
public class OsgiScriptBindingsProvider
implements BindingsValuesProvider {
    private BundleContext bundleContext;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String OSGI_BINDING_NAME = "osgi";

    @Activate
    protected void activate(ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        this.bundleContext = null;
    }

    public void addBindings(Bindings b) {
        String logBindingName = FormattingResultLog.class.getName();
        Object resultLog = b.get(logBindingName);
        if (resultLog == null) {
            this.log.info("No {} found in Bindings, cannot activate {} binding", (Object)logBindingName, (Object)OSGI_BINDING_NAME);
            return;
        }
        try {
            b.put(OSGI_BINDING_NAME, (Object)new OsgiBinding(this.bundleContext, (FormattingResultLog)resultLog));
        }
        catch (Exception e) {
            this.log.error("Exception while activating osgi", (Throwable)e);
        }
    }

    public static class OsgiBinding {
        private final BundleContext bundleContext;
        private final FormattingResultLog resultLog;

        public OsgiBinding(BundleContext bc, FormattingResultLog r) {
            this.bundleContext = bc;
            this.resultLog = r;
        }

        public int inactiveBundlesCount() {
            int count = 0;
            for (Bundle b : this.bundleContext.getBundles()) {
                if (this.isActive(b)) continue;
                ++count;
            }
            this.resultLog.debug("inactiveBundlesCount={}", new Object[]{count});
            return count;
        }

        private boolean isActive(Bundle b) {
            boolean active = true;
            if (!this.isFragment(b) && 32 != b.getState()) {
                active = false;
                this.resultLog.info("Bundle {} is not active, state={} ({})", new Object[]{b.getSymbolicName(), b.getState(), b.getState()});
            }
            return active;
        }

        private boolean isFragment(Bundle b) {
            String header = (String)b.getHeaders().get("Fragment-Host");
            if (header != null && header.trim().length() > 0) {
                this.resultLog.debug("{} is a fragment bundle, state won't be checked", new Object[]{b});
                return true;
            }
            return false;
        }
    }
}

