/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.fsclassloader.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.commons.fsclassloader.FSClassLoaderMBean;
import org.apache.sling.commons.fsclassloader.impl.CacheLocationUtils;
import org.apache.sling.commons.fsclassloader.impl.FSClassLoaderComponentConfig;
import org.apache.sling.commons.fsclassloader.impl.FSClassLoaderWebConsole;
import org.apache.sling.commons.fsclassloader.impl.ScriptFiles;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.apache.sling.commons.fsclassloader.impl.FSClassLoaderProvider"}, property={"service.description=Apache Sling FSClassLoader Controller Service", "service.vendor=The Apache Software Foundation", "jmx.objectname=org.apache.sling.classloader:name=FSClassLoader,type=ClassLoader"})
public class FSClassLoaderMBeanImpl
implements FSClassLoaderMBean {
    private volatile File root;
    private static final Logger log = LoggerFactory.getLogger(FSClassLoaderMBeanImpl.class);
    @Reference(target="(component.name=org.apache.sling.commons.fsclassloader.impl.FSClassLoaderProvider)")
    private ClassLoaderWriter classLoaderWriter;

    @Activate
    protected void activate(ComponentContext componentContext, FSClassLoaderComponentConfig config) {
        this.root = CacheLocationUtils.getRootDir(componentContext.getBundleContext(), config);
    }

    @Override
    public int getCachedScriptCount() throws IOException {
        return this.getScripts().size();
    }

    @Override
    public List<String> getCachedScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.addAll(this.getScripts());
        Collections.sort(scripts);
        return scripts;
    }

    private Collection<String> getScripts() {
        Set<String> scripts = new HashSet<String>();
        try {
            LinkedHashMap<String, ScriptFiles> s = new LinkedHashMap<String, ScriptFiles>();
            if (this.root != null) {
                FSClassLoaderWebConsole.readFiles(this.root, this.root, s);
            }
            scripts = s.keySet();
        }
        catch (Exception e) {
            log.warn("Exception retrieving scripts from FSClassLoader", (Throwable)e);
        }
        return scripts;
    }

    @Override
    public void clearCache() {
        this.classLoaderWriter.delete("");
    }

    @Override
    public String getFSClassLoaderRoot() {
        return this.root.getAbsolutePath();
    }
}

