/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gdal;

import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.net.URI;
import java.nio.file.Path;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.gdal.GDAL;
import org.apache.sis.storage.gdal.GDALStoreProvider;
import org.apache.sis.storage.gdal.Opener;
import org.apache.sis.storage.panama.Resources;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;

public final class Driver {
    private final GDALStoreProvider owner;
    private final MemorySegment handle;

    Driver(GDALStoreProvider owner, MemorySegment handle) {
        this.owner = owner;
        this.handle = handle;
    }

    public String getName() throws DataStoreException {
        MemorySegment result;
        MethodHandle gdal = this.owner.GDAL().getName;
        try {
            result = gdal.invokeExact(this.handle);
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
        return GDAL.toString(result);
    }

    public String getIdentifier() throws DataStoreException {
        MemorySegment result;
        MethodHandle gdal = this.owner.GDAL().getIdentifier;
        try {
            result = gdal.invokeExact(this.handle);
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
        return GDAL.toString(result);
    }

    public String getMIMEType() throws DataStoreException {
        return this.getMetadataItem("DMD_MIMETYPE", null);
    }

    public String[] getFileSuffixes() throws DataStoreException {
        return (String[])CharSequences.split((CharSequence)this.getMetadataItem("DMD_EXTENSIONS", null), (char)' ');
    }

    public boolean supportRasters() throws DataStoreException {
        return "YES".equalsIgnoreCase(this.getMetadataItem("DCAP_RASTER", null));
    }

    public String getMetadataItem(String name, String domain) throws DataStoreException {
        MemorySegment result;
        MethodHandle gdal = this.owner.GDAL().getMetadataItem;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment opt = domain != null ? arena.allocateFrom(domain) : MemorySegment.NULL;
            result = gdal.invokeExact(this.handle, arena.allocateFrom(name), opt);
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
        return GDAL.toString(result);
    }

    static TreeTable configuration(GDALStoreProvider owner, GDAL gdal) {
        TableColumn longNameColumn = TableColumn.NAME;
        TableColumn shortNameColumn = TableColumn.IDENTIFIER;
        DefaultTreeTable table = new DefaultTreeTable(new TableColumn[]{shortNameColumn, longNameColumn});
        TreeTable.Node root = table.getRoot();
        String version = gdal != null ? (String)gdal.version("--version").orElse(null) : null;
        root.setValue(shortNameColumn, (Object)(gdal != null ? gdal.libraryName : Resources.format((short)5, "GDAL")));
        root.setValue(longNameColumn, (Object)(version != null ? version : Vocabulary.format((short)207)));
        DataStoreException error = null;
        for (Driver driver : Driver.list(owner, gdal)) {
            try {
                if (!driver.supportRasters()) continue;
                TreeTable.Node node = root.newChild();
                node.setValue(shortNameColumn, (Object)driver.getIdentifier());
                node.setValue(longNameColumn, (Object)driver.getName());
            }
            catch (DataStoreException e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                error.addSuppressed((Throwable)e);
            }
        }
        if (error != null) {
            Logging.unexpectedException((Logger)GDALStoreProvider.LOGGER, GDALStoreProvider.class, (String)"configuration", error);
        }
        return table;
    }

    static List<Driver> list(final GDALStoreProvider owner, GDAL gdal) {
        MemorySegment address;
        if (gdal == null || (address = (MemorySegment)gdal.symbols.find("GDALGetDriver").orElse(null)) == null) {
            return List.of();
        }
        final MethodHandle getDriver = gdal.linker.downcallHandle(address, FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.JAVA_INT), new Linker.Option[0]);
        final int count = gdal.invokeGetInt("GDALGetDriverCount").orElse(0);
        return new AbstractList<Driver>(){

            @Override
            public int size() {
                return count;
            }

            @Override
            public Driver get(int index) {
                MemorySegment handle;
                try {
                    handle = getDriver.invokeExact(Objects.checkIndex(index, count));
                }
                catch (Throwable e) {
                    throw GDAL.propagate(e);
                }
                return GDAL.isNull(handle) ? null : new Driver(owner, handle);
            }
        };
    }

    public String toString() {
        Object[] properties;
        try {
            properties = new Object[]{"name", this.getName(), "identifier", this.getIdentifier(), "MIME", this.getMIMEType(), "suffixes", this.getFileSuffixes()};
        }
        catch (DataStoreException e) {
            properties = new Object[]{"error", e};
        }
        return Strings.toString(this.getClass(), (Object[])properties);
    }

    final class FileList
    extends Resource.FileSet {
        private final Path path;
        private final URI location;

        FileList(Path[] paths, Path path, URI location) {
            super(paths);
            this.path = path;
            this.location = location;
        }

        public Path copy(Path destDir) throws IOException {
            Path file = destDir.resolve(this.path.getFileName());
            String target = Opener.toURL(file.toUri(), file, false);
            if (target != null && this.invoke("copy", "GDALCopyDatasetFiles", target)) {
                return file;
            }
            return super.copy(destDir);
        }

        public void delete() throws IOException {
            if (!this.invoke("delete", "GDALDeleteDataset", null)) {
                super.delete();
            }
        }

        private boolean invoke(String caller, String function, String target) {
            int err;
            Optional method = Driver.this.owner.tryGDAL(Driver.class, caller).flatMap(gdal -> gdal.symbols.find(function).map(address -> {
                Object[] signature = new ValueLayout[target != null ? 3 : 2];
                Arrays.fill(signature, ValueLayout.ADDRESS);
                return gdal.linker.downcallHandle((MemorySegment)address, FunctionDescriptor.of(ValueLayout.JAVA_INT, (MemoryLayout[])signature), new Linker.Option[0]);
            }));
            if (method.isEmpty()) {
                return false;
            }
            String url = Opener.toURL(this.location, this.path, true);
            try (Arena arena = Arena.ofConfined();){
                MemorySegment source = arena.allocateFrom(url);
                err = target != null ? ((MethodHandle)method.get()).invokeExact(Driver.this.handle, arena.allocateFrom(target), source) : ((MethodHandle)method.get()).invokeExact(Driver.this.handle, source);
            }
            catch (Throwable e) {
                throw GDAL.propagate(e);
            }
            return err == 0;
        }
    }
}

