/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.internal.shared.FeatureProjection;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.base.XPath;
import org.apache.sis.metadata.sql.internal.shared.SQLBuilder;
import org.apache.sis.pending.jdk.JDK19;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureQuery;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.storage.sql.feature.Analyzer;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.ComputedColumn;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.FeatureAdapter;
import org.apache.sis.storage.sql.feature.FeatureAnalyzer;
import org.apache.sis.storage.sql.feature.FeatureStream;
import org.apache.sis.storage.sql.feature.PrimaryKey;
import org.apache.sis.storage.sql.feature.Relation;
import org.apache.sis.storage.sql.feature.TableReference;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.util.GenericName;

final class Table
extends AbstractFeatureSet {
    final Database<?> database;
    final DefaultFeatureType featureType;
    private final String query;
    final TableReference name;
    final Column[] attributes;
    final PrimaryKey primaryKey;
    final Relation[] importedKeys;
    final Relation[] exportedKeys;
    final boolean hasGeometry;
    final boolean hasRaster;
    private Map<String, Column> attributeToColumns;
    private FeatureAdapter adapter;
    private WeakValueHashMap<?, Object> instanceForPrimaryKeys;
    private boolean isEnvelopeAnalyzed;

    Table(Database<?> database, FeatureAnalyzer analyzer, String query) throws Exception {
        super(database.listeners, false);
        this.database = database;
        this.query = query;
        this.name = analyzer.id;
        this.importedKeys = analyzer.getForeignerKeys(Relation.Direction.IMPORT);
        this.exportedKeys = analyzer.getForeignerKeys(Relation.Direction.EXPORT);
        this.attributes = analyzer.createAttributes();
        this.primaryKey = analyzer.createAssociations(this.exportedKeys);
        this.featureType = analyzer.buildFeatureType();
        this.hasGeometry = analyzer.hasGeometry;
        this.hasRaster = analyzer.hasRaster;
    }

    Table(Table source, FeatureProjection projection, Set<String> reusedNames, BitSet unhandled) {
        super(source.listeners, false);
        this.database = source.database;
        this.query = source.query;
        this.name = source.name;
        this.featureType = projection.typeWithDependencies;
        Object[] attributes = new Column[source.attributes.length];
        Object[] importedKeys = new Relation[source.importedKeys.length];
        Object[] exportedKeys = new Relation[source.exportedKeys.length];
        int attributesCount = 0;
        int importedKeysCount = 0;
        int exportedKeysCount = 0;
        boolean hasGeometry = false;
        List storedProperties = projection.propertiesToCopy();
        int count = storedProperties.size();
        for (int i = 0; i < count; ++i) {
            String xpath = projection.xpath(i).orElse(null);
            if (xpath == null) {
                unhandled.set(i);
                continue;
            }
            Expression expression = projection.expression(i);
            Column column = expression instanceof ComputedColumn ? (ComputedColumn)expression : source.getColumn(xpath);
            if (column != null) {
                hasGeometry |= column.getGeometryType().isPresent();
                String name = (String)storedProperties.get(i);
                Column renamed = column.rename(name);
                attributes[attributesCount++] = renamed;
                if (renamed != column) continue;
                reusedNames.add(name);
                continue;
            }
            Relation relation = source.getRelation(xpath, false);
            if (relation != null) {
                importedKeys[importedKeysCount++] = relation;
                continue;
            }
            relation = source.getRelation(xpath, true);
            if (relation != null) {
                exportedKeys[exportedKeysCount++] = relation;
                continue;
            }
            throw new IllegalArgumentException(Errors.forLocale((Locale)this.listeners.getLocale()).getString((short)149, (Object)source.featureType.getName(), (Object)xpath));
        }
        this.hasGeometry = hasGeometry;
        this.hasRaster = source.hasRaster;
        this.attributes = (Column[])ArraysExt.resize((Object[])attributes, (int)attributesCount);
        this.importedKeys = (Relation[])ArraysExt.resize((Object[])importedKeys, (int)importedKeysCount);
        this.exportedKeys = (Relation[])ArraysExt.resize((Object[])exportedKeys, (int)exportedKeysCount);
        if (source.primaryKey != null) {
            for (String column : source.primaryKey.getColumns()) {
                int i = storedProperties.indexOf(column);
                if (i >= 0 && column.equals(projection.xpath(i).orElse(null))) continue;
                this.primaryKey = null;
                return;
            }
        }
        this.primaryKey = source.primaryKey;
    }

    final void setDeferredSearchTables(Analyzer analyzer, Map<GenericName, Table> tables) throws DataStoreException {
        block8: for (Relation.Direction direction : Relation.Direction.values()) {
            Relation[] relations;
            switch (direction) {
                case IMPORT: {
                    relations = this.importedKeys;
                    break;
                }
                case EXPORT: {
                    relations = this.exportedKeys;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            for (Relation relation : relations) {
                PrimaryKey referenced;
                if (!relation.isSearchTableDeferred()) continue;
                DefaultAssociationRole association = (DefaultAssociationRole)this.featureType.getProperty(relation.getPropertyName());
                Table table = tables.get(association.getValueType().getName());
                if (table == null) {
                    throw new InternalDataStoreException(association.toString());
                }
                switch (direction) {
                    case IMPORT: {
                        referenced = table.primaryKey;
                        break;
                    }
                    case EXPORT: {
                        referenced = this.primaryKey;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)direction);
                    }
                }
                if (referenced == null) continue;
                relation.setSearchTable(analyzer, table, referenced, direction);
            }
        }
    }

    private static void appendAll(TreeTable.Node parent, Relation[] children, String arrow) {
        for (Relation child : children) {
            child.appendTo(parent, arrow);
        }
    }

    final void appendTo(TreeTable.Node parent) {
        parent = Relation.newChild(parent, this.featureType.getName().toString());
        for (Column attribute : this.attributes) {
            TableReference.newChild(parent, attribute.getPropertyName());
        }
        Table.appendAll(parent, this.importedKeys, " \u2192 ");
        Table.appendAll(parent, this.exportedKeys, " \u2190 ");
    }

    public String toString() {
        return TableReference.toString((Object)this, n -> this.appendTo((TreeTable.Node)n));
    }

    public final Optional<GenericName> getIdentifier() {
        return Optional.of(this.featureType.getName().toFullyQualifiedName());
    }

    public final DefaultFeatureType getType() {
        return this.featureType;
    }

    public Optional<Envelope> getEnvelope() throws DataStoreException {
        if (this.hasGeometry) {
            try {
                boolean recall = this.isEnvelopeAnalyzed;
                this.isEnvelopeAnalyzed = true;
                return Optional.ofNullable(this.database.getEstimatedExtent(this.name, this.attributes, recall));
            }
            catch (SQLException e) {
                throw new DataStoreException(e.getMessage(), (Throwable)Exceptions.unwrap((Exception)e));
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Column getColumn(String xpath) {
        HashMap m;
        Table table = this;
        synchronized (table) {
            m = this.attributeToColumns;
            if (m == null) {
                m = JDK19.newHashMap((int)this.attributes.length);
                for (Column c : this.attributes) {
                    String label = c.getPropertyName();
                    m.put(label, c);
                    int s = label.lastIndexOf(58);
                    if (s < 0) continue;
                    m.putIfAbsent(label.substring(s + 1), c);
                }
                this.attributeToColumns = m;
            }
        }
        return (Column)m.get(XPath.toPropertyName((String)xpath));
    }

    private Relation getRelation(String xpath, boolean exports) {
        xpath = XPath.toPropertyName((String)xpath);
        boolean tip = false;
        do {
            for (Relation c : exports ? this.exportedKeys : this.importedKeys) {
                String label = c.getPropertyName();
                if (tip) {
                    label = label.substring(label.lastIndexOf(58) + 1);
                }
                if (!label.equals(xpath)) continue;
                return c;
            }
        } while (tip = !tip);
        return null;
    }

    final Relation getInverseOf(Relation exported, TableReference exportedOwner) {
        if (this.name.equals(exported)) {
            for (Relation relation : this.importedKeys) {
                if (!relation.equals(exportedOwner) || !relation.isInverseOf(exported)) continue;
                return relation;
            }
        }
        return null;
    }

    final synchronized WeakValueHashMap<?, Object> instanceForPrimaryKeys() {
        if (this.instanceForPrimaryKeys == null) {
            this.instanceForPrimaryKeys = new WeakValueHashMap(this.primaryKey.valueClass);
        }
        return this.instanceForPrimaryKeys;
    }

    final void appendFromClause(SQLBuilder sql) {
        sql.append(" FROM ");
        if (this.query != null) {
            sql.append('(').append(this.query).append(") AS USER_QUERY");
        } else {
            sql.appendIdentifier(this.name.catalog, this.name.schema, this.name.table, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final long countRows(DatabaseMetaData metadata, boolean distinct, boolean approximate) throws SQLException {
        long count = -1L;
        String[] names = TableReference.splitName(this.featureType.getName());
        try (ResultSet reflect = metadata.getIndexInfo(names[2], names[1], names[0], distinct, approximate);){
            while (reflect.next()) {
                long n = reflect.getLong("CARDINALITY");
                if (reflect.wasNull()) continue;
                if (reflect.getShort("TYPE") == 0) {
                    long l = n;
                    return l;
                }
                if (n <= count) continue;
                count = n;
            }
            return count;
        }
        catch (SQLFeatureNotSupportedException e) {
            if (this.database.cannotCount) return count;
            this.database.cannotCount = true;
            this.database.listeners.warning((Exception)e);
        }
        return count;
    }

    final synchronized FeatureAdapter adapter(Connection connection) throws SQLException, InternalDataStoreException {
        if (this.adapter == null) {
            this.adapter = new FeatureAdapter(this, connection.getMetaData());
        }
        return this.adapter;
    }

    public Stream<AbstractFeature> features(boolean parallel) {
        return new FeatureStream(this, parallel);
    }

    protected void prepareQueryOptimization(FeatureQuery query, Optimization optimizer) throws DataStoreException {
        optimizer.setFinalFeatureType(this.featureType);
    }
}

