/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.resource;

import jakarta.servlet.http.Part;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StaticResourceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticResourceHandler.class);
    private String webRoot = "webroot/";

    public void setWebRoot(String webRoot) {
        this.webRoot = webRoot;
    }

    protected abstract Part findResource(String var1) throws IOException;

    public Response handle(String path) {
        Part part;
        if (!(path = URI.create(this.webRoot + path).normalize().getPath()).startsWith(this.webRoot)) {
            return Response.failResp((InvocationException)new InvocationException((Response.StatusType)Response.Status.NOT_FOUND, Response.Status.NOT_FOUND.getReasonPhrase()));
        }
        try {
            part = this.findResource(path);
        }
        catch (Throwable e) {
            LOGGER.error("failed to process static resource, path={}", (Object)path, (Object)e);
            return Response.failResp((InvocationException)new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "failed to process static resource."));
        }
        if (part == null) {
            return Response.failResp((InvocationException)new InvocationException((Response.StatusType)Response.Status.NOT_FOUND, Response.Status.NOT_FOUND.getReasonPhrase()));
        }
        return this.handler(part);
    }

    public Response handler(Part part) {
        Response response = Response.ok((Object)part);
        response.setHeader("Content-Type", part.getContentType());
        response.setHeader("Content-Disposition", "inline");
        return response;
    }
}

