/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.adapter.level;

import com.alipay.sofa.common.log.AssertUtil;

public enum AdapterLevel {
    ERROR("error"),
    WARN("warn"),
    INFO("info"),
    DEBUG("debug"),
    TRACE("trace");

    private String logLevelMsg;

    private AdapterLevel(String logLevelMsg) {
        this.logLevelMsg = logLevelMsg;
    }

    public static AdapterLevel getAdapterLevel(String adapterLogLevelMsg) {
        AssertUtil.hasText(adapterLogLevelMsg, "Input Param of AdapterLevel Type can't be blank!");
        for (AdapterLevel adapterLevel : AdapterLevel.values()) {
            if (!adapterLevel.getLogLevelMsg().equals(adapterLogLevelMsg)) continue;
            return adapterLevel;
        }
        throw new IllegalArgumentException("Input Level Message[" + adapterLogLevelMsg + "] can't match any [com.alipay.sofa.common.log.adapter.level.AdapterLevel]");
    }

    public String getLogLevelMsg() {
        return this.logLevelMsg;
    }

    public String toString() {
        return "AdapterLevel{logLevelMsg='" + this.logLevelMsg + '\'' + '}';
    }
}

